/*
 *  /MathJax/config/AM_HTMLorMML-full.js
 *  
 *  Copyright (c) 2010-11 Design Science, Inc.
 *
 *  Part of the MathJax library.
 *  See http://www.mathjax.org for details.
 * 
 *  Licensed under the Apache License, Version 2.0;
 *  you may not use this file except in compliance with the License.
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 */

MathJax.Hub.Config({delayJaxRegistration: true});

MathJax.Ajax.Preloading(
  "[MathJax]/jax/input/AsciiMath/config.js",
  "[MathJax]/jax/output/HTML-CSS/config.js",
  "[MathJax]/jax/output/NativeMML/config.js",
  "[MathJax]/config/MMLorHTML.js",
  "[MathJax]/extensions/asciimath2jax.js",
  "[MathJax]/extensions/MathEvents.js",
  "[MathJax]/extensions/MathZoom.js",
  "[MathJax]/extensions/MathMenu.js",
  "[MathJax]/jax/element/mml/jax.js",
  "[MathJax]/extensions/toMathML.js",
  "[MathJax]/jax/input/AsciiMath/jax.js",
  "[MathJax]/jax/output/NativeMML/jax.js",
  "[MathJax]/jax/output/HTML-CSS/jax.js",
  "[MathJax]/jax/output/HTML-CSS/autoload/mtable.js"
);

MathJax.Hub.Config({"v1.0-compatible":false});

MathJax.InputJax.AsciiMath=MathJax.InputJax({id:"AsciiMath",version:"2.1",directory:MathJax.InputJax.directory+"/AsciiMath",extensionDir:MathJax.InputJax.extensionDir+"/AsciiMath",config:{displaystyle:true,decimal:"."}});MathJax.InputJax.AsciiMath.Register("math/asciimath");MathJax.InputJax.AsciiMath.loadComplete("config.js");

MathJax.OutputJax["HTML-CSS"]=MathJax.OutputJax({id:"HTML-CSS",version:"2.1",directory:MathJax.OutputJax.directory+"/HTML-CSS",extensionDir:MathJax.OutputJax.extensionDir+"/HTML-CSS",autoloadDir:MathJax.OutputJax.directory+"/HTML-CSS/autoload",fontDir:MathJax.OutputJax.directory+"/HTML-CSS/fonts",webfontDir:MathJax.OutputJax.fontDir+"/HTML-CSS",config:{scale:100,minScaleAdjust:50,availableFonts:["STIX","TeX"],preferredFont:"TeX",webFont:"TeX",imageFont:"TeX",undefinedFamily:"STIXGeneral,'Arial Unicode MS',serif",mtextFontInherit:false,EqnChunk:(MathJax.Hub.Browser.isMobile?10:50),EqnChunkFactor:1.5,EqnChunkDelay:100,linebreaks:{automatic:false,width:"container"},styles:{".MathJax_Display":{"text-align":"center",margin:"1em 0em"},".MathJax .merror":{"background-color":"#FFFF88",color:"#CC0000",border:"1px solid #CC0000",padding:"1px 3px","font-style":"normal","font-size":"90%"},"#MathJax_Tooltip":{"background-color":"InfoBackground",color:"InfoText",border:"1px solid black","box-shadow":"2px 2px 5px #AAAAAA","-webkit-box-shadow":"2px 2px 5px #AAAAAA","-moz-box-shadow":"2px 2px 5px #AAAAAA","-khtml-box-shadow":"2px 2px 5px #AAAAAA",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')",padding:"3px 4px"}}}});if(MathJax.Hub.Browser.isMSIE&&document.documentMode>=9){delete MathJax.OutputJax["HTML-CSS"].config.styles["#MathJax_Tooltip"].filter}if(!MathJax.Hub.config.delayJaxRegistration){MathJax.OutputJax["HTML-CSS"].Register("jax/mml")}MathJax.Hub.Register.StartupHook("End Config",[function(b,c){var a=b.Insert({minBrowserVersion:{Firefox:3,Opera:9.52,MSIE:6,Chrome:0.3,Safari:2,Konqueror:4},inlineMathDelimiters:["$","$"],displayMathDelimiters:["$$","$$"],multilineDisplay:true,minBrowserTranslate:function(f){var e=b.getJaxFor(f),k=["[Math]"],j;var h=document.createElement("span",{className:"MathJax_Preview"});if(e.inputJax==="TeX"){if(e.root.Get("displaystyle")){j=a.displayMathDelimiters;k=[j[0]+e.originalText+j[1]];if(a.multilineDisplay){k=k[0].split(/\n/)}}else{j=a.inlineMathDelimiters;k=[j[0]+e.originalText.replace(/^\s+/,"").replace(/\s+$/,"")+j[1]]}}for(var g=0,d=k.length;g<d;g++){h.appendChild(document.createTextNode(k[g]));if(g<d-1){h.appendChild(document.createElement("br"))}}f.parentNode.insertBefore(h,f)}},(b.config["HTML-CSS"]||{}));if(b.Browser.version!=="0.0"&&!b.Browser.versionAtLeast(a.minBrowserVersion[b.Browser]||0)){c.Translate=a.minBrowserTranslate;b.Config({showProcessingMessages:false});MathJax.Message.Set("Your browser does not support MathJax",null,4000);b.Startup.signal.Post("MathJax not supported")}},MathJax.Hub,MathJax.OutputJax["HTML-CSS"]]);MathJax.OutputJax["HTML-CSS"].loadComplete("config.js");

MathJax.OutputJax.NativeMML=MathJax.OutputJax({id:"NativeMML",version:"2.1",directory:MathJax.OutputJax.directory+"/NativeMML",extensionDir:MathJax.OutputJax.extensionDir+"/NativeMML",config:{scale:100,minScaleAdjust:50,styles:{"DIV.MathJax_MathML":{"text-align":"center",margin:".75em 0px"}}}});if(!MathJax.Hub.config.delayJaxRegistration){MathJax.OutputJax.NativeMML.Register("jax/mml")}MathJax.OutputJax.NativeMML.loadComplete("config.js");

(function(c,g){var f="2.1";var a=MathJax.Hub.CombineConfig("MMLorHTML",{prefer:{MSIE:"MML",Firefox:"HTML",Opera:"HTML",Chrome:"HTML",Safari:"HTML",other:"HTML"}});var e={Firefox:3,Opera:9.52,MSIE:6,Chrome:0.3,Safari:2,Konqueror:4};var b=(g.version==="0.0"||g.versionAtLeast(e[g]||0));var d=(g.isFirefox&&g.versionAtLeast("1.5"))||(g.isMSIE&&g.hasMathPlayer)||(g.isSafari&&g.versionAtLeast("5.0"))||(g.isOpera&&g.versionAtLeast("9.52"));c.Register.StartupHook("End Config",function(){var h=(a.prefer&&typeof(a.prefer)==="object"?a.prefer[MathJax.Hub.Browser]||a.prefer.other||"HTML":a.prefer);if(b||d){if(d&&(h==="MML"||!b)){if(MathJax.OutputJax.NativeMML){MathJax.OutputJax.NativeMML.Register("jax/mml")}else{c.config.jax.unshift("output/NativeMML")}c.Startup.signal.Post("NativeMML output selected")}else{if(MathJax.OutputJax["HTML-CSS"]){MathJax.OutputJax["HTML-CSS"].Register("jax/mml")}else{c.config.jax.unshift("output/HTML-CSS")}c.Startup.signal.Post("HTML-CSS output selected")}}else{c.PreProcess.disabled=true;c.prepareScripts.disabled=true;MathJax.Message.Set("Your browser does not support MathJax",null,4000);c.Startup.signal.Post("MathJax not supported")}})})(MathJax.Hub,MathJax.Hub.Browser);MathJax.Ajax.loadComplete("[MathJax]/config/MMLorHTML.js");

MathJax.Extension.asciimath2jax={version:"2.1",config:{delimiters:[["`","`"]],skipTags:["script","noscript","style","textarea","pre","code"],ignoreClass:"asciimath2jax_ignore",processClass:"asciimath2jax_process",preview:"AsciiMath"},PreProcess:function(a){if(!this.configured){this.config=MathJax.Hub.CombineConfig("asciimath2jax",this.config);if(this.config.Augment){MathJax.Hub.Insert(this,this.config.Augment)}this.configured=true}if(typeof(a)==="string"){a=document.getElementById(a)}if(!a){a=document.body}if(this.createPatterns()){this.scanElement(a,a.nextSibling)}},createPatterns:function(){var d=[],c,a,b=this.config;this.match={};if(b.delimiters.length===0){return false}for(c=0,a=b.delimiters.length;c<a;c++){d.push(this.patternQuote(b.delimiters[c][0]));this.match[b.delimiters[c][0]]={mode:"",end:b.delimiters[c][1],pattern:this.endPattern(b.delimiters[c][1])}}this.start=new RegExp(d.sort(this.sortLength).join("|"),"g");this.skipTags=new RegExp("^("+b.skipTags.join("|")+")$","i");this.ignoreClass=new RegExp("(^| )("+b.ignoreClass+")( |$)");this.processClass=new RegExp("(^| )("+b.processClass+")( |$)");return true},patternQuote:function(a){return a.replace(/([\^$(){}+*?\-|\[\]\:\\])/g,"\\$1")},endPattern:function(a){return new RegExp(this.patternQuote(a)+"|\\\\.","g")},sortLength:function(d,c){if(d.length!==c.length){return c.length-d.length}return(d==c?0:(d<c?-1:1))},scanElement:function(c,b,g){var a,e,d,f;while(c&&c!=b){if(c.nodeName.toLowerCase()==="#text"){if(!g){c=this.scanText(c)}}else{a=(typeof(c.className)==="undefined"?"":c.className);e=(typeof(c.tagName)==="undefined"?"":c.tagName);if(typeof(a)!=="string"){a=String(a)}f=this.processClass.exec(a);if(c.firstChild&&!a.match(/(^| )MathJax/)&&(f||!this.skipTags.exec(e))){d=(g||this.ignoreClass.exec(a))&&!f;this.scanElement(c.firstChild,b,d)}}if(c){c=c.nextSibling}}},scanText:function(b){if(b.nodeValue.replace(/\s+/,"")==""){return b}var a,c;this.search={start:true};this.pattern=this.start;while(b){this.pattern.lastIndex=0;while(b&&b.nodeName.toLowerCase()==="#text"&&(a=this.pattern.exec(b.nodeValue))){if(this.search.start){b=this.startMatch(a,b)}else{b=this.endMatch(a,b)}}if(this.search.matched){b=this.encloseMath(b)}if(b){do{c=b;b=b.nextSibling}while(b&&(b.nodeName.toLowerCase()==="br"||b.nodeName.toLowerCase()==="#comment"));if(!b||b.nodeName!=="#text"){return c}}}return b},startMatch:function(a,b){var c=this.match[a[0]];if(c!=null){this.search={end:c.end,mode:c.mode,open:b,olen:a[0].length,opos:this.pattern.lastIndex-a[0].length};this.switchPattern(c.pattern)}return b},endMatch:function(a,b){if(a[0]==this.search.end){this.search.close=b;this.search.cpos=this.pattern.lastIndex;this.search.clen=(this.search.isBeginEnd?0:a[0].length);this.search.matched=true;b=this.encloseMath(b);this.switchPattern(this.start)}return b},switchPattern:function(a){a.lastIndex=this.pattern.lastIndex;this.pattern=a;this.search.start=(a===this.start)},encloseMath:function(b){var a=this.search,f=a.close,e,c;if(a.cpos===f.length){f=f.nextSibling}else{f=f.splitText(a.cpos)}if(!f){e=f=MathJax.HTML.addText(a.close.parentNode,"")}a.close=f;c=(a.opos?a.open.splitText(a.opos):a.open);while(c.nextSibling&&c.nextSibling!==f){if(c.nextSibling.nodeValue!==null){if(c.nextSibling.nodeName==="#comment"){c.nodeValue+=c.nextSibling.nodeValue.replace(/^\[CDATA\[((.|\n|\r)*)\]\]$/,"$1")}else{c.nodeValue+=c.nextSibling.nodeValue}}else{if(this.msieNewlineBug){c.nodeValue+=(c.nextSibling.nodeName.toLowerCase()==="br"?"\n":" ")}else{c.nodeValue+=" "}}c.parentNode.removeChild(c.nextSibling)}var d=c.nodeValue.substr(a.olen,c.nodeValue.length-a.olen-a.clen);c.parentNode.removeChild(c);if(this.config.preview!=="none"){this.createPreview(a.mode,d)}c=this.createMathTag(a.mode,d);this.search={};this.pattern.lastIndex=0;if(e){e.parentNode.removeChild(e)}return c},insertNode:function(b){var a=this.search;a.close.parentNode.insertBefore(b,a.close)},createPreview:function(c,a){var b;if(this.config.preview==="AsciiMath"){b=[this.filterPreview(a)]}else{if(this.config.preview instanceof Array){b=this.config.preview}}if(b){b=MathJax.HTML.Element("span",{className:MathJax.Hub.config.preRemoveClass},b);this.insertNode(b)}},createMathTag:function(c,a){var b=document.createElement("script");b.type="math/asciimath"+c;MathJax.HTML.setScript(b,a);this.insertNode(b);return b},filterPreview:function(a){return a},msieNewlineBug:(MathJax.Hub.Browser.isMSIE&&(document.documentMode||0)<9)};MathJax.Hub.Register.PreProcessor(["PreProcess",MathJax.Extension.asciimath2jax]);MathJax.Ajax.loadComplete("[MathJax]/extensions/asciimath2jax.js");

(function(d,h,l,g,b,j){var p="2.1";var i=MathJax.Extension;var c=i.MathEvents={version:p};var k=d.config.menuSettings;var o={hover:500,frame:{x:3.5,y:5,bwidth:1,bcolor:"#A6D",hwidth:"15px",hcolor:"#83A"},button:{x:-4,y:-3,wx:-2,src:l.fileURL(b.imageDir+"/MenuArrow-15.png")},fadeinInc:0.2,fadeoutInc:0.05,fadeDelay:50,fadeoutStart:400,fadeoutDelay:15*1000,styles:{".MathJax_Hover_Frame":{"border-radius":".25em","-webkit-border-radius":".25em","-moz-border-radius":".25em","-khtml-border-radius":".25em","box-shadow":"0px 0px 15px #83A","-webkit-box-shadow":"0px 0px 15px #83A","-moz-box-shadow":"0px 0px 15px #83A","-khtml-box-shadow":"0px 0px 15px #83A",border:"1px solid #A6D ! important",display:"inline-block",position:"absolute"},".MathJax_Hover_Arrow":{position:"absolute",width:"15px",height:"11px",cursor:"pointer"}}};var m=c.Event={LEFTBUTTON:0,RIGHTBUTTON:2,MENUKEY:"altKey",Mousedown:function(q){return m.Handler(q,"Mousedown",this)},Mouseup:function(q){return m.Handler(q,"Mouseup",this)},Mousemove:function(q){return m.Handler(q,"Mousemove",this)},Mouseover:function(q){return m.Handler(q,"Mouseover",this)},Mouseout:function(q){return m.Handler(q,"Mouseout",this)},Click:function(q){return m.Handler(q,"Click",this)},DblClick:function(q){return m.Handler(q,"DblClick",this)},Menu:function(q){return m.Handler(q,"ContextMenu",this)},Handler:function(t,r,s){if(l.loadingMathMenu){return m.False(t)}var q=b[s.jaxID];if(!t){t=window.event}t.isContextMenu=(r==="ContextMenu");if(q[r]){return q[r](t,s)}if(i.MathZoom){return i.MathZoom.HandleEvent(t,r,s)}},False:function(q){if(!q){q=window.event}if(q){if(q.preventDefault){q.preventDefault()}if(q.stopPropagation){q.stopPropagation()}q.cancelBubble=true;q.returnValue=false}return false},ContextMenu:function(r,y,u){var w=b[y.jaxID],t=w.getJaxFromMath(y);var z=(w.config.showMathMenu!=null?w:d).config.showMathMenu;if(!z||(k.context!=="MathJax"&&!u)){return}if(c.msieEventBug){r=window.event||r}m.ClearSelection();f.ClearHoverTimer();if(t.hover){if(t.hover.remove){clearTimeout(t.hover.remove);delete t.hover.remove}t.hover.nofade=true}var s=MathJax.Menu;if(s){s.jax=t;var q=s.menu.Find("Show Math As").menu;q.items[1].name=(j[t.inputJax].sourceMenuTitle||"Original Form");q.items[0].hidden=(t.inputJax==="Error");var v=s.menu.Find("Math Settings","MathPlayer");v.hidden=!(t.outputJax==="NativeMML"&&d.Browser.hasMathPlayer);return s.menu.Post(r)}else{if(!l.loadingMathMenu){l.loadingMathMenu=true;var x={pageX:r.pageX,pageY:r.pageY,clientX:r.clientX,clientY:r.clientY};g.Queue(l.Require("[MathJax]/extensions/MathMenu.js"),function(){delete l.loadingMathMenu;if(!MathJax.Menu){MathJax.Menu={}}},["ContextMenu",this,x,y,u])}return m.False(r)}},AltContextMenu:function(s,r){var t=b[r.jaxID];var q=(t.config.showMathMenu!=null?t:d).config.showMathMenu;if(q){q=(t.config.showMathMenuMSIE!=null?t:d).config.showMathMenuMSIE;if(k.context==="MathJax"&&!k.mpContext&&q){if(!c.noContextMenuBug||s.button!==m.RIGHTBUTTON){return}}else{if(!s[m.MENUKEY]||s.button!==m.LEFTBUTTON){return}}return t.ContextMenu(s,r,true)}},ClearSelection:function(){if(c.safariContextMenuBug){setTimeout("window.getSelection().empty()",0)}if(document.selection){setTimeout("document.selection.empty()",0)}},getBBox:function(s){s.appendChild(c.topImg);var r=c.topImg.offsetTop,t=s.offsetHeight-r,q=s.offsetWidth;s.removeChild(c.topImg);return{w:q,h:r,d:t}}};var f=c.Hover={Mouseover:function(s,r){if(k.discoverable||k.zoom==="Hover"){var u=s.fromElement||s.relatedTarget,t=s.toElement||s.target;if(u&&t&&(u.isMathJax!=t.isMathJax||d.getJaxFor(u)!==d.getJaxFor(t))){var q=this.getJaxFromMath(r);if(q.hover){f.ReHover(q)}else{f.HoverTimer(q,r)}return m.False(s)}}},Mouseout:function(s,r){if(k.discoverable||k.zoom==="Hover"){var u=s.fromElement||s.relatedTarget,t=s.toElement||s.target;if(u&&t&&(u.isMathJax!=t.isMathJax||d.getJaxFor(u)!==d.getJaxFor(t))){var q=this.getJaxFromMath(r);if(q.hover){f.UnHover(q)}else{f.ClearHoverTimer()}return m.False(s)}}},Mousemove:function(s,r){if(k.discoverable||k.zoom==="Hover"){var q=this.getJaxFromMath(r);if(q.hover){return}if(f.lastX==s.clientX&&f.lastY==s.clientY){return}f.lastX=s.clientX;f.lastY=s.clientY;f.HoverTimer(q,r);return m.False(s)}},HoverTimer:function(q,r){this.ClearHoverTimer();this.hoverTimer=setTimeout(g(["Hover",this,q,r]),o.hover)},ClearHoverTimer:function(){if(this.hoverTimer){clearTimeout(this.hoverTimer);delete this.hoverTimer}},Hover:function(q,u){if(i.MathZoom&&i.MathZoom.Hover({},u)){return}var t=b[q.outputJax],v=t.getHoverSpan(q,u),y=t.getHoverBBox(q,v,u),w=(t.config.showMathMenu!=null?t:d).config.showMathMenu;var A=o.frame.x,z=o.frame.y,x=o.frame.bwidth;if(c.msieBorderWidthBug){x=0}q.hover={opacity:0,id:q.inputID+"-Hover"};var r=h.Element("span",{id:q.hover.id,isMathJax:true,style:{display:"inline-block",width:0,height:0,position:"relative"}},[["span",{className:"MathJax_Hover_Frame",isMathJax:true,style:{display:"inline-block",position:"absolute",top:this.Px(-y.h-z-x-(y.y||0)),left:this.Px(-A-x+(y.x||0)),width:this.Px(y.w+2*A),height:this.Px(y.h+y.d+2*z),opacity:0,filter:"alpha(opacity=0)"}}]]);var s=h.Element("span",{isMathJax:true,id:q.hover.id+"Menu",style:{display:"inline-block","z-index":1,width:0,height:0,position:"relative"}},[["img",{className:"MathJax_Hover_Arrow",isMathJax:true,math:u,src:o.button.src,onclick:this.HoverMenu,jax:t.id,style:{left:this.Px(y.w+A+x+(y.x||0)+o.button.x),top:this.Px(-y.h-z-x-(y.y||0)-o.button.y),opacity:0,filter:"alpha(opacity=0)"}}]]);if(y.width){r.style.width=s.style.width=y.width;r.style.marginRight=s.style.marginRight="-"+y.width;r.firstChild.style.width=y.width;s.firstChild.style.left="";s.firstChild.style.right=this.Px(o.button.wx)}v.parentNode.insertBefore(r,v);if(w){v.parentNode.insertBefore(s,v)}if(v.style){v.style.position="relative"}this.ReHover(q)},ReHover:function(q){if(q.hover.remove){clearTimeout(q.hover.remove)}q.hover.remove=setTimeout(g(["UnHover",this,q]),o.fadeoutDelay);this.HoverFadeTimer(q,o.fadeinInc)},UnHover:function(q){if(!q.hover.nofade){this.HoverFadeTimer(q,-o.fadeoutInc,o.fadeoutStart)}},HoverFade:function(q){delete q.hover.timer;q.hover.opacity=Math.max(0,Math.min(1,q.hover.opacity+q.hover.inc));q.hover.opacity=Math.floor(1000*q.hover.opacity)/1000;var s=document.getElementById(q.hover.id),r=document.getElementById(q.hover.id+"Menu");s.firstChild.style.opacity=q.hover.opacity;s.firstChild.style.filter="alpha(opacity="+Math.floor(100*q.hover.opacity)+")";if(r){r.firstChild.style.opacity=q.hover.opacity;r.firstChild.style.filter=s.style.filter}if(q.hover.opacity===1){return}if(q.hover.opacity>0){this.HoverFadeTimer(q,q.hover.inc);return}s.parentNode.removeChild(s);if(r){r.parentNode.removeChild(r)}if(q.hover.remove){clearTimeout(q.hover.remove)}delete q.hover},HoverFadeTimer:function(q,s,r){q.hover.inc=s;if(!q.hover.timer){q.hover.timer=setTimeout(g(["HoverFade",this,q]),(r||o.fadeDelay))}},HoverMenu:function(q){if(!q){q=window.event}return b[this.jax].ContextMenu(q,this.math,true)},ClearHover:function(q){if(q.hover.remove){clearTimeout(q.hover.remove)}if(q.hover.timer){clearTimeout(q.hover.timer)}f.ClearHoverTimer();delete q.hover},Px:function(q){if(Math.abs(q)<0.006){return"0px"}return q.toFixed(2).replace(/\.?0+$/,"")+"px"},getImages:function(){var q=new Image();q.src=o.button.src}};var a=c.Touch={last:0,delay:500,start:function(r){var q=new Date().getTime();var s=(q-a.last<a.delay&&a.up);a.last=q;a.up=false;if(s){a.timeout=setTimeout(a.menu,a.delay,r,this);r.preventDefault()}},end:function(r){var q=new Date().getTime();a.up=(q-a.last<a.delay);if(a.timeout){clearTimeout(a.timeout);delete a.timeout;a.last=0;a.up=false;r.preventDefault();return m.Handler((r.touches[0]||r.touch),"DblClick",this)}},menu:function(r,q){delete a.timeout;a.last=0;a.up=false;return m.Handler((r.touches[0]||r.touch),"ContextMenu",q)}};if(d.Browser.isMobile){var n=o.styles[".MathJax_Hover_Arrow"];n.width="25px";n.height="18px";o.button.x=-6}d.Browser.Select({MSIE:function(q){var s=(document.documentMode||0);var r=q.versionAtLeast("8.0");c.msieBorderWidthBug=(document.compatMode==="BackCompat");c.msieEventBug=q.isIE9;c.msieAlignBug=(!r||s<8);if(s<9){m.LEFTBUTTON=1}},Safari:function(q){c.safariContextMenuBug=true},Opera:function(q){c.operaPositionBug=true},Konqueror:function(q){c.noContextMenuBug=true}});c.topImg=(c.msieAlignBug?h.Element("img",{style:{width:0,height:0,position:"relative"},src:"about:blank"}):h.Element("span",{style:{width:0,height:0,display:"inline-block"}}));if(c.operaPositionBug){c.topImg.style.border="1px solid"}c.config=o=d.CombineConfig("MathEvents",o);var e=function(){var q=o.styles[".MathJax_Hover_Frame"];q.border=o.frame.bwidth+"px solid "+o.frame.bcolor+" ! important";q["box-shadow"]=q["-webkit-box-shadow"]=q["-moz-box-shadow"]=q["-khtml-box-shadow"]="0px 0px "+o.frame.hwidth+" "+o.frame.hcolor};g.Queue(d.Register.StartupHook("End Config",{}),[e],["getImages",f],["Styles",l,o.styles],["Post",d.Startup.signal,"MathEvents Ready"],["loadComplete",l,"[MathJax]/extensions/MathEvents.js"])})(MathJax.Hub,MathJax.HTML,MathJax.Ajax,MathJax.Callback,MathJax.OutputJax,MathJax.InputJax);

(function(a,d,f,c,j){var k="2.1";var i=a.CombineConfig("MathZoom",{styles:{"#MathJax_Zoom":{position:"absolute","background-color":"#F0F0F0",overflow:"auto",display:"block","z-index":301,padding:".5em",border:"1px solid black",margin:0,"font-weight":"normal","font-style":"normal","text-align":"left","text-indent":0,"text-transform":"none","line-height":"normal","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none","box-shadow":"5px 5px 15px #AAAAAA","-webkit-box-shadow":"5px 5px 15px #AAAAAA","-moz-box-shadow":"5px 5px 15px #AAAAAA","-khtml-box-shadow":"5px 5px 15px #AAAAAA",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')"},"#MathJax_ZoomOverlay":{position:"absolute",left:0,top:0,"z-index":300,display:"inline-block",width:"100%",height:"100%",border:0,padding:0,margin:0,"background-color":"white",opacity:0,filter:"alpha(opacity=0)"},"#MathJax_ZoomEventTrap":{position:"absolute",left:0,top:0,"z-index":302,display:"inline-block",border:0,padding:0,margin:0,"background-color":"white",opacity:0,filter:"alpha(opacity=0)"}}});var e,b,g;MathJax.Hub.Register.StartupHook("MathEvents Ready",function(){g=MathJax.Extension.MathEvents.Event;e=MathJax.Extension.MathEvents.Event.False;b=MathJax.Extension.MathEvents.Hover});var h=MathJax.Extension.MathZoom={version:k,settings:a.config.menuSettings,scrollSize:18,HandleEvent:function(n,l,m){if(h.settings.CTRL&&!n.ctrlKey){return true}if(h.settings.ALT&&!n.altKey){return true}if(h.settings.CMD&&!n.metaKey){return true}if(h.settings.Shift&&!n.shiftKey){return true}if(!h[l]){return true}return h[l](n,m)},Click:function(m,l){if(this.settings.zoom==="Click"){return this.Zoom(m,l)}},DblClick:function(m,l){if(this.settings.zoom==="Double-Click"){return this.Zoom(m,l)}},Hover:function(m,l){if(this.settings.zoom==="Hover"){this.Zoom(m,l);return true}return false},Zoom:function(n,s){this.Remove();b.ClearHoverTimer();g.ClearSelection();var q=MathJax.OutputJax[s.jaxID];var o=q.getJaxFromMath(s);if(o.hover){b.UnHover(o)}var l=Math.floor(0.85*document.body.clientWidth),r=Math.floor(0.85*Math.max(document.body.clientHeight,document.documentElement.clientHeight));var m=d.Element("span",{style:{position:"relative",display:"inline-block",height:0,width:0},id:"MathJax_ZoomFrame"},[["span",{id:"MathJax_ZoomOverlay",onmousedown:this.Remove}],["span",{id:"MathJax_Zoom",onclick:this.Remove,style:{visibility:"hidden",fontSize:this.settings.zscale,"max-width":l+"px","max-height":r+"px"}},[["span",{style:{display:"inline-block","white-space":"nowrap"}}]]]]);var x=m.lastChild,u=x.firstChild,p=m.firstChild;s.parentNode.insertBefore(m,s);s.parentNode.insertBefore(s,m);if(u.addEventListener){u.addEventListener("mousedown",this.Remove,true)}if(this.msieTrapEventBug){var w=d.Element("span",{id:"MathJax_ZoomEventTrap",onmousedown:this.Remove});m.insertBefore(w,x)}if(this.msieZIndexBug){var t=d.addElement(document.body,"img",{src:"about:blank",id:"MathJax_ZoomTracker",width:0,height:0,style:{width:0,height:0,position:"relative"}});m.style.position="relative";m.style.zIndex=i.styles["#MathJax_ZoomOverlay"]["z-index"];m=t}var v=q.Zoom(o,u,s,l,r);if(this.msiePositionBug){if(this.msieSizeBug){x.style.height=v.zH+"px";x.style.width=v.zW+"px"}if(x.offsetHeight>r){x.style.height=r+"px";x.style.width=(v.zW+this.scrollSize)+"px"}if(x.offsetWidth>l){x.style.width=l+"px";x.style.height=(v.zH+this.scrollSize)+"px"}}if(this.operaPositionBug){x.style.width=Math.min(l,v.zW)+"px"}if(x.offsetWidth<l&&x.offsetHeight<r){x.style.overflow="visible"}this.Position(x,v);if(this.msieTrapEventBug){w.style.height=x.clientHeight+"px";w.style.width=x.clientWidth+"px";w.style.left=(parseFloat(x.style.left)+x.clientLeft)+"px";w.style.top=(parseFloat(x.style.top)+x.clientTop)+"px"}x.style.visibility="";if(this.settings.zoom==="Hover"){p.onmouseover=this.Remove}if(window.addEventListener){addEventListener("resize",this.Resize,false)}else{if(window.attachEvent){attachEvent("onresize",this.Resize)}else{this.onresize=window.onresize;window.onresize=this.Resize}}a.signal.Post(["math zoomed",o]);return e(n)},Position:function(p,r){var q=this.Resize(),m=q.x,s=q.y,l=r.mW;var o=-l-Math.floor((p.offsetWidth-l)/2),n=r.Y;p.style.left=Math.max(o,10-m)+"px";p.style.top=Math.max(n,10-s)+"px";if(!h.msiePositionBug){h.SetWH()}},Resize:function(n){if(h.onresize){h.onresize(n)}var l=0,q=0,o,p=document.getElementById("MathJax_ZoomFrame"),m=document.getElementById("MathJax_ZoomOverlay");o=p;while(o.offsetParent){l+=o.offsetLeft;o=o.offsetParent}if(h.operaPositionBug){p.style.border="1px solid"}o=p;while(o.offsetParent){q+=o.offsetTop;o=o.offsetParent}if(h.operaPositionBug){p.style.border=""}m.style.left=(-l)+"px";m.style.top=(-q)+"px";if(h.msiePositionBug){setTimeout(h.SetWH,0)}else{h.SetWH()}return{x:l,y:q}},SetWH:function(){var l=document.getElementById("MathJax_ZoomOverlay");l.style.width=l.style.height="1px";var m=document.documentElement||document.body;l.style.width=m.scrollWidth+"px";l.style.height=Math.max(m.clientHeight,m.scrollHeight)+"px"},Remove:function(n){var p=document.getElementById("MathJax_ZoomFrame");if(p){var o=MathJax.OutputJax[p.previousSibling.jaxID];var l=o.getJaxFromMath(p.previousSibling);a.signal.Post(["math unzoomed",l]);p.parentNode.removeChild(p);p=document.getElementById("MathJax_ZoomTracker");if(p){p.parentNode.removeChild(p)}if(h.operaRefreshBug){var m=d.addElement(document.body,"div",{style:{position:"fixed",left:0,top:0,width:"100%",height:"100%",backgroundColor:"white",opacity:0},id:"MathJax_OperaDiv"});document.body.removeChild(m)}if(window.removeEventListener){removeEventListener("resize",h.Resize,false)}else{if(window.detachEvent){detachEvent("onresize",h.Resize)}else{window.onresize=h.onresize;delete h.onresize}}}return e(n)}};a.Browser.Select({MSIE:function(l){var n=(document.documentMode||0);var m=(n>=9);h.msiePositionBug=!m;h.msieSizeBug=l.versionAtLeast("7.0")&&(!document.documentMode||n===7||n===8);h.msieZIndexBug=(n<=7);h.msieInlineBlockAlignBug=(n<=7);h.msieTrapEventBug=!window.addEventListener;if(document.compatMode==="BackCompat"){h.scrollSize=52}if(m){delete i.styles["#MathJax_Zoom"].filter}},Opera:function(l){h.operaPositionBug=true;h.operaRefreshBug=true}});h.topImg=(h.msieInlineBlockAlignBug?d.Element("img",{style:{width:0,height:0,position:"relative"},src:"about:blank"}):d.Element("span",{style:{width:0,height:0,display:"inline-block"}}));if(h.operaPositionBug||h.msieTopBug){h.topImg.style.border="1px solid"}MathJax.Callback.Queue(["StartupHook",MathJax.Hub.Register,"Begin Styles",{}],["Styles",f,i.styles],["Post",a.Startup.signal,"MathZoom Ready"],["loadComplete",f,"[MathJax]/extensions/MathZoom.js"])})(MathJax.Hub,MathJax.HTML,MathJax.Ajax,MathJax.OutputJax["HTML-CSS"],MathJax.OutputJax.NativeMML);

(function(c,g,k,f,b){var p="2.1";var j=MathJax.Callback.Signal("menu");MathJax.Extension.MathMenu={version:p,signal:j};var n=c.Browser.isPC,l=c.Browser.isMSIE,e=((document.documentMode||0)>8);var i=(n?null:"5px");var o=c.CombineConfig("MathMenu",{delay:150,helpURL:"http://www.mathjax.org/help-v2/user/",closeImg:k.fileURL(b.imageDir+"/CloseX-31.png"),showRenderer:true,showMathPlayer:true,showFontMenu:false,showContext:false,showDiscoverable:false,windowSettings:{status:"no",toolbar:"no",locationbar:"no",menubar:"no",directories:"no",personalbar:"no",resizable:"yes",scrollbars:"yes",width:400,height:300,left:Math.round((screen.width-400)/2),top:Math.round((screen.height-300)/3)},styles:{"#MathJax_About":{position:"fixed",left:"50%",width:"auto","text-align":"center",border:"3px outset",padding:"1em 2em","background-color":"#DDDDDD",color:"black",cursor:"default","font-family":"message-box","font-size":"120%","font-style":"normal","text-indent":0,"text-transform":"none","line-height":"normal","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none","z-index":201,"border-radius":"15px","-webkit-border-radius":"15px","-moz-border-radius":"15px","-khtml-border-radius":"15px","box-shadow":"0px 10px 20px #808080","-webkit-box-shadow":"0px 10px 20px #808080","-moz-box-shadow":"0px 10px 20px #808080","-khtml-box-shadow":"0px 10px 20px #808080",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')"},".MathJax_Menu":{position:"absolute","background-color":"white",color:"black",width:"auto",padding:(n?"2px":"5px 0px"),border:"1px solid #CCCCCC",margin:0,cursor:"default",font:"menu","text-align":"left","text-indent":0,"text-transform":"none","line-height":"normal","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none","z-index":201,"border-radius":i,"-webkit-border-radius":i,"-moz-border-radius":i,"-khtml-border-radius":i,"box-shadow":"0px 10px 20px #808080","-webkit-box-shadow":"0px 10px 20px #808080","-moz-box-shadow":"0px 10px 20px #808080","-khtml-box-shadow":"0px 10px 20px #808080",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')"},".MathJax_MenuItem":{padding:(n?"2px 2em":"1px 2em"),background:"transparent"},".MathJax_MenuTitle":{"background-color":"#CCCCCC",margin:(n?"-1px -1px 1px -1px":"-5px 0 0 0"),"text-align":"center","font-style":"italic","font-size":"80%",color:"#444444",padding:"2px 0",overflow:"hidden"},".MathJax_MenuArrow":{position:"absolute",right:".5em",color:"#666666","font-family":(l?"'Arial unicode MS'":null)},".MathJax_MenuActive .MathJax_MenuArrow":{color:"white"},".MathJax_MenuCheck":{position:"absolute",left:".7em","font-family":(l?"'Arial unicode MS'":null)},".MathJax_MenuRadioCheck":{position:"absolute",left:(n?"1em":".7em")},".MathJax_MenuLabel":{padding:(n?"2px 2em 4px 1.33em":"1px 2em 3px 1.33em"),"font-style":"italic"},".MathJax_MenuRule":{"border-top":(n?"1px solid #CCCCCC":"1px solid #DDDDDD"),margin:(n?"4px 1px 0px":"4px 3px")},".MathJax_MenuDisabled":{color:"GrayText"},".MathJax_MenuActive":{"background-color":(n?"Highlight":"#606872"),color:(n?"HighlightText":"white")},".MathJax_Menu_Close":{position:"absolute",width:"31px",height:"31px",top:"-15px",left:"-15px"}}});var h,d;c.Register.StartupHook("MathEvents Ready",function(){h=MathJax.Extension.MathEvents.Event.False;d=MathJax.Extension.MathEvents.Hover});var a=MathJax.Menu=MathJax.Object.Subclass({version:p,items:[],posted:false,title:null,margin:5,Init:function(q){this.items=[].slice.call(arguments,0)},With:function(q){if(q){c.Insert(this,q)}return this},Post:function(r,B){if(!r){r=window.event}var z=(!this.title?null:[["div",{className:"MathJax_MenuTitle"},[this.title]]]);var q=document.getElementById("MathJax_MenuFrame");if(!q){q=a.Background(this);delete m.lastItem;delete m.lastMenu;delete a.skipUp;j.Post(["post",a.jax])}var s=g.addElement(q,"div",{onmouseup:a.Mouseup,ondblclick:h,ondragstart:h,onselectstart:h,oncontextmenu:h,menuItem:this,className:"MathJax_Menu"},z);for(var u=0,t=this.items.length;u<t;u++){this.items[u].Create(s)}if(a.isMobile){g.addElement(s,"span",{className:"MathJax_Menu_Close",menu:B,ontouchstart:a.Close,ontouchend:h,onmousedown:a.Close,onmouseup:h},[["img",{src:o.closeImg,style:{width:"100%",height:"100%"}}]])}this.posted=true;s.style.width=(s.offsetWidth+2)+"px";var A=r.pageX,w=r.pageY;if(!A&&!w){A=r.clientX+document.body.scrollLeft+document.documentElement.scrollLeft;w=r.clientY+document.body.scrollTop+document.documentElement.scrollTop}if(!B){if(A+s.offsetWidth>document.body.offsetWidth-this.margin){A=document.body.offsetWidth-s.offsetWidth-this.margin}if(a.isMobile){A=Math.max(5,A-Math.floor(s.offsetWidth/2));w-=20}a.skipUp=r.isContextMenu}else{var v="left",C=B.offsetWidth;A=(a.isMobile?30:C-2);w=0;while(B&&B!==q){A+=B.offsetLeft;w+=B.offsetTop;B=B.parentNode}if(A+s.offsetWidth>document.body.offsetWidth-this.margin&&!a.isMobile){v="right";A=Math.max(this.margin,A-C-s.offsetWidth+6)}if(!n){s.style["borderRadiusTop"+v]=0;s.style["WebkitBorderRadiusTop"+v]=0;s.style["MozBorderRadiusTop"+v]=0;s.style["KhtmlBorderRadiusTop"+v]=0}}s.style.left=A+"px";s.style.top=w+"px";if(document.selection&&document.selection.empty){document.selection.empty()}return h(r)},Remove:function(q,r){j.Post(["unpost",a.jax]);var s=document.getElementById("MathJax_MenuFrame");if(s){s.parentNode.removeChild(s);if(this.msieFixedPositionBug){detachEvent("onresize",a.Resize)}}if(a.jax.hover){delete a.jax.hover.nofade;d.UnHover(a.jax)}return h(q)},Find:function(r){var t=[].slice.call(arguments,1);for(var s=0,q=this.items.length;s<q;s++){if(this.items[s].name===r){if(t.length){if(!this.items[s].menu){return null}return this.items[s].menu.Find.apply(this.items[s].menu,t)}return this.items[s]}}return null},IndexOf:function(r){for(var s=0,q=this.items.length;s<q;s++){if(this.items[s].name===r){return s}}return null}},{config:o,div:null,Close:function(q){return a.Event(q,this.menu||this.parentNode,(this.menu?"Touchend":"Remove"))},Remove:function(q){return a.Event(q,this,"Remove")},Mouseover:function(q){return a.Event(q,this,"Mouseover")},Mouseout:function(q){return a.Event(q,this,"Mouseout")},Mousedown:function(q){return a.Event(q,this,"Mousedown")},Mouseup:function(q){return a.Event(q,this,"Mouseup")},Touchstart:function(q){return a.Event(q,this,"Touchstart")},Touchend:function(q){return a.Event(q,this,"Touchend")},Event:function(s,u,q,t){if(a.skipMouseover&&q==="Mouseover"&&!t){return h(s)}if(a.skipUp){if(q.match(/Mouseup|Touchend/)){delete a.skipUp;return h(s)}if(q==="Touchstart"||(q==="Mousedown"&&!a.skipMousedown)){delete a.skipUp}}if(!s){s=window.event}var r=u.menuItem;if(r&&r[q]){return r[q](s,u)}return null},BGSTYLE:{position:"absolute",left:0,top:0,"z-index":200,width:"100%",height:"100%",border:0,padding:0,margin:0},Background:function(r){var s=g.addElement(document.body,"div",{style:this.BGSTYLE,id:"MathJax_MenuFrame"},[["div",{style:this.BGSTYLE,menuItem:r,onmousedown:this.Remove}]]);var q=s.firstChild;if(r.msieBackgroundBug){q.style.backgroundColor="white";q.style.filter="alpha(opacity=0)"}if(r.msieFixedPositionBug){s.width=s.height=0;this.Resize();attachEvent("onresize",this.Resize)}else{q.style.position="fixed"}return s},Resize:function(){setTimeout(a.SetWH,0)},SetWH:function(){var q=document.getElementById("MathJax_MenuFrame");if(q){q=q.firstChild;q.style.width=q.style.height="1px";q.style.width=document.body.scrollWidth+"px";q.style.height=document.body.scrollHeight+"px"}},saveCookie:function(){g.Cookie.Set("menu",this.cookie)},getCookie:function(){this.cookie=g.Cookie.Get("menu")},getImages:function(){if(a.isMobile){var q=new Image();q.src=o.closeImg}}});var m=a.ITEM=MathJax.Object.Subclass({name:"",Create:function(r){if(!this.hidden){var q={onmouseover:a.Mouseover,onmouseout:a.Mouseout,onmouseup:a.Mouseup,onmousedown:a.Mousedown,ondragstart:h,onselectstart:h,onselectend:h,ontouchstart:a.Touchstart,ontouchend:a.Touchend,className:"MathJax_MenuItem",menuItem:this};if(this.disabled){q.className+=" MathJax_MenuDisabled"}g.addElement(r,"div",q,this.Label(q,r))}},Mouseover:function(u,w){if(!this.disabled){this.Activate(w)}if(!this.menu||!this.menu.posted){var v=document.getElementById("MathJax_MenuFrame").childNodes,r=w.parentNode.childNodes;for(var s=0,q=r.length;s<q;s++){var t=r[s].menuItem;if(t&&t.menu&&t.menu.posted){t.Deactivate(r[s])}}q=v.length-1;while(q>=0&&w.parentNode.menuItem!==v[q].menuItem){v[q].menuItem.posted=false;v[q].parentNode.removeChild(v[q]);q--}if(this.Timer&&!a.isMobile){this.Timer(u,w)}}},Mouseout:function(q,r){if(!this.menu||!this.menu.posted){this.Deactivate(r)}if(this.timer){clearTimeout(this.timer);delete this.timer}},Mouseup:function(q,r){return this.Remove(q,r)},Touchstart:function(q,r){return this.TouchEvent(q,r,"Mousedown")},Touchend:function(q,r){return this.TouchEvent(q,r,"Mouseup")},TouchEvent:function(r,s,q){if(this!==m.lastItem){if(m.lastMenu){a.Event(r,m.lastMenu,"Mouseout")}a.Event(r,s,"Mouseover",true);m.lastItem=this;m.lastMenu=s}if(this.nativeTouch){return null}a.Event(r,s,q);return false},Remove:function(q,r){r=r.parentNode.menuItem;return r.Remove(q,r)},Activate:function(q){this.Deactivate(q);q.className+=" MathJax_MenuActive"},Deactivate:function(q){q.className=q.className.replace(/ MathJax_MenuActive/,"")},With:function(q){if(q){c.Insert(this,q)}return this}});a.ITEM.COMMAND=a.ITEM.Subclass({action:function(){},Init:function(q,s,r){this.name=q;this.action=s;this.With(r)},Label:function(q,r){return[this.name]},Mouseup:function(q,r){if(!this.disabled){this.Remove(q,r);j.Post(["command",this]);this.action.call(this,q)}return h(q)}});a.ITEM.SUBMENU=a.ITEM.Subclass({menu:null,marker:(n&&!c.Browser.isSafari?"\u25B6":"\u25B8"),Init:function(q,s){this.name=q;var r=1;if(!(s instanceof a.ITEM)){this.With(s),r++}this.menu=a.apply(a,[].slice.call(arguments,r))},Label:function(q,r){this.menu.posted=false;return[this.name+" ",["span",{className:"MathJax_MenuArrow"},[this.marker]]]},Timer:function(q,r){if(this.timer){clearTimeout(this.timer)}q={clientX:q.clientX,clientY:q.clientY};this.timer=setTimeout(f(["Mouseup",this,q,r]),o.delay)},Touchend:function(r,t){var s=this.menu.posted;var q=this.SUPER(arguments).Touchend.apply(this,arguments);if(s){this.Deactivate(t);delete m.lastItem;delete m.lastMenu}return q},Mouseup:function(r,t){if(!this.disabled){if(!this.menu.posted){if(this.timer){clearTimeout(this.timer);delete this.timer}this.menu.Post(r,t)}else{var s=document.getElementById("MathJax_MenuFrame").childNodes,q=s.length-1;while(q>=0){var u=s[q];u.menuItem.posted=false;u.parentNode.removeChild(u);if(u.menuItem===this.menu){break}q--}}}return h(r)}});a.ITEM.RADIO=a.ITEM.Subclass({variable:null,marker:(n?"\u25CF":"\u2713"),Init:function(r,q,s){this.name=r;this.variable=q;this.With(s);if(this.value==null){this.value=this.name}},Label:function(r,s){var q={className:"MathJax_MenuRadioCheck"};if(o.settings[this.variable]!==this.value){q={style:{display:"none"}}}return[["span",q,[this.marker]]," "+this.name]},Mouseup:function(t,u){if(!this.disabled){var v=u.parentNode.childNodes;for(var r=0,q=v.length;r<q;r++){var s=v[r].menuItem;if(s&&s.variable===this.variable){v[r].firstChild.style.display="none"}}u.firstChild.display="";o.settings[this.variable]=this.value;a.cookie[this.variable]=o.settings[this.variable];a.saveCookie();j.Post(["radio button",this])}this.Remove(t,u);if(this.action&&!this.disabled){this.action.call(a,this)}return h(t)}});a.ITEM.CHECKBOX=a.ITEM.Subclass({variable:null,marker:"\u2713",Init:function(r,q,s){this.name=r;this.variable=q;this.With(s)},Label:function(r,s){var q={className:"MathJax_MenuCheck"};if(!o.settings[this.variable]){q={style:{display:"none"}}}return[["span",q,[this.marker]]," "+this.name]},Mouseup:function(q,r){if(!this.disabled){r.firstChild.display=(o.settings[this.variable]?"none":"");o.settings[this.variable]=!o.settings[this.variable];a.cookie[this.variable]=o.settings[this.variable];a.saveCookie();j.Post(["checkbox",this])}this.Remove(q,r);if(this.action&&!this.disabled){this.action.call(a,this)}return h(q)}});a.ITEM.LABEL=a.ITEM.Subclass({Init:function(q,r){this.name=q;this.With(r)},Label:function(q,r){delete q.onmouseover,delete q.onmouseout;delete q.onmousedown;q.className+=" MathJax_MenuLabel";return[this.name]}});a.ITEM.RULE=a.ITEM.Subclass({Label:function(q,r){delete q.onmouseover,delete q.onmouseout;delete q.onmousedown;q.className+=" MathJax_MenuRule";return null}});a.About=function(){var t=b["HTML-CSS"]||{fontInUse:""};var v=(t.webFonts?"":"local "),r=(t.webFonts?" web":"");var s=(t.imgFonts?"Image":v+t.fontInUse+r)+" fonts";if(s==="local  fonts"&&b.SVG){s="web SVG fonts"}var q=["MathJax.js v"+MathJax.fileversion,["br"]];q.push(["div",{style:{"border-top":"groove 2px",margin:".25em 0"}}]);a.About.GetJax(q,MathJax.InputJax,"Input Jax");a.About.GetJax(q,MathJax.OutputJax,"Output Jax");a.About.GetJax(q,MathJax.ElementJax,"Element Jax");q.push(["div",{style:{"border-top":"groove 2px",margin:".25em 0"}}]);a.About.GetJax(q,MathJax.Extension,"Extension",true);q.push(["div",{style:{"border-top":"groove 2px",margin:".25em 0"}}],["center",{},[c.Browser+" v"+c.Browser.version+(t.webFonts&&!t.imgFonts?" \u2014 "+t.allowWebFonts.replace(/otf/,"woff or otf")+" fonts":"")]]);a.About.div=a.Background(a.About);var w=g.addElement(a.About.div,"div",{id:"MathJax_About"},[["b",{style:{fontSize:"120%"}},["MathJax"]]," v"+MathJax.version,["br"],"using "+s,["br"],["br"],["span",{style:{display:"inline-block","text-align":"left","font-size":"80%","max-height":"20em",overflow:"auto","background-color":"#E4E4E4",padding:".4em .6em",border:"1px inset"}},q],["br"],["br"],["a",{href:"http://www.mathjax.org/"},["www.mathjax.org"]],["img",{src:o.closeImg,style:{width:"21px",height:"21px",position:"absolute",top:".2em",right:".2em"},onclick:a.About.Remove}]]);var x=(document.documentElement||{});var u=window.innerHeight||x.clientHeight||x.scrollHeight||0;if(a.prototype.msieAboutBug){w.style.width="20em";w.style.position="absolute";w.style.left=Math.floor((document.documentElement.scrollWidth-w.offsetWidth)/2)+"px";w.style.top=(Math.floor((u-w.offsetHeight)/3)+document.body.scrollTop)+"px"}else{w.style.marginLeft=Math.floor(-w.offsetWidth/2)+"px";w.style.top=Math.floor((u-w.offsetHeight)/3)+"px"}};a.About.Remove=function(q){if(a.About.div){document.body.removeChild(a.About.div);delete a.About.div}};a.About.GetJax=function(r,w,u,t){var v=[];for(var x in w){if(w.hasOwnProperty(x)&&w[x]){if((t&&w[x].version)||(w[x].isa&&w[x].isa(w))){v.push((w[x].id||x)+" "+u+" v"+w[x].version)}}}v.sort();for(var s=0,q=v.length;s<q;s++){r.push(v[s],["br"])}return r};a.Help=function(){window.open(o.helpURL,"MathJaxHelp")};a.ShowSource=function(t){if(!t){t=window.event}var s={screenX:t.screenX,screenY:t.screenY};if(!a.jax){return}if(this.format==="MathML"){var q=MathJax.ElementJax.mml;if(q&&typeof(q.mbase.prototype.toMathML)!=="undefined"){try{a.ShowSource.Text(a.jax.root.toMathML(),t)}catch(r){if(!r.restart){throw r}f.After([this,a.ShowSource,s],r.restart)}}else{if(!k.loadingToMathML){k.loadingToMathML=true;a.ShowSource.Window(t);f.Queue(k.Require("[MathJax]/extensions/toMathML.js"),function(){delete k.loadingToMathML;if(!q.mbase.prototype.toMathML){q.mbase.prototype.toMathML=function(){}}},[this,a.ShowSource,s]);return}}}else{if(a.jax.originalText==null){alert("No original form available");return}a.ShowSource.Text(a.jax.originalText,t)}};a.ShowSource.Window=function(r){if(!a.ShowSource.w){var s=[],q=o.windowSettings;for(var t in q){if(q.hasOwnProperty(t)){s.push(t+"="+q[t])}}a.ShowSource.w=window.open("","_blank",s.join(","))}return a.ShowSource.w};a.ShowSource.Text=function(t,s){var q=a.ShowSource.Window(s);delete a.ShowSource.w;t=t.replace(/^\s*/,"").replace(/\s*$/,"");t=t.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;");if(a.isMobile){q.document.open();q.document.write("<html><head><meta name='viewport' content='width=device-width, initial-scale=1.0' /><title>MathJax Equation Source</title></head><body style='font-size:85%'>");q.document.write("<pre>"+t+"</pre>");q.document.write("<hr><input type='button' value='Close' onclick='window.close()' />");q.document.write("</body></html>");q.document.close()}else{q.document.open();q.document.write("<html><head><title>MathJax Equation Source</title></head><body style='font-size:85%'>");q.document.write("<table><tr><td><pre>"+t+"</pre></td></tr></table>");q.document.write("</body></html>");q.document.close();var r=q.document.body.firstChild;setTimeout(function(){var w=(q.outerHeight-q.innerHeight)||30,v=(q.outerWidth-q.innerWidth)||30,u,z;v=Math.max(100,Math.min(Math.floor(0.5*screen.width),r.offsetWidth+v+25));w=Math.max(40,Math.min(Math.floor(0.5*screen.height),r.offsetHeight+w+25));q.resizeTo(v,w);if(s&&s.screenX!=null){u=Math.max(0,Math.min(s.screenX-Math.floor(v/2),screen.width-v-20));z=Math.max(0,Math.min(s.screenY-Math.floor(w/2),screen.height-w-20));q.moveTo(u,z)}},50)}};a.Scale=function(){var r=b["HTML-CSS"],q=b.NativeMML,u=b.SVG;var t=(r||q||u||{config:{scale:100}}).config.scale;var s=prompt("Scale all mathematics (compared to surrounding text) by",t+"%");if(s){if(s.match(/^\s*\d+(\.\d*)?\s*%?\s*$/)){s=parseFloat(s);if(s){if(s!==t){if(r){r.config.scale=s}if(q){q.config.scale=s}if(u){u.config.scale=s}a.cookie.scale=s;a.saveCookie();c.Reprocess()}}else{alert("The scale should not be zero")}}else{alert("The scale should be a percentage (e.g., 120%)")}}};a.Zoom=function(){if(!MathJax.Extension.MathZoom){k.Require("[MathJax]/extensions/MathZoom.js")}};a.Renderer=function(){var r=c.outputJax["jax/mml"];if(r[0]!==o.settings.renderer){var u=c.Browser,t,q=a.Renderer.Messages,s;switch(o.settings.renderer){case"NativeMML":if(!o.settings.warnedMML){if(u.isChrome||(u.isSafari&&!u.versionAtLeast("5.0"))){t=q.MML.WebKit}else{if(u.isMSIE){if(!u.hasMathPlayer){t=q.MML.MSIE}}else{t=q.MML[u]}}s="warnedMML"}break;case"SVG":if(!o.settings.warnedSVG){if(u.isMSIE&&!e){t=q.SVG.MSIE}}break}if(t){t+="\n\nSwitch the renderer anyway?\n\n(Press OK to switch, CANCEL to continue with the current renderer)";a.cookie.renderer=r[0].id;a.saveCookie();if(!confirm(t)){return}if(s){a.cookie[s]=o.settings[s]=true}a.cookie.renderer=o.settings.renderer;a.saveCookie()}c.Queue(["setRenderer",c,o.settings.renderer,"jax/mml"],["Rerender",c])}};a.Renderer.Messages={MML:{WebKit:"Your browser doesn't seem to support MathML natively, so switching to MathML output may cause the mathematics on the page to become unreadable.",MSIE:"Internet Explorer requires the MathPlayer plugin in order to process MathML output.",Opera:"Opera's support for MathML is limited, so switching to MathML output may cause some expressions to render poorly.",Safari:"Your browser's native MathML does not implement all the features used by MathJax, so some expressions may not render properly.",Firefox:"Your browser's native MathML does not implement all the features used by MathJax, so some expressions may not render properly."},SVG:{MSIE:"SVG is not implemented in Internet Explorer prior to IE9, or when the browser is emulating IE8 or below. Switching to SVG output will cause the mathemtics to not display properly."}};a.Font=function(){var q=b["HTML-CSS"];if(!q){return}document.location.reload()};a.MPEvents=function(s){var r=o.settings.discoverable,q=a.MPEvents.Messages;if(!e){if(o.settings.mpMouse&&!confirm(q.IE8warning)){delete a.cookie.mpContext;delete o.settings.mpContext;delete a.cookie.mpMouse;delete o.settings.mpMouse;a.saveCookie();return}o.settings.mpContext=o.settings.mpMouse;a.cookie.mpContext=a.cookie.mpMouse=o.settings.mpMouse;a.saveCookie();MathJax.Hub.Queue(["Rerender",MathJax.Hub])}else{if(!r&&s.name==="Menu Events"&&o.settings.mpContext){alert(q.IE9warning)}}};a.MPEvents.Messages={IE8warning:"This will disable the MathJax menu and zoom features, but you can Alt-Click on an expression to obtain the MathJax menu instead.\n\nReally change the MathPlayer settings?",IE9warning:"The MathJax contextual menu will be disabled, but you can Alt-Click on an expression to obtain the MathJax menu instead."};c.Browser.Select({MSIE:function(q){var r=(document.compatMode==="BackCompat");var s=q.versionAtLeast("8.0")&&document.documentMode>7;a.Augment({margin:20,msieBackgroundBug:(document.documentMode<9),msieFixedPositionBug:(r||!s),msieAboutBug:r});if(e){delete o.styles["#MathJax_About"].filter;delete o.styles[".MathJax_Menu"].filter}},Firefox:function(q){a.skipMouseover=q.isMobile&&q.versionAtLeast("6.0");a.skipMousedown=q.isMobile}});a.isMobile=c.Browser.isMobile;a.noContextMenu=c.Browser.noContextMenu;c.Register.StartupHook("End Config",function(){o.settings=c.config.menuSettings;if(typeof(o.settings.showRenderer)!=="undefined"){o.showRenderer=o.settings.showRenderer}if(typeof(o.settings.showFontMenu)!=="undefined"){o.showFontMenu=o.settings.showFontMenu}if(typeof(o.settings.showContext)!=="undefined"){o.showContext=o.settings.showContext}a.getCookie();a.menu=a(m.SUBMENU("Show Math As",m.COMMAND("MathML Code",a.ShowSource,{nativeTouch:true,format:"MathML"}),m.COMMAND("Original Form",a.ShowSource,{nativeTouch:true}),m.RULE(),m.CHECKBOX("Show TeX hints in MathML","texHints")),m.RULE(),m.SUBMENU("Math Settings",m.SUBMENU("Zoom Trigger",m.RADIO("Hover","zoom",{action:a.Zoom}),m.RADIO("Click","zoom",{action:a.Zoom}),m.RADIO("Double-Click","zoom",{action:a.Zoom}),m.RADIO("No Zoom","zoom",{value:"None"}),m.RULE(),m.LABEL("Trigger Requires:"),m.CHECKBOX((c.Browser.isMac?"Option":"Alt"),"ALT"),m.CHECKBOX("Command","CMD",{hidden:!c.Browser.isMac}),m.CHECKBOX("Control","CTRL",{hidden:c.Browser.isMac}),m.CHECKBOX("Shift","Shift")),m.SUBMENU("Zoom Factor",m.RADIO("125%","zscale"),m.RADIO("133%","zscale"),m.RADIO("150%","zscale"),m.RADIO("175%","zscale"),m.RADIO("200%","zscale"),m.RADIO("250%","zscale"),m.RADIO("300%","zscale"),m.RADIO("400%","zscale")),m.RULE(),m.SUBMENU("Math Renderer",{hidden:!o.showRenderer},m.RADIO("HTML-CSS","renderer",{action:a.Renderer}),m.RADIO("MathML","renderer",{action:a.Renderer,value:"NativeMML"}),m.RADIO("SVG","renderer",{action:a.Renderer})),m.SUBMENU("MathPlayer",{hidden:!c.Browser.isMSIE||!o.showMathPlayer,disabled:!c.Browser.hasMathPlayer},m.LABEL("Let MathPlayer Handle:"),m.CHECKBOX("Menu Events","mpContext",{action:a.MPEvents,hidden:!e}),m.CHECKBOX("Mouse Events","mpMouse",{action:a.MPEvents,hidden:!e}),m.CHECKBOX("Mouse and Menu Events","mpMouse",{action:a.MPEvents,hidden:e})),m.SUBMENU("Font Preference",{hidden:!o.showFontMenu},m.LABEL("For HTML-CSS:"),m.RADIO("Auto","font",{action:a.Font}),m.RULE(),m.RADIO("TeX (local)","font",{action:a.Font}),m.RADIO("TeX (web)","font",{action:a.Font}),m.RADIO("TeX (image)","font",{action:a.Font}),m.RULE(),m.RADIO("STIX (local)","font",{action:a.Font})),m.SUBMENU("Contextual Menu",{hidden:!o.showContext},m.RADIO("MathJax","context"),m.RADIO("Browser","context")),m.COMMAND("Scale All Math ...",a.Scale),m.RULE().With({hidden:!o.showDiscoverable,name:"discover_rule"}),m.CHECKBOX("Highlight on Hover","discoverable",{hidden:!o.showDiscoverable})),m.RULE(),m.COMMAND("About MathJax",a.About),m.COMMAND("MathJax Help",a.Help));if(a.isMobile){(function(){var r=o.settings;var q=a.menu.Find("Math Settings","Zoom Trigger").menu;q.items[0].disabled=q.items[1].disabled=true;if(r.zoom==="Hover"||r.zoom=="Click"){r.zoom="None"}q.items=q.items.slice(0,4);if(navigator.appVersion.match(/[ (]Android[) ]/)){a.ITEM.SUBMENU.Augment({marker:"\u00BB"})}})()}});a.showRenderer=function(q){a.cookie.showRenderer=o.showRenderer=q;a.saveCookie();a.menu.Find("Math Settings","Math Renderer").hidden=!q};a.showMathPlayer=function(q){a.cookie.showMathPlayer=o.showMathPlayer=q;a.saveCookie();a.menu.Find("Math Settings","MathPlayer").hidden=!q};a.showFontMenu=function(q){a.cookie.showFontMenu=o.showFontMenu=q;a.saveCookie();a.menu.Find("Math Settings","Font Preference").hidden=!q};a.showContext=function(q){a.cookie.showContext=o.showContext=q;a.saveCookie();a.menu.Find("Math Settings","Contextual Menu").hidden=!q};a.showDiscoverable=function(q){a.cookie.showContext=o.showContext=q;a.saveCookie();a.menu.Find("Math Settings","Highlight on Hover").hidden=!q;a.menu.Find("Math Settings","discover_rule").hidden=!q};MathJax.Hub.Register.StartupHook("HTML-CSS Jax Ready",function(){if(!MathJax.OutputJax["HTML-CSS"].config.imageFont){a.menu.Find("Math Settings","Font Preference","TeX (image)").disabled=true}});f.Queue(c.Register.StartupHook("End Config",{}),["getImages",a],["Styles",k,o.styles],["Post",c.Startup.signal,"MathMenu Ready"],["loadComplete",k,"[MathJax]/extensions/MathMenu.js"])})(MathJax.Hub,MathJax.HTML,MathJax.Ajax,MathJax.CallBack,MathJax.OutputJax);

MathJax.ElementJax.mml=MathJax.ElementJax({mimeType:"jax/mml"},{id:"mml",version:"2.1",directory:MathJax.ElementJax.directory+"/mml",extensionDir:MathJax.ElementJax.extensionDir+"/mml",optableDir:MathJax.ElementJax.directory+"/mml/optable"});MathJax.ElementJax.mml.Augment({Init:function(){if(arguments.length===1&&arguments[0].type==="math"){this.root=arguments[0]}else{this.root=MathJax.ElementJax.mml.math.apply(this,arguments)}if(this.root.attr&&this.root.attr.mode){if(!this.root.display&&this.root.attr.mode==="display"){this.root.display="block";this.root.attrNames.push("display")}delete this.root.attr.mode;for(var b=0,a=this.root.attrNames.length;b<a;b++){if(this.root.attrNames[b]==="mode"){this.root.attrNames.splice(b,1);break}}}}},{INHERIT:"_inherit_",AUTO:"_auto_",SIZE:{INFINITY:"infinity",SMALL:"small",NORMAL:"normal",BIG:"big"},COLOR:{TRANSPARENT:"transparent"},VARIANT:{NORMAL:"normal",BOLD:"bold",ITALIC:"italic",BOLDITALIC:"bold-italic",DOUBLESTRUCK:"double-struck",FRAKTUR:"fraktur",BOLDFRAKTUR:"bold-fraktur",SCRIPT:"script",BOLDSCRIPT:"bold-script",SANSSERIF:"sans-serif",BOLDSANSSERIF:"bold-sans-serif",SANSSERIFITALIC:"sans-serif-italic",SANSSERIFBOLDITALIC:"sans-serif-bold-italic",MONOSPACE:"monospace",INITIAL:"inital",TAILED:"tailed",LOOPED:"looped",STRETCHED:"stretched",CALIGRAPHIC:"-tex-caligraphic",OLDSTYLE:"-tex-oldstyle"},FORM:{PREFIX:"prefix",INFIX:"infix",POSTFIX:"postfix"},LINEBREAK:{AUTO:"auto",NEWLINE:"newline",NOBREAK:"nobreak",GOODBREAK:"goodbreak",BADBREAK:"badbreak"},LINEBREAKSTYLE:{BEFORE:"before",AFTER:"after",DUPLICATE:"duplicate",INFIXLINBREAKSTYLE:"infixlinebreakstyle"},INDENTALIGN:{LEFT:"left",CENTER:"center",RIGHT:"right",AUTO:"auto",ID:"id",INDENTALIGN:"indentalign"},INDENTSHIFT:{INDENTSHIFT:"indentshift"},LINETHICKNESS:{THIN:"thin",MEDIUM:"medium",THICK:"thick"},NOTATION:{LONGDIV:"longdiv",ACTUARIAL:"actuarial",RADICAL:"radical",BOX:"box",ROUNDEDBOX:"roundedbox",CIRCLE:"circle",LEFT:"left",RIGHT:"right",TOP:"top",BOTTOM:"bottom",UPDIAGONALSTRIKE:"updiagonalstrike",DOWNDIAGONALSTRIKE:"downdiagonalstrike",VERTICALSTRIKE:"verticalstrike",HORIZONTALSTRIKE:"horizontalstrike",MADRUWB:"madruwb"},ALIGN:{TOP:"top",BOTTOM:"bottom",CENTER:"center",BASELINE:"baseline",AXIS:"axis",LEFT:"left",RIGHT:"right"},LINES:{NONE:"none",SOLID:"solid",DASHED:"dashed"},SIDE:{LEFT:"left",RIGHT:"right",LEFTOVERLAP:"leftoverlap",RIGHTOVERLAP:"rightoverlap"},WIDTH:{AUTO:"auto",FIT:"fit"},ACTIONTYPE:{TOGGLE:"toggle",STATUSLINE:"statusline",TOOLTIP:"tooltip",INPUT:"input"},LENGTH:{VERYVERYTHINMATHSPACE:"veryverythinmathspace",VERYTHINMATHSPACE:"verythinmathspace",THINMATHSPACE:"thinmathspace",MEDIUMMATHSPACE:"mediummathspace",THICKMATHSPACE:"thickmathspace",VERYTHICKMATHSPACE:"verythickmathspace",VERYVERYTHICKMATHSPACE:"veryverythickmathspace",NEGATIVEVERYVERYTHINMATHSPACE:"negativeveryverythinmathspace",NEGATIVEVERYTHINMATHSPACE:"negativeverythinmathspace",NEGATIVETHINMATHSPACE:"negativethinmathspace",NEGATIVEMEDIUMMATHSPACE:"negativemediummathspace",NEGATIVETHICKMATHSPACE:"negativethickmathspace",NEGATIVEVERYTHICKMATHSPACE:"negativeverythickmathspace",NEGATIVEVERYVERYTHICKMATHSPACE:"negativeveryverythickmathspace"},OVERFLOW:{LINBREAK:"linebreak",SCROLL:"scroll",ELIDE:"elide",TRUNCATE:"truncate",SCALE:"scale"},UNIT:{EM:"em",EX:"ex",PX:"px",IN:"in",CM:"cm",MM:"mm",PT:"pt",PC:"pc"},TEXCLASS:{ORD:0,OP:1,BIN:2,REL:3,OPEN:4,CLOSE:5,PUNCT:6,INNER:7,VCENTER:8,NONE:-1},TEXCLASSNAMES:["ORD","OP","BIN","REL","OPEN","CLOSE","PUNCT","INNER","VCENTER"],copyAttributes:{fontfamily:true,fontsize:true,fontweight:true,fontstyle:true,color:true,background:true,id:true,"class":true,href:true,style:true},skipAttributes:{texClass:true,useHeight:true,texprimestyle:true},copyAttributeNames:["fontfamily","fontsize","fontweight","fontstyle","color","background","id","class","href","style"]});(function(a){a.mbase=MathJax.Object.Subclass({type:"base",isToken:false,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT},noInherit:{},noInheritAttribute:{texClass:true},linebreakContainer:false,Init:function(){this.data=[];if(this.inferRow&&!(arguments.length===1&&arguments[0].inferred)){this.Append(a.mrow().With({inferred:true}))}this.Append.apply(this,arguments)},With:function(d){for(var e in d){if(d.hasOwnProperty(e)){this[e]=d[e]}}return this},Append:function(){if(this.inferRow&&this.data.length){this.data[0].Append.apply(this.data[0],arguments)}else{for(var e=0,d=arguments.length;e<d;e++){this.SetData(this.data.length,arguments[e])}}},SetData:function(d,e){if(e!=null){if(!(e instanceof a.mbase)){e=(this.isToken?a.chars(e):a.mtext(e))}e.parent=this;e.setInherit(this.inheritFromMe?this:this.inherit)}this.data[d]=e},Parent:function(){var d=this.parent;while(d&&d.inferred){d=d.parent}return d},Get:function(e,j){if(this[e]!=null){return this[e]}if(this.attr&&this.attr[e]!=null){return this.attr[e]}var f=this.Parent();if(f&&f["adjustChild_"+e]!=null){return(f["adjustChild_"+e])(f.childPosition(this))}var i=this.inherit;var d=i;while(i){var h=i[e];if(h==null&&i.attr){h=i.attr[e]}if(h!=null&&!i.noInheritAttribute[e]){var g=i.noInherit[this.type];if(!(g&&g[e])){return h}}d=i;i=i.inherit}if(!j){if(this.defaults[e]===a.AUTO){return this.autoDefault(e)}if(this.defaults[e]!==a.INHERIT&&this.defaults[e]!=null){return this.defaults[e]}if(d){return d.defaults[e]}}return null},hasValue:function(d){return(this.Get(d,true)!=null)},getValues:function(){var e={};for(var f=0,d=arguments.length;f<d;f++){e[arguments[f]]=this.Get(arguments[f])}return e},adjustChild_scriptlevel:function(d){return this.Get("scriptlevel")},adjustChild_displaystyle:function(d){return this.Get("displaystyle")},adjustChild_texprimestyle:function(d){return this.Get("texprimestyle")},childPosition:function(f){if(f.parent.inferred){f=f.parent}for(var e=0,d=this.data.length;e<d;e++){if(this.data[e]===f){return e}}return null},setInherit:function(f){if(f!==this.inherit&&this.inherit==null){this.inherit=f;for(var e=0,d=this.data.length;e<d;e++){if(this.data[e]&&this.data[e].setInherit){this.data[e].setInherit(f)}}}},setTeXclass:function(d){this.getPrevClass(d);return(typeof(this.texClass)!=="undefined"?this:d)},getPrevClass:function(d){if(d){this.prevClass=d.Get("texClass");this.prevLevel=d.Get("scriptlevel")}},updateTeXclass:function(d){if(d){this.prevClass=d.prevClass;delete d.prevClass;this.prevLevel=d.prevLevel;delete d.prevLevel;this.texClass=d.Get("texClass")}},texSpacing:function(){var e=(this.prevClass!=null?this.prevClass:a.TEXCLASS.NONE);var d=(this.Get("texClass")||a.TEXCLASS.ORD);if(e===a.TEXCLASS.NONE||d===a.TEXCLASS.NONE){return""}if(e===a.TEXCLASS.VCENTER){e=a.TEXCLASS.ORD}if(d===a.TEXCLASS.VCENTER){d=a.TEXCLASS.ORD}var f=this.TEXSPACE[e][d];if(this.prevLevel>0&&this.Get("scriptlevel")>0&&f>=0){return""}return this.TEXSPACELENGTH[Math.abs(f)]},TEXSPACELENGTH:["",a.LENGTH.THINMATHSPACE,a.LENGTH.MEDIUMMATHSPACE,a.LENGTH.THICKMATHSPACE],TEXSPACE:[[0,-1,2,3,0,0,0,1],[-1,-1,0,3,0,0,0,1],[2,2,0,0,2,0,0,2],[3,3,0,0,3,0,0,3],[0,0,0,0,0,0,0,0],[0,-1,2,3,0,0,0,1],[1,1,0,1,1,1,1,1],[1,-1,2,3,1,0,1,1]],autoDefault:function(d){return""},isSpacelike:function(){return false},isEmbellished:function(){return false},Core:function(){return this},CoreMO:function(){return this},hasNewline:function(){if(this.isEmbellished()){return this.CoreMO().hasNewline()}if(this.isToken||this.linebreakContainer){return false}for(var e=0,d=this.data.length;e<d;e++){if(this.data[e]&&this.data[e].hasNewline()){return true}}return false},array:function(){if(this.inferred){return this.data}else{return[this]}},toString:function(){return this.type+"("+this.data.join(",")+")"}},{childrenSpacelike:function(){for(var e=0,d=this.data.length;e<d;e++){if(!this.data[e].isSpacelike()){return false}}return true},childEmbellished:function(){return(this.data[0]&&this.data[0].isEmbellished())},childCore:function(){return this.data[0]},childCoreMO:function(){return(this.data[0]?this.data[0].CoreMO():null)},setChildTeXclass:function(d){if(this.data[0]){d=this.data[0].setTeXclass(d);this.updateTeXclass(this.data[0])}return d},setBaseTeXclasses:function(f){this.getPrevClass(f);this.texClass=null;if(this.isEmbellished()||this.data[0].isa(a.mi)){f=this.data[0].setTeXclass(f);this.updateTeXclass(this.Core())}else{if(this.data[0]){this.data[0].setTeXclass()}f=this}for(var e=1,d=this.data.length;e<d;e++){if(this.data[e]){this.data[e].setTeXclass()}}return f},setSeparateTeXclasses:function(f){this.getPrevClass(f);for(var e=0,d=this.data.length;e<d;e++){if(this.data[e]){this.data[e].setTeXclass()}}if(this.isEmbellished()){this.updateTeXclass(this.Core())}return this}});a.mi=a.mbase.Subclass({type:"mi",isToken:true,texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.AUTO,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT},autoDefault:function(e){if(e==="mathvariant"){var d=(this.data[0]||"").toString();return(d.length===1||(d.length===2&&d.charCodeAt(0)>=55296&&d.charCodeAt(0)<56320)?a.VARIANT.ITALIC:a.VARIANT.NORMAL)}return""},setTeXclass:function(e){this.getPrevClass(e);var d=this.data.join("");if(d.length>1&&d.match(/^[a-z][a-z0-9]*$/i)&&this.texClass===a.TEXCLASS.ORD){this.texClass=a.TEXCLASS.OP;this.autoOP=true}return this}});a.mn=a.mbase.Subclass({type:"mn",isToken:true,texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT}});a.mo=a.mbase.Subclass({type:"mo",isToken:true,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT,form:a.AUTO,fence:a.AUTO,separator:a.AUTO,lspace:a.AUTO,rspace:a.AUTO,stretchy:a.AUTO,symmetric:a.AUTO,maxsize:a.AUTO,minsize:a.AUTO,largeop:a.AUTO,movablelimits:a.AUTO,accent:a.AUTO,linebreak:a.LINEBREAK.AUTO,lineleading:a.INHERIT,linebreakstyle:a.AUTO,linebreakmultchar:a.INHERIT,indentalign:a.INHERIT,indentshift:a.INHERIT,indenttarget:a.INHERIT,indentalignfirst:a.INHERIT,indentshiftfirst:a.INHERIT,indentalignlast:a.INHERIT,indentshiftlast:a.INHERIT,texClass:a.AUTO},defaultDef:{form:a.FORM.INFIX,fence:false,separator:false,lspace:a.LENGTH.THICKMATHSPACE,rspace:a.LENGTH.THICKMATHSPACE,stretchy:false,symmetric:true,maxsize:a.SIZE.INFINITY,minsize:"0em",largeop:false,movablelimits:false,accent:false,linebreak:a.LINEBREAK.AUTO,lineleading:"1ex",linebreakstyle:"before",indentalign:a.INDENTALIGN.AUTO,indentshift:"0",indenttarget:"",indentalignfirst:a.INDENTALIGN.INDENTALIGN,indentshiftfirst:a.INDENTSHIFT.INDENTSHIFT,indentalignlast:a.INDENTALIGN.INDENTALIGN,indentshiftlast:a.INDENTSHIFT.INDENTSHIFT,texClass:a.TEXCLASS.REL},SPACE_ATTR:{lspace:1,rspace:2,form:4},useMMLspacing:7,autoDefault:function(f,l){var k=this.def;if(!k){if(f==="form"){this.useMMLspacing&=~this.SPACE_ATTR.form;return this.getForm()}var j=this.data.join("");var e=[this.Get("form"),a.FORM.INFIX,a.FORM.POSTFIX,a.FORM.PREFIX];for(var g=0,d=e.length;g<d;g++){var h=this.OPTABLE[e[g]][j];if(h){k=this.makeDef(h);break}}if(!k){k=this.CheckRange(j)}if(!k&&l){k={}}else{if(!k){k=MathJax.Hub.Insert({},this.defaultDef)}k.form=e[0];this.def=k}}this.useMMLspacing&=~(this.SPACE_ATTR[f]||0);if(k[f]!=null){return k[f]}else{if(!l){return this.defaultDef[f]}}return""},CheckRange:function(h){var j=h.charCodeAt(0);if(j>=55296&&j<56320){j=(((j-55296)<<10)+(h.charCodeAt(1)-56320))+65536}for(var f=0,d=this.RANGES.length;f<d&&this.RANGES[f][0]<=j;f++){if(j<=this.RANGES[f][1]){if(this.RANGES[f][3]){var e=a.optableDir+"/"+this.RANGES[f][3]+".js";this.RANGES[f][3]=null;MathJax.Hub.RestartAfter(MathJax.Ajax.Require(e))}var g=a.TEXCLASSNAMES[this.RANGES[f][2]];g=this.OPTABLE.infix[h]=a.mo.OPTYPES[g==="BIN"?"BIN3":g];return this.makeDef(g)}}return null},makeDef:function(e){if(e[2]==null){e[2]=this.defaultDef.texClass}if(!e[3]){e[3]={}}var d=MathJax.Hub.Insert({},e[3]);d.lspace=this.SPACE[e[0]];d.rspace=this.SPACE[e[1]];d.texClass=e[2];if(d.texClass===a.TEXCLASS.REL&&(this.movablelimits||this.data.join("").match(/^[a-z]+$/i))){d.texClass=a.TEXCLASS.OP}return d},getForm:function(){var d=this,f=this.parent,e=this.Parent();while(e&&e.isEmbellished()){d=f;f=e.parent;e=e.Parent()}if(f&&f.type==="mrow"&&f.NonSpaceLength()!==1){if(f.FirstNonSpace()===d){return a.FORM.PREFIX}if(f.LastNonSpace()===d){return a.FORM.POSTFIX}}return a.FORM.INFIX},isEmbellished:function(){return true},hasNewline:function(){return(this.Get("linebreak")===a.LINEBREAK.NEWLINE)},setTeXclass:function(d){this.getValues("lspace","rspace");if(this.useMMLspacing){this.texClass=a.TEXCLASS.NONE;return this}this.texClass=this.Get("texClass");if(this.data.join("")==="\u2061"){d.texClass=a.TEXCLASS.OP;this.texClass=this.prevClass=a.TEXCLASS.NONE;return d}return this.adjustTeXclass(d)},adjustTeXclass:function(d){if(this.texClass===a.TEXCLASS.NONE){return d}if(d){if(d.autoOP&&(this.texClass===a.TEXCLASS.BIN||this.texClass===a.TEXCLASS.REL)){d.texClass=a.TEXCLASS.ORD}this.prevClass=d.texClass||a.TEXCLASS.ORD;this.prevLevel=d.Get("scriptlevel")}else{this.prevClass=a.TEXCLASS.NONE}if(this.texClass===a.TEXCLASS.BIN&&(this.prevClass===a.TEXCLASS.NONE||this.prevClass===a.TEXCLASS.BIN||this.prevClass===a.TEXCLASS.OP||this.prevClass===a.TEXCLASS.REL||this.prevClass===a.TEXCLASS.OPEN||this.prevClass===a.TEXCLASS.PUNCT)){this.texClass=a.TEXCLASS.ORD}else{if(this.prevClass===a.TEXCLASS.BIN&&(this.texClass===a.TEXCLASS.REL||this.texClass===a.TEXCLASS.CLOSE||this.texClass===a.TEXCLASS.PUNCT)){d.texClass=this.prevClass=a.TEXCLASS.ORD}}return this}});a.mtext=a.mbase.Subclass({type:"mtext",isToken:true,isSpacelike:function(){return true},texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT}});a.mspace=a.mbase.Subclass({type:"mspace",isToken:true,isSpacelike:function(){return true},defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,width:"0em",height:"0ex",depth:"0ex",linebreak:a.LINEBREAK.AUTO},hasNewline:function(){return(this.Get("linebreak")===a.LINEBREAK.NEWLINE)}});a.ms=a.mbase.Subclass({type:"ms",isToken:true,texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT,lquote:'"',rquote:'"'}});a.mglyph=a.mbase.Subclass({type:"mglyph",isToken:true,texClass:a.TEXCLASS.ORD,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,alt:"",src:"",width:a.AUTO,height:a.AUTO,valign:"0em"}});a.mrow=a.mbase.Subclass({type:"mrow",isSpacelike:a.mbase.childrenSpacelike,inferred:false,isEmbellished:function(){var e=false;for(var f=0,d=this.data.length;f<d;f++){if(this.data[f]==null){continue}if(this.data[f].isEmbellished()){if(e){return false}e=true;this.core=f}else{if(!this.data[f].isSpacelike()){return false}}}return e},NonSpaceLength:function(){var f=0;for(var e=0,d=this.data.length;e<d;e++){if(this.data[e]&&!this.data[e].isSpacelike()){f++}}return f},FirstNonSpace:function(){for(var e=0,d=this.data.length;e<d;e++){if(this.data[e]&&!this.data[e].isSpacelike()){return this.data[e]}}return null},LastNonSpace:function(){for(var d=this.data.length-1;d>=0;d--){if(this.data[0]&&!this.data[d].isSpacelike()){return this.data[d]}}return null},Core:function(){if(!(this.isEmbellished())||typeof(this.core)==="undefined"){return this}return this.data[this.core]},CoreMO:function(){if(!(this.isEmbellished())||typeof(this.core)==="undefined"){return this}return this.data[this.core].CoreMO()},toString:function(){if(this.inferred){return"["+this.data.join(",")+"]"}return this.SUPER(arguments).toString.call(this)},setTeXclass:function(f){for(var e=0,d=this.data.length;e<d;e++){if(this.data[e]){f=this.data[e].setTeXclass(f)}}if(this.data[0]){this.updateTeXclass(this.data[0])}return f}});a.mfrac=a.mbase.Subclass({type:"mfrac",num:0,den:1,linebreakContainer:true,texClass:a.TEXCLASS.INNER,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,linethickness:a.LINETHICKNESS.MEDIUM,numalign:a.ALIGN.CENTER,denomalign:a.ALIGN.CENTER,bevelled:false},adjustChild_displaystyle:function(d){return false},adjustChild_scriptlevel:function(e){var d=this.Get("scriptlevel");if(!this.Get("displaystyle")||d>0){d++}return d},adjustChild_texprimestyle:function(d){if(d==this.den){return true}return this.Get("texprimestyle")},setTeXclass:a.mbase.setSeparateTeXclasses});a.msqrt=a.mbase.Subclass({type:"msqrt",inferRow:true,linebreakContainer:true,texClass:a.TEXCLASS.ORD,setTeXclass:a.mbase.setSeparateTeXclasses,adjustChild_texprimestyle:function(d){return true}});a.mroot=a.mbase.Subclass({type:"mroot",linebreakContainer:true,texClass:a.TEXCLASS.ORD,adjustChild_displaystyle:function(d){if(d===1){return false}return this.Get("displaystyle")},adjustChild_scriptlevel:function(e){var d=this.Get("scriptlevel");if(e===1){d+=2}return d},adjustChild_texprimestyle:function(d){if(d===0){return true}return this.Get("texprimestyle")},setTeXclass:a.mbase.setSeparateTeXclasses});a.mstyle=a.mbase.Subclass({type:"mstyle",isSpacelike:a.mbase.childrenSpacelike,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,inferRow:true,defaults:{scriptlevel:a.INHERIT,displaystyle:a.INHERIT,scriptsizemultiplier:Math.sqrt(1/2),scriptminsize:"8pt",mathbackground:a.INHERIT,mathcolor:a.INHERIT,infixlinebreakstyle:a.LINEBREAKSTYLE.BEFORE,decimalseparator:"."},adjustChild_scriptlevel:function(f){var e=this.scriptlevel;if(e==null){e=this.Get("scriptlevel")}else{if(String(e).match(/^ *[-+]/)){delete this.scriptlevel;var d=this.Get("scriptlevel");this.scriptlevel=e;e=d+parseInt(e)}}return e},inheritFromMe:true,noInherit:{mpadded:{width:true,height:true,depth:true,lspace:true,voffset:true},mtable:{width:true,height:true,depth:true,align:true}},setTeXclass:a.mbase.setChildTeXclass});a.merror=a.mbase.Subclass({type:"merror",inferRow:true,linebreakContainer:true,texClass:a.TEXCLASS.ORD});a.mpadded=a.mbase.Subclass({type:"mpadded",inferRow:true,isSpacelike:a.mbase.childrenSpacelike,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,width:"",height:"",depth:"",lspace:0,voffset:0},setTeXclass:a.mbase.setChildTeXclass});a.mphantom=a.mbase.Subclass({type:"mphantom",texClass:a.TEXCLASS.ORD,inferRow:true,isSpacelike:a.mbase.childrenSpacelike,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,setTeXclass:a.mbase.setChildTeXclass});a.mfenced=a.mbase.Subclass({type:"mfenced",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,open:"(",close:")",separators:","},texClass:a.TEXCLASS.OPEN,setTeXclass:function(g){this.getPrevClass(g);var e=this.getValues("open","close","separators");e.open=e.open.replace(/[ \t\n\r]/g,"");e.close=e.close.replace(/[ \t\n\r]/g,"");e.separators=e.separators.replace(/[ \t\n\r]/g,"");if(e.open!==""){this.SetData("open",a.mo(e.open).With({stretchy:true,texClass:a.TEXCLASS.OPEN}));g=this.data.open.setTeXclass(g)}if(e.separators!==""){while(e.separators.length<this.data.length){e.separators+=e.separators.charAt(e.separators.length-1)}}if(this.data[0]){g=this.data[0].setTeXclass(g)}for(var f=1,d=this.data.length;f<d;f++){if(this.data[f]){if(e.separators!==""){this.SetData("sep"+f,a.mo(e.separators.charAt(f-1)));g=this.data["sep"+f].setTeXclass(g)}g=this.data[f].setTeXclass(g)}}if(e.close!==""){this.SetData("close",a.mo(e.close).With({stretchy:true,texClass:a.TEXCLASS.CLOSE}));g=this.data.close.setTeXclass(g)}this.updateTeXclass(this.data.open);return g}});a.menclose=a.mbase.Subclass({type:"menclose",inferRow:true,linebreakContainer:true,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,notation:a.NOTATION.LONGDIV,texClass:a.TEXCLASS.ORD},setTeXclass:a.mbase.setSeparateTeXclasses});a.msubsup=a.mbase.Subclass({type:"msubsup",base:0,sub:1,sup:2,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,subscriptshift:"",superscriptshift:"",texClass:a.AUTO},autoDefault:function(d){if(d==="texClass"){return(this.isEmbellished()?this.CoreMO().Get(d):a.TEXCLASS.ORD)}return 0},adjustChild_displaystyle:function(d){if(d>0){return false}return this.Get("displaystyle")},adjustChild_scriptlevel:function(e){var d=this.Get("scriptlevel");if(e>0){d++}return d},adjustChild_texprimestyle:function(d){if(d===this.sub){return true}return this.Get("texprimestyle")},setTeXclass:a.mbase.setBaseTeXclasses});a.msub=a.msubsup.Subclass({type:"msub"});a.msup=a.msubsup.Subclass({type:"msup",sub:2,sup:1});a.mmultiscripts=a.msubsup.Subclass({type:"mmultiscripts",adjustChild_texprimestyle:function(d){if(d%2===1){return true}return this.Get("texprimestyle")}});a.mprescripts=a.mbase.Subclass({type:"mprescripts"});a.none=a.mbase.Subclass({type:"none"});a.munderover=a.mbase.Subclass({type:"munderover",base:0,under:1,over:2,sub:1,sup:2,ACCENTS:["","accentunder","accent"],linebreakContainer:true,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,accent:a.AUTO,accentunder:a.AUTO,align:a.ALIGN.CENTER,texClass:a.AUTO,subscriptshift:"",superscriptshift:""},autoDefault:function(d){if(d==="texClass"){return(this.isEmbellished()?this.CoreMO().Get(d):a.TEXCLASS.ORD)}if(d==="accent"&&this.data[this.over]){return this.data[this.over].CoreMO().Get("accent")}if(d==="accentunder"&&this.data[this.under]){return this.data[this.under].CoreMO().Get("accent")}return false},adjustChild_displaystyle:function(d){if(d>0){return false}return this.Get("displaystyle")},adjustChild_scriptlevel:function(f){var e=this.Get("scriptlevel");var d=(this.data[this.base]&&!this.Get("displaystyle")&&this.data[this.base].CoreMO().Get("movablelimits"));if(f==this.under&&(d||!this.Get("accentunder"))){e++}if(f==this.over&&(d||!this.Get("accent"))){e++}return e},adjustChild_texprimestyle:function(d){if(d===this.base&&this.data[this.over]){return true}return this.Get("texprimestyle")},setTeXclass:a.mbase.setBaseTeXclasses});a.munder=a.munderover.Subclass({type:"munder"});a.mover=a.munderover.Subclass({type:"mover",over:1,under:2,sup:1,sub:2,ACCENTS:["","accent","accentunder"]});a.mtable=a.mbase.Subclass({type:"mtable",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,align:a.ALIGN.AXIS,rowalign:a.ALIGN.BASELINE,columnalign:a.ALIGN.CENTER,groupalign:"{left}",alignmentscope:true,columnwidth:a.WIDTH.AUTO,width:a.WIDTH.AUTO,rowspacing:"1ex",columnspacing:".8em",rowlines:a.LINES.NONE,columnlines:a.LINES.NONE,frame:a.LINES.NONE,framespacing:"0.4em 0.5ex",equalrows:false,equalcolumns:false,displaystyle:false,side:a.SIDE.RIGHT,minlabelspacing:"0.8em",texClass:a.TEXCLASS.ORD,useHeight:1},inheritFromMe:true,noInherit:{mover:{align:true},munder:{align:true},munderover:{align:true},mtable:{align:true,rowalign:true,columnalign:true,groupalign:true,alignmentscope:true,columnwidth:true,width:true,rowspacing:true,columnspacing:true,rowlines:true,columnlines:true,frame:true,framespacing:true,equalrows:true,equalcolumns:true,side:true,minlabelspacing:true,texClass:true,useHeight:1}},linebreakContainer:true,Append:function(){for(var e=0,d=arguments.length;e<d;e++){if(!((arguments[e] instanceof a.mtr)||(arguments[e] instanceof a.mlabeledtr))){arguments[e]=a.mtd(arguments[e])}}this.SUPER(arguments).Append.apply(this,arguments)},setTeXclass:a.mbase.setSeparateTeXclasses});a.mtr=a.mbase.Subclass({type:"mtr",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,rowalign:a.INHERIT,columnalign:a.INHERIT,groupalign:a.INHERIT},inheritFromMe:true,noInherit:{mrow:{rowalign:true,columnalign:true,groupalign:true},mtable:{rowalign:true,columnalign:true,groupalign:true}},linebreakContainer:true,Append:function(){for(var e=0,d=arguments.length;e<d;e++){if(!(arguments[e] instanceof a.mtd)){arguments[e]=a.mtd(arguments[e])}}this.SUPER(arguments).Append.apply(this,arguments)},setTeXclass:a.mbase.setSeparateTeXclasses});a.mtd=a.mbase.Subclass({type:"mtd",inferRow:true,linebreakContainer:true,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,rowspan:1,columnspan:1,rowalign:a.INHERIT,columnalign:a.INHERIT,groupalign:a.INHERIT},setTeXclass:a.mbase.setSeparateTeXclasses});a.maligngroup=a.mbase.Subclass({type:"malign",isSpacelike:function(){return true},defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,groupalign:a.INHERIT},inheritFromMe:true,noInherit:{mrow:{groupalign:true},mtable:{groupalign:true}}});a.malignmark=a.mbase.Subclass({type:"malignmark",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,edge:a.SIDE.LEFT},isSpacelike:function(){return true}});a.mlabeledtr=a.mtr.Subclass({type:"mlabeledtr"});a.maction=a.mbase.Subclass({type:"maction",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,actiontype:a.ACTIONTYPE.TOGGLE,selection:1},selected:function(){return this.data[this.Get("selection")-1]||a.NULL},isEmbellished:function(){return this.selected().isEmbellished()},isSpacelike:function(){return this.selected().isSpacelike()},Core:function(){return this.selected().Core()},CoreMO:function(){return this.selected().CoreMO()},setTeXclass:function(d){return this.selected().setTeXclass(d)}});a.semantics=a.mbase.Subclass({type:"semantics",isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{definitionURL:null,encoding:null},setTeXclass:a.mbase.setChildTeXclass});a.annotation=a.mbase.Subclass({type:"annotation",isToken:true,linebreakContainer:true,defaults:{definitionURL:null,encoding:null,cd:"mathmlkeys",name:"",src:null}});a["annotation-xml"]=a.mbase.Subclass({type:"annotation-xml",linebreakContainer:true,defaults:{definitionURL:null,encoding:null,cd:"mathmlkeys",name:"",src:null}});a.math=a.mstyle.Subclass({type:"math",defaults:{mathvariant:a.VARIANT.NORMAL,mathsize:a.SIZE.NORMAL,mathcolor:"",mathbackground:a.COLOR.TRANSPARENT,scriptlevel:0,displaystyle:a.AUTO,display:"inline",maxwidth:"",overflow:a.OVERFLOW.LINEBREAK,altimg:"","altimg-width":"","altimg-height":"","altimg-valign":"",alttext:"",cdgroup:"",scriptsizemultiplier:Math.sqrt(1/2),scriptminsize:"8px",infixlinebreakstyle:a.LINEBREAKSTYLE.BEFORE,lineleading:"1ex",indentshift:"auto",indentalign:a.INDENTALIGN.AUTO,indentalignfirst:a.INDENTALIGN.INDENTALIGN,indentshiftfirst:a.INDENTSHIFT.INDENTSHIFT,indentalignlast:a.INDENTALIGN.INDENTALIGN,indentshiftlast:a.INDENTSHIFT.INDENTSHIFT,decimalseparator:".",texprimestyle:false},autoDefault:function(d){if(d==="displaystyle"){return this.Get("display")==="block"}return""},linebreakContainer:true,setTeXclass:a.mbase.setChildTeXclass});a.chars=a.mbase.Subclass({type:"chars",Append:function(){this.data.push.apply(this.data,arguments)},value:function(){return this.data.join("")},toString:function(){return this.data.join("")}});a.entity=a.mbase.Subclass({type:"entity",Append:function(){this.data.push.apply(this.data,arguments)},value:function(){if(this.data[0].substr(0,2)==="#x"){return parseInt(this.data[0].substr(2),16)}else{if(this.data[0].substr(0,1)==="#"){return parseInt(this.data[0].substr(1))}else{return 0}}},toString:function(){var d=this.value();if(d<=65535){return String.fromCharCode(d)}d-=65536;return String.fromCharCode((d>>10)+55296)+String.fromCharCode((d&1023)+56320)}});a.xml=a.mbase.Subclass({type:"xml",Init:function(){this.div=document.createElement("div");return this.SUPER(arguments).Init.apply(this,arguments)},Append:function(){for(var e=0,d=arguments.length;e<d;e++){var f=this.Import(arguments[e]);this.data.push(f);this.div.appendChild(f)}},Import:function(h){if(document.importNode){return document.importNode(h,true)}var e,f,d;if(h.nodeType===1){e=document.createElement(h.nodeName);for(f=0,d=h.attributes.length;f<d;f++){var g=h.attributes[f];if(g.specified&&g.nodeValue!=null&&g.nodeValue!=""){e.setAttribute(g.nodeName,g.nodeValue)}if(g.nodeName==="style"){e.style.cssText=g.nodeValue}}if(h.className){e.className=h.className}}else{if(h.nodeType===3||h.nodeType===4){e=document.createTextNode(h.nodeValue)}else{if(h.nodeType===8){e=document.createComment(h.nodeValue)}else{return document.createTextNode("")}}}for(f=0,d=h.childNodes.length;f<d;f++){e.appendChild(this.Import(h.childNodes[f]))}return e},value:function(){return this.div},toString:function(){return this.div.innerHTML}});a.TeXAtom=a.mbase.Subclass({type:"texatom",inferRow:true,texClass:a.TEXCLASS.ORD,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,isEmbellished:a.mbase.childEmbellished,setTeXclass:function(d){this.data[0].setTeXclass();return this.adjustTeXclass(d)},adjustTeXclass:a.mo.prototype.adjustTeXclass});a.NULL=a.mbase().With({type:"null"});var b=a.TEXCLASS;var c={ORD:[0,0,b.ORD],ORD11:[1,1,b.ORD],ORD21:[2,1,b.ORD],ORD02:[0,2,b.ORD],ORD55:[5,5,b.ORD],OP:[1,2,b.OP,{largeop:true,movablelimits:true,symmetric:true}],OPFIXED:[1,2,b.OP,{largeop:true,movablelimits:true}],INTEGRAL:[0,1,b.OP,{largeop:true,symmetric:true}],INTEGRAL2:[1,2,b.OP,{largeop:true,symmetric:true}],BIN3:[3,3,b.BIN],BIN4:[4,4,b.BIN],BIN01:[0,1,b.BIN],BIN5:[5,5,b.BIN],TALLBIN:[4,4,b.BIN,{stretchy:true}],BINOP:[4,4,b.BIN,{largeop:true,movablelimits:true}],REL:[5,5,b.REL],REL1:[1,1,b.REL,{stretchy:true}],REL4:[4,4,b.REL],RELSTRETCH:[5,5,b.REL,{stretchy:true}],RELACCENT:[5,5,b.REL,{accent:true}],WIDEREL:[5,5,b.REL,{accent:true,stretchy:true}],OPEN:[0,0,b.OPEN,{fence:true,stretchy:true,symmetric:true}],CLOSE:[0,0,b.CLOSE,{fence:true,stretchy:true,symmetric:true}],INNER:[0,0,b.INNER],PUNCT:[0,3,b.PUNCT],ACCENT:[0,0,b.ORD,{accent:true}],WIDEACCENT:[0,0,b.ORD,{accent:true,stretchy:true}]};a.mo.Augment({SPACE:["0em","0.1111em","0.1667em","0.2222em","0.2667em","0.3333em"],RANGES:[[32,127,b.REL,"BasicLatin"],[160,255,b.ORD,"Latin1Supplement"],[256,383,b.ORD],[384,591,b.ORD],[688,767,b.ORD,"SpacingModLetters"],[768,879,b.ORD,"CombDiacritMarks"],[880,1023,b.ORD,"GreekAndCoptic"],[7680,7935,b.ORD],[8192,8303,b.PUNCT,"GeneralPunctuation"],[8304,8351,b.ORD],[8352,8399,b.ORD],[8400,8447,b.ORD,"CombDiactForSymbols"],[8448,8527,b.ORD,"LetterlikeSymbols"],[8528,8591,b.ORD],[8592,8703,b.REL,"Arrows"],[8704,8959,b.BIN,"MathOperators"],[8960,9215,b.ORD,"MiscTechnical"],[9312,9471,b.ORD],[9472,9631,b.ORD],[9632,9727,b.ORD,"GeometricShapes"],[9984,10175,b.ORD,"Dingbats"],[10176,10223,b.ORD,"MiscMathSymbolsA"],[10224,10239,b.REL,"SupplementalArrowsA"],[10496,10623,b.REL,"SupplementalArrowsB"],[10624,10751,b.ORD,"MiscMathSymbolsB"],[10752,11007,b.BIN,"SuppMathOperators"],[11008,11263,b.ORD,"MiscSymbolsAndArrows"],[119808,120831,b.ORD]],OPTABLE:{prefix:{"\u2200":c.ORD21,"\u2202":c.ORD21,"\u2203":c.ORD21,"\u2207":c.ORD21,"\u220F":c.OP,"\u2210":c.OP,"\u2211":c.OP,"\u2212":c.BIN01,"\u2213":c.BIN01,"\u221A":[1,1,b.ORD,{stretchy:true}],"\u2220":c.ORD,"\u222B":c.INTEGRAL,"\u222E":c.INTEGRAL,"\u22C0":c.OP,"\u22C1":c.OP,"\u22C2":c.OP,"\u22C3":c.OP,"\u2308":c.OPEN,"\u230A":c.OPEN,"\u27E8":c.OPEN,"\u27EE":c.OPEN,"\u2A00":c.OP,"\u2A01":c.OP,"\u2A02":c.OP,"\u2A04":c.OP,"\u2A06":c.OP,"\u00AC":c.ORD21,"\u00B1":c.BIN01,"(":c.OPEN,"+":c.BIN01,"-":c.BIN01,"[":c.OPEN,"{":c.OPEN,"|":c.OPEN},postfix:{"!":[1,0,b.CLOSE],"&":c.ORD,"\u2032":c.ORD02,"\u203E":c.WIDEACCENT,"\u2309":c.CLOSE,"\u230B":c.CLOSE,"\u23DE":c.WIDEACCENT,"\u23DF":c.WIDEACCENT,"\u266D":c.ORD02,"\u266E":c.ORD02,"\u266F":c.ORD02,"\u27E9":c.CLOSE,"\u27EF":c.CLOSE,"\u02C6":c.WIDEACCENT,"\u02C7":c.WIDEACCENT,"\u02C9":c.WIDEACCENT,"\u02CA":c.ACCENT,"\u02CB":c.ACCENT,"\u02D8":c.ACCENT,"\u02D9":c.ACCENT,"\u02DC":c.WIDEACCENT,"\u0302":c.WIDEACCENT,"\u00A8":c.ACCENT,"\u00AF":c.WIDEACCENT,")":c.CLOSE,"]":c.CLOSE,"^":c.WIDEACCENT,_:c.WIDEACCENT,"`":c.ACCENT,"|":c.CLOSE,"}":c.CLOSE,"~":c.WIDEACCENT},infix:{"":c.ORD,"%":[3,3,b.ORD],"\u2022":c.BIN4,"\u2026":c.INNER,"\u2044":c.TALLBIN,"\u2061":c.ORD,"\u2062":c.ORD,"\u2063":[0,0,b.ORD,{linebreakstyle:"after",separator:true}],"\u2064":c.ORD,"\u2190":c.WIDEREL,"\u2191":c.RELSTRETCH,"\u2192":c.WIDEREL,"\u2193":c.RELSTRETCH,"\u2194":c.WIDEREL,"\u2195":c.RELSTRETCH,"\u2196":c.RELSTRETCH,"\u2197":c.RELSTRETCH,"\u2198":c.RELSTRETCH,"\u2199":c.RELSTRETCH,"\u21A6":c.WIDEREL,"\u21A9":c.WIDEREL,"\u21AA":c.WIDEREL,"\u21BC":c.WIDEREL,"\u21BD":c.WIDEREL,"\u21C0":c.WIDEREL,"\u21C1":c.WIDEREL,"\u21CC":c.WIDEREL,"\u21D0":c.WIDEREL,"\u21D1":c.RELSTRETCH,"\u21D2":c.WIDEREL,"\u21D3":c.RELSTRETCH,"\u21D4":c.WIDEREL,"\u21D5":c.RELSTRETCH,"\u2208":c.REL,"\u2209":c.REL,"\u220B":c.REL,"\u2212":c.BIN4,"\u2213":c.BIN4,"\u2215":c.TALLBIN,"\u2216":c.BIN4,"\u2217":c.BIN4,"\u2218":c.BIN4,"\u2219":c.BIN4,"\u221D":c.REL,"\u2223":c.REL,"\u2225":c.REL,"\u2227":c.BIN4,"\u2228":c.BIN4,"\u2229":c.BIN4,"\u222A":c.BIN4,"\u223C":c.REL,"\u2240":c.BIN4,"\u2243":c.REL,"\u2245":c.REL,"\u2248":c.REL,"\u224D":c.REL,"\u2250":c.REL,"\u2260":c.REL,"\u2261":c.REL,"\u2264":c.REL,"\u2265":c.REL,"\u226A":c.REL,"\u226B":c.REL,"\u227A":c.REL,"\u227B":c.REL,"\u2282":c.REL,"\u2283":c.REL,"\u2286":c.REL,"\u2287":c.REL,"\u228E":c.BIN4,"\u2291":c.REL,"\u2292":c.REL,"\u2293":c.BIN4,"\u2294":c.BIN4,"\u2295":c.BIN4,"\u2296":c.BIN4,"\u2297":c.BIN4,"\u2298":c.BIN4,"\u2299":c.BIN4,"\u22A2":c.REL,"\u22A3":c.REL,"\u22A4":c.ORD55,"\u22A5":c.REL,"\u22A8":c.REL,"\u22C4":c.BIN4,"\u22C5":c.BIN4,"\u22C6":c.BIN4,"\u22C8":c.REL,"\u22EE":c.ORD55,"\u22EF":c.INNER,"\u22F1":[5,5,b.INNER],"\u25B3":c.BIN4,"\u25B5":c.BIN4,"\u25B9":c.BIN4,"\u25BD":c.BIN4,"\u25BF":c.BIN4,"\u25C3":c.BIN4,"\u2758":c.REL,"\u27F5":c.WIDEREL,"\u27F6":c.WIDEREL,"\u27F7":c.WIDEREL,"\u27F8":c.WIDEREL,"\u27F9":c.WIDEREL,"\u27FA":c.WIDEREL,"\u27FC":c.WIDEREL,"\u2A2F":c.BIN4,"\u2A3F":c.BIN4,"\u2AAF":c.REL,"\u2AB0":c.REL,"\u00B1":c.BIN4,"\u00B7":c.BIN4,"\u00D7":c.BIN4,"\u00F7":c.BIN4,"*":c.BIN3,"+":c.BIN4,",":[0,3,b.PUNCT,{linebreakstyle:"after",separator:true}],"-":c.BIN4,".":[3,3,b.ORD],"/":c.ORD11,":":[1,2,b.REL],";":[0,3,b.PUNCT,{linebreakstyle:"after",separator:true}],"<":c.REL,"=":c.REL,">":c.REL,"?":[1,1,b.CLOSE],"\\":c.ORD,"^":c.ORD11,_:c.ORD11,"|":[2,2,b.ORD,{fence:true,stretchy:true,symmetric:true}],"#":c.ORD,"$":c.ORD,"\u002E":[0,3,b.PUNCT,{separator:true}],"\u02B9":c.ORD,"\u0300":c.ACCENT,"\u0301":c.ACCENT,"\u0303":c.WIDEACCENT,"\u0304":c.ACCENT,"\u0306":c.ACCENT,"\u0307":c.ACCENT,"\u0308":c.ACCENT,"\u030C":c.ACCENT,"\u0332":c.WIDEACCENT,"\u0338":c.REL4,"\u2015":[0,0,b.ORD,{stretchy:true}],"\u2017":[0,0,b.ORD,{stretchy:true}],"\u2020":c.BIN3,"\u2021":c.BIN3,"\u20D7":c.ACCENT,"\u2111":c.ORD,"\u2113":c.ORD,"\u2118":c.ORD,"\u211C":c.ORD,"\u2205":c.ORD,"\u221E":c.ORD,"\u2305":c.BIN3,"\u2306":c.BIN3,"\u2322":c.REL4,"\u2323":c.REL4,"\u2329":c.OPEN,"\u232A":c.CLOSE,"\u23AA":c.ORD,"\u23AF":[0,0,b.ORD,{stretchy:true}],"\u23B0":c.OPEN,"\u23B1":c.CLOSE,"\u2500":c.ORD,"\u25EF":c.BIN3,"\u2660":c.ORD,"\u2661":c.ORD,"\u2662":c.ORD,"\u2663":c.ORD,"\u3008":c.OPEN,"\u3009":c.CLOSE,"\uFE37":c.WIDEACCENT,"\uFE38":c.WIDEACCENT}}},{OPTYPES:c});a.mo.prototype.OPTABLE.infix["^"]=c.WIDEREL;a.mo.prototype.OPTABLE.infix._=c.WIDEREL})(MathJax.ElementJax.mml);MathJax.ElementJax.mml.loadComplete("jax.js");

MathJax.Hub.Register.LoadHook("[MathJax]/jax/element/mml/jax.js",function(){var b="2.1";var a=MathJax.ElementJax.mml;SETTINGS=MathJax.Hub.config.menuSettings;a.mbase.Augment({toMathML:function(k){var g=(this.inferred&&this.parent.inferRow);if(k==null){k=""}var e=this.type,d=this.toMathMLattributes();if(e==="mspace"){return k+"<"+e+d+" />"}var j=[];var h=(this.isToken?"":k+(g?"":"  "));for(var f=0,c=this.data.length;f<c;f++){if(this.data[f]){j.push(this.data[f].toMathML(h))}else{if(!this.isToken){j.push(h+"<mrow />")}}}if(this.isToken){return k+"<"+e+d+">"+j.join("")+"</"+e+">"}if(g){return j.join("\n")}if(j.length===0||(j.length===1&&j[0]==="")){return k+"<"+e+d+" />"}return k+"<"+e+d+">\n"+j.join("\n")+"\n"+k+"</"+e+">"},toMathMLattributes:function(){var j=[],g=this.defaults;var c=(this.attrNames||a.copyAttributeNames),l=a.skipAttributes;if(this.type==="math"&&(!this.attr||!this.attr.xmlns)){j.push('xmlns="http://www.w3.org/1998/Math/MathML"')}if(!this.attrNames){if(this.type==="mstyle"){g=a.math.prototype.defaults}for(var d in g){if(!l[d]&&g.hasOwnProperty(d)){var e=(d==="open"||d==="close");if(this[d]!=null&&(e||this[d]!==g[d])){var k=this[d];delete this[d];if(e||this.Get(d)!==k){j.push(d+'="'+this.toMathMLattribute(k)+'"')}this[d]=k}}}}for(var h=0,f=c.length;h<f;h++){if(c[h]==="class"){continue}k=(this.attr||{})[c[h]];if(k==null){k=this[c[h]]}if(k!=null){j.push(c[h]+'="'+this.toMathMLquote(k)+'"')}}this.toMathMLclass(j);if(j.length){return" "+j.join(" ")}else{return""}},toMathMLclass:function(c){var e=[];if(this["class"]){e.push(this["class"])}if(this.isa(a.TeXAtom)&&SETTINGS.texHints){var d=["ORD","OP","BIN","REL","OPEN","CLOSE","PUNCT","INNER","VCENTER"][this.texClass];if(d){e.push("MJX-TeXAtom-"+d)}}if(this.mathvariant&&this.toMathMLvariants[this.mathvariant]){e.push("MJX"+this.mathvariant)}if(this.arrow){e.push("MJX-arrow")}if(this.variantForm){e.push("MJX-variant")}if(e.length){c.unshift('class="'+e.join(" ")+'"')}},toMathMLattribute:function(c){if(typeof(c)==="string"&&c.replace(/ /g,"").match(/^(([-+])?(\d+(\.\d*)?|\.\d+))mu$/)){return RegExp.$2+((1/18)*RegExp.$3).toFixed(3).replace(/\.?0+$/,"")+"em"}else{if(this.toMathMLvariants[c]){return this.toMathMLvariants[c]}}return this.toMathMLquote(c)},toMathMLvariants:{"-tex-caligraphic":a.VARIANT.SCRIPT,"-tex-caligraphic-bold":a.VARIANT.BOLDSCRIPT,"-tex-oldstyle":a.VARIANT.NORMAL,"-tex-oldstyle-bold":a.VARIANT.BOLD,"-tex-mathit":a.VARIANT.ITALIC},toMathMLquote:function(e){e=String(e).split("");for(var f=0,d=e.length;f<d;f++){var h=e[f].charCodeAt(0);if(h<32||h>126){e[f]="&#x"+h.toString(16).toUpperCase()+";"}else{var g={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;"}[e[f]];if(g){e[f]=g}}}return e.join("")}});a.msubsup.Augment({toMathML:function(h){var e=this.type;if(this.data[this.sup]==null){e="msub"}if(this.data[this.sub]==null){e="msup"}var d=this.toMathMLattributes();delete this.data[0].inferred;var g=[];for(var f=0,c=this.data.length;f<c;f++){if(this.data[f]){g.push(this.data[f].toMathML(h+"  "))}}return h+"<"+e+d+">\n"+g.join("\n")+"\n"+h+"</"+e+">"}});a.munderover.Augment({toMathML:function(h){var e=this.type;if(this.data[this.under]==null){e="mover"}if(this.data[this.over]==null){e="munder"}var d=this.toMathMLattributes();delete this.data[0].inferred;var g=[];for(var f=0,c=this.data.length;f<c;f++){if(this.data[f]){g.push(this.data[f].toMathML(h+"  "))}}return h+"<"+e+d+">\n"+g.join("\n")+"\n"+h+"</"+e+">"}});a.TeXAtom.Augment({toMathML:function(d){var c=this.toMathMLattributes();if(!c&&this.data[0].data.length===1){return d.substr(2)+this.data[0].toMathML(d)}return d+"<mrow"+c+">\n"+this.data[0].toMathML(d+"  ")+"\n"+d+"</mrow>"}});a.chars.Augment({toMathML:function(c){return(c||"")+this.toMathMLquote(this.toString())}});a.entity.Augment({toMathML:function(c){return(c||"")+"&"+this.data[0]+";<!-- "+this.toString()+" -->"}});a.xml.Augment({toMathML:function(c){return(c||"")+this.toString()}});MathJax.Hub.Register.StartupHook("TeX mathchoice Ready",function(){a.TeXmathchoice.Augment({toMathML:function(c){return this.Core().toMathML(c)}})});MathJax.Hub.Startup.signal.Post("toMathML Ready")});MathJax.Ajax.loadComplete("[MathJax]/extensions/toMathML.js");

(function(ag){var k;var aa=MathJax.Object.Subclass({firstChild:null,lastChild:null,Init:function(){this.childNodes=[]},appendChild:function(i){if(i.parent){i.parent.removeChild(i)}if(this.lastChild){this.lastChild.nextSibling=i}if(!this.firstChild){this.firstChild=i}this.childNodes.push(i);i.parent=this;this.lastChild=i;return i},removeChild:function(ak){for(var aj=0,ai=this.childNodes.length;aj<ai;aj++){if(this.childNodes[aj]===ak){break}}if(aj===ai){return}this.childNodes.splice(aj,1);if(ak===this.firstChild){this.firstChild=ak.nextSibling}if(ak===this.lastChild){if(!this.childNodes.length){this.lastChild=null}else{this.lastChild=this.childNodes[this.childNodes.length-1]}}if(aj){this.childNodes[aj-1].nextSibling=ak.nextSibling}ak.nextSibling=ak.parent=null;return ak},replaceChild:function(al,aj){for(var ak=0,ai=this.childNodes.length;ak<ai;ak++){if(this.childNodes[ak]===aj){break}}if(ak){this.childNodes[ak-1].nextSibling=al}else{this.firstChild=al}if(ak>=ai-1){this.lastChild=al}this.childNodes[ak]=al;al.nextSibling=aj.nextSibling;aj.nextSibling=aj.parent=null;return aj},toString:function(){return"{"+this.childNodes.join("")+"}"}});var E=function(){k=MathJax.ElementJax.mml;var i=k.mbase.prototype.Init;k.mbase.Augment({firstChild:null,lastChild:null,nodeValue:"",nextSibling:null,Init:function(){var ai=i.apply(this,arguments)||this;ai.childNodes=ai.data;ai.nodeName=ai.type;return ai},appendChild:function(al){if(al.parent){al.parent.removeChild(al)}var aj=arguments;if(al.isa(aa)){aj=al.childNodes;al.data=al.childNodes=[];al.firstChild=al.lastChild=null}for(var ak=0,ai=aj.length;ak<ai;ak++){al=aj[ak];if(this.lastChild){this.lastChild.nextSibling=al}if(!this.firstChild){this.firstChild=al}this.Append(al);this.lastChild=al;this.nodeValue+=al.nodeValue}return al},removeChild:function(ak){for(var aj=0,ai=this.childNodes.length;aj<ai;aj++){if(this.childNodes[aj]===ak){break}}if(aj===ai){return}this.childNodes.splice(aj,1);if(ak===this.firstChild){this.firstChild=ak.nextSibling}if(ak===this.lastChild){if(!this.childNodes.length){this.lastChild=null}else{this.lastChild=this.childNodes[this.childNodes.length-1]}}if(aj){this.childNodes[aj-1].nextSibling=ak.nextSibling}this.nodeValue="";for(aj=0,ai=this.childNodes.length;aj<ai;aj++){this.nodeValue+=this.childNodes[aj].nodeValue}ak.nextSibling=ak.parent=null;return ak},replaceChild:function(al,aj){for(var ak=0,ai=this.childNodes.length;ak<ai;ak++){if(this.childNodes[ak]===aj){break}}if(ak){this.childNodes[ak-1].nextSibling=al}else{this.firstChild=al}if(ak>=ai-1){this.lastChild=al}this.SetData(ak,al);al.nextSibling=aj.nextSibling;this.nodeValue="";for(ak=0,ai=this.childNodes.length;ak<ai;ak++){this.nodeValue+=this.childNodes[ak].nodeValue}aj.nextSibling=aj.parent=null;return aj},setAttribute:function(ai,aj){this[ai]=aj}})};var S={};var g={getElementById:true,createElementNS:function(ai,i){return k[i]()},createTextNode:function(i){return k.chars(i).With({nodeValue:i})},createDocumentFragment:function(){return aa()}};var O={appName:"MathJax"};var ac;var I="red";var ad="serif";var t=true;var C=true;var f=".";var q=g.createElementNS==null;function V(i){if(q){return g.createElement(i)}else{return g.createElementNS("http://www.w3.org/1999/xhtml",i)}}var J=[61237,8492,61238,61239,8496,8497,61240,8459,8464,61241,61242,8466,8499,61243,61244,61245,61246,8475,61247,61248,61249,61250,61251,61252,61253,61254];var N=[61277,61278,8493,61279,61280,61281,61282,8460,8465,61283,61284,61285,61286,61287,61288,61289,61290,8476,61291,61292,61293,61294,61295,61296,61297,8488];var D=[61324,61325,8450,61326,61327,61328,61329,8461,61330,61331,61332,61333,61334,8469,61335,8473,8474,8477,61336,61337,61338,61339,61340,61341,61342,8484];var d=0,H=1,X=2,m=3,b=4,l=5,a=6,P=7,Z=8,r=9,ab=10;var j={input:"sqrt",tag:"msqrt",output:"sqrt",tex:null,ttype:H},af={input:"root",tag:"mroot",output:"root",tex:null,ttype:X},A={input:"frac",tag:"mfrac",output:"/",tex:null,ttype:X},Q={input:"/",tag:"mfrac",output:"/",tex:null,ttype:m},o={input:"stackrel",tag:"mover",output:"stackrel",tex:null,ttype:X},s={input:"_",tag:"msub",output:"_",tex:null,ttype:m},h={input:"^",tag:"msup",output:"^",tex:null,ttype:m},ah={input:"text",tag:"mtext",output:"text",tex:null,ttype:ab},x={input:"mbox",tag:"mtext",output:"mbox",tex:null,ttype:ab},p={input:'"',tag:"mtext",output:"mbox",tex:null,ttype:ab};var G=[{input:"alpha",tag:"mi",output:"\u03B1",tex:null,ttype:d},{input:"beta",tag:"mi",output:"\u03B2",tex:null,ttype:d},{input:"chi",tag:"mi",output:"\u03C7",tex:null,ttype:d},{input:"delta",tag:"mi",output:"\u03B4",tex:null,ttype:d},{input:"Delta",tag:"mo",output:"\u0394",tex:null,ttype:d},{input:"epsi",tag:"mi",output:"\u03B5",tex:"epsilon",ttype:d},{input:"varepsilon",tag:"mi",output:"\u025B",tex:null,ttype:d},{input:"eta",tag:"mi",output:"\u03B7",tex:null,ttype:d},{input:"gamma",tag:"mi",output:"\u03B3",tex:null,ttype:d},{input:"Gamma",tag:"mo",output:"\u0393",tex:null,ttype:d},{input:"iota",tag:"mi",output:"\u03B9",tex:null,ttype:d},{input:"kappa",tag:"mi",output:"\u03BA",tex:null,ttype:d},{input:"lambda",tag:"mi",output:"\u03BB",tex:null,ttype:d},{input:"Lambda",tag:"mo",output:"\u039B",tex:null,ttype:d},{input:"mu",tag:"mi",output:"\u03BC",tex:null,ttype:d},{input:"nu",tag:"mi",output:"\u03BD",tex:null,ttype:d},{input:"omega",tag:"mi",output:"\u03C9",tex:null,ttype:d},{input:"Omega",tag:"mo",output:"\u03A9",tex:null,ttype:d},{input:"phi",tag:"mi",output:"\u03C6",tex:null,ttype:d},{input:"varphi",tag:"mi",output:"\u03D5",tex:null,ttype:d},{input:"Phi",tag:"mo",output:"\u03A6",tex:null,ttype:d},{input:"pi",tag:"mi",output:"\u03C0",tex:null,ttype:d},{input:"Pi",tag:"mo",output:"\u03A0",tex:null,ttype:d},{input:"psi",tag:"mi",output:"\u03C8",tex:null,ttype:d},{input:"Psi",tag:"mi",output:"\u03A8",tex:null,ttype:d},{input:"rho",tag:"mi",output:"\u03C1",tex:null,ttype:d},{input:"sigma",tag:"mi",output:"\u03C3",tex:null,ttype:d},{input:"Sigma",tag:"mo",output:"\u03A3",tex:null,ttype:d},{input:"tau",tag:"mi",output:"\u03C4",tex:null,ttype:d},{input:"theta",tag:"mi",output:"\u03B8",tex:null,ttype:d},{input:"vartheta",tag:"mi",output:"\u03D1",tex:null,ttype:d},{input:"Theta",tag:"mo",output:"\u0398",tex:null,ttype:d},{input:"upsilon",tag:"mi",output:"\u03C5",tex:null,ttype:d},{input:"xi",tag:"mi",output:"\u03BE",tex:null,ttype:d},{input:"Xi",tag:"mo",output:"\u039E",tex:null,ttype:d},{input:"zeta",tag:"mi",output:"\u03B6",tex:null,ttype:d},{input:"*",tag:"mo",output:"\u22C5",tex:"cdot",ttype:d},{input:"**",tag:"mo",output:"\u22C6",tex:"star",ttype:d},{input:"//",tag:"mo",output:"/",tex:null,ttype:d},{input:"\\\\",tag:"mo",output:"\\",tex:"backslash",ttype:d},{input:"setminus",tag:"mo",output:"\\",tex:null,ttype:d},{input:"xx",tag:"mo",output:"\u00D7",tex:"times",ttype:d},{input:"-:",tag:"mo",output:"\u00F7",tex:"divide",ttype:d},{input:"@",tag:"mo",output:"\u2218",tex:"circ",ttype:d},{input:"o+",tag:"mo",output:"\u2295",tex:"oplus",ttype:d},{input:"ox",tag:"mo",output:"\u2297",tex:"otimes",ttype:d},{input:"o.",tag:"mo",output:"\u2299",tex:"odot",ttype:d},{input:"sum",tag:"mo",output:"\u2211",tex:null,ttype:P},{input:"prod",tag:"mo",output:"\u220F",tex:null,ttype:P},{input:"^^",tag:"mo",output:"\u2227",tex:"wedge",ttype:d},{input:"^^^",tag:"mo",output:"\u22C0",tex:"bigwedge",ttype:P},{input:"vv",tag:"mo",output:"\u2228",tex:"vee",ttype:d},{input:"vvv",tag:"mo",output:"\u22C1",tex:"bigvee",ttype:P},{input:"nn",tag:"mo",output:"\u2229",tex:"cap",ttype:d},{input:"nnn",tag:"mo",output:"\u22C2",tex:"bigcap",ttype:P},{input:"uu",tag:"mo",output:"\u222A",tex:"cup",ttype:d},{input:"uuu",tag:"mo",output:"\u22C3",tex:"bigcup",ttype:P},{input:"!=",tag:"mo",output:"\u2260",tex:"ne",ttype:d},{input:":=",tag:"mo",output:":=",tex:null,ttype:d},{input:"lt",tag:"mo",output:"<",tex:null,ttype:d},{input:"<=",tag:"mo",output:"\u2264",tex:"le",ttype:d},{input:"lt=",tag:"mo",output:"\u2264",tex:"leq",ttype:d},{input:">=",tag:"mo",output:"\u2265",tex:"ge",ttype:d},{input:"geq",tag:"mo",output:"\u2265",tex:null,ttype:d},{input:"-<",tag:"mo",output:"\u227A",tex:"prec",ttype:d},{input:"-lt",tag:"mo",output:"\u227A",tex:null,ttype:d},{input:">-",tag:"mo",output:"\u227B",tex:"succ",ttype:d},{input:"in",tag:"mo",output:"\u2208",tex:null,ttype:d},{input:"!in",tag:"mo",output:"\u2209",tex:"notin",ttype:d},{input:"sub",tag:"mo",output:"\u2282",tex:"subset",ttype:d},{input:"sup",tag:"mo",output:"\u2283",tex:"supset",ttype:d},{input:"sube",tag:"mo",output:"\u2286",tex:"subseteq",ttype:d},{input:"supe",tag:"mo",output:"\u2287",tex:"supseteq",ttype:d},{input:"-=",tag:"mo",output:"\u2261",tex:"equiv",ttype:d},{input:"~=",tag:"mo",output:"\u2245",tex:"cong",ttype:d},{input:"~~",tag:"mo",output:"\u2248",tex:"approx",ttype:d},{input:"prop",tag:"mo",output:"\u221D",tex:"propto",ttype:d},{input:"and",tag:"mtext",output:"and",tex:null,ttype:a},{input:"or",tag:"mtext",output:"or",tex:null,ttype:a},{input:"not",tag:"mo",output:"\u00AC",tex:"neg",ttype:d},{input:"=>",tag:"mo",output:"\u21D2",tex:"implies",ttype:d},{input:"if",tag:"mo",output:"if",tex:null,ttype:a},{input:"<=>",tag:"mo",output:"\u21D4",tex:"iff",ttype:d},{input:"AA",tag:"mo",output:"\u2200",tex:"forall",ttype:d},{input:"EE",tag:"mo",output:"\u2203",tex:"exists",ttype:d},{input:"_|_",tag:"mo",output:"\u22A5",tex:"bot",ttype:d},{input:"TT",tag:"mo",output:"\u22A4",tex:"top",ttype:d},{input:"|--",tag:"mo",output:"\u22A2",tex:"vdash",ttype:d},{input:"|==",tag:"mo",output:"\u22A8",tex:"models",ttype:d},{input:"(",tag:"mo",output:"(",tex:null,ttype:b},{input:")",tag:"mo",output:")",tex:null,ttype:l},{input:"[",tag:"mo",output:"[",tex:null,ttype:b},{input:"]",tag:"mo",output:"]",tex:null,ttype:l},{input:"{",tag:"mo",output:"{",tex:null,ttype:b},{input:"}",tag:"mo",output:"}",tex:null,ttype:l},{input:"|",tag:"mo",output:"|",tex:null,ttype:r},{input:"(:",tag:"mo",output:"\u2329",tex:"langle",ttype:b},{input:":)",tag:"mo",output:"\u232A",tex:"rangle",ttype:l},{input:"<<",tag:"mo",output:"\u2329",tex:null,ttype:b},{input:">>",tag:"mo",output:"\u232A",tex:null,ttype:l},{input:"{:",tag:"mo",output:"{:",tex:null,ttype:b,invisible:true},{input:":}",tag:"mo",output:":}",tex:null,ttype:l,invisible:true},{input:"int",tag:"mo",output:"\u222B",tex:null,ttype:d},{input:"dx",tag:"mi",output:"{:d x:}",tex:null,ttype:Z},{input:"dy",tag:"mi",output:"{:d y:}",tex:null,ttype:Z},{input:"dz",tag:"mi",output:"{:d z:}",tex:null,ttype:Z},{input:"dt",tag:"mi",output:"{:d t:}",tex:null,ttype:Z},{input:"oint",tag:"mo",output:"\u222E",tex:null,ttype:d},{input:"del",tag:"mo",output:"\u2202",tex:"partial",ttype:d},{input:"grad",tag:"mo",output:"\u2207",tex:"nabla",ttype:d},{input:"+-",tag:"mo",output:"\u00B1",tex:"pm",ttype:d},{input:"O/",tag:"mo",output:"\u2205",tex:"emptyset",ttype:d},{input:"oo",tag:"mo",output:"\u221E",tex:"infty",ttype:d},{input:"aleph",tag:"mo",output:"\u2135",tex:null,ttype:d},{input:"...",tag:"mo",output:"...",tex:"ldots",ttype:d},{input:":.",tag:"mo",output:"\u2234",tex:"therefore",ttype:d},{input:"/_",tag:"mo",output:"\u2220",tex:"angle",ttype:d},{input:"\\ ",tag:"mo",output:"\u00A0",tex:null,ttype:d},{input:"quad",tag:"mo",output:"\u00A0\u00A0",tex:null,ttype:d},{input:"qquad",tag:"mo",output:"\u00A0\u00A0\u00A0\u00A0",tex:null,ttype:d},{input:"cdots",tag:"mo",output:"\u22EF",tex:null,ttype:d},{input:"vdots",tag:"mo",output:"\u22EE",tex:null,ttype:d},{input:"ddots",tag:"mo",output:"\u22F1",tex:null,ttype:d},{input:"diamond",tag:"mo",output:"\u22C4",tex:null,ttype:d},{input:"square",tag:"mo",output:"\u25A1",tex:null,ttype:d},{input:"|__",tag:"mo",output:"\u230A",tex:"lfloor",ttype:d},{input:"__|",tag:"mo",output:"\u230B",tex:"rfloor",ttype:d},{input:"|~",tag:"mo",output:"\u2308",tex:"lceiling",ttype:d},{input:"~|",tag:"mo",output:"\u2309",tex:"rceiling",ttype:d},{input:"CC",tag:"mo",output:"\u2102",tex:null,ttype:d},{input:"NN",tag:"mo",output:"\u2115",tex:null,ttype:d},{input:"QQ",tag:"mo",output:"\u211A",tex:null,ttype:d},{input:"RR",tag:"mo",output:"\u211D",tex:null,ttype:d},{input:"ZZ",tag:"mo",output:"\u2124",tex:null,ttype:d},{input:"f",tag:"mi",output:"f",tex:null,ttype:H,func:true},{input:"g",tag:"mi",output:"g",tex:null,ttype:H,func:true},{input:"lim",tag:"mo",output:"lim",tex:null,ttype:P},{input:"Lim",tag:"mo",output:"Lim",tex:null,ttype:P},{input:"sin",tag:"mo",output:"sin",tex:null,ttype:H,func:true},{input:"cos",tag:"mo",output:"cos",tex:null,ttype:H,func:true},{input:"tan",tag:"mo",output:"tan",tex:null,ttype:H,func:true},{input:"sinh",tag:"mo",output:"sinh",tex:null,ttype:H,func:true},{input:"cosh",tag:"mo",output:"cosh",tex:null,ttype:H,func:true},{input:"tanh",tag:"mo",output:"tanh",tex:null,ttype:H,func:true},{input:"cot",tag:"mo",output:"cot",tex:null,ttype:H,func:true},{input:"sec",tag:"mo",output:"sec",tex:null,ttype:H,func:true},{input:"csc",tag:"mo",output:"csc",tex:null,ttype:H,func:true},{input:"log",tag:"mo",output:"log",tex:null,ttype:H,func:true},{input:"ln",tag:"mo",output:"ln",tex:null,ttype:H,func:true},{input:"det",tag:"mo",output:"det",tex:null,ttype:H,func:true},{input:"dim",tag:"mo",output:"dim",tex:null,ttype:d},{input:"mod",tag:"mo",output:"mod",tex:null,ttype:d},{input:"gcd",tag:"mo",output:"gcd",tex:null,ttype:H,func:true},{input:"lcm",tag:"mo",output:"lcm",tex:null,ttype:H,func:true},{input:"lub",tag:"mo",output:"lub",tex:null,ttype:d},{input:"glb",tag:"mo",output:"glb",tex:null,ttype:d},{input:"min",tag:"mo",output:"min",tex:null,ttype:P},{input:"max",tag:"mo",output:"max",tex:null,ttype:P},{input:"uarr",tag:"mo",output:"\u2191",tex:"uparrow",ttype:d},{input:"darr",tag:"mo",output:"\u2193",tex:"downarrow",ttype:d},{input:"rarr",tag:"mo",output:"\u2192",tex:"rightarrow",ttype:d},{input:"->",tag:"mo",output:"\u2192",tex:"to",ttype:d},{input:"|->",tag:"mo",output:"\u21A6",tex:"mapsto",ttype:d},{input:"larr",tag:"mo",output:"\u2190",tex:"leftarrow",ttype:d},{input:"harr",tag:"mo",output:"\u2194",tex:"leftrightarrow",ttype:d},{input:"rArr",tag:"mo",output:"\u21D2",tex:"Rightarrow",ttype:d},{input:"lArr",tag:"mo",output:"\u21D0",tex:"Leftarrow",ttype:d},{input:"hArr",tag:"mo",output:"\u21D4",tex:"Leftrightarrow",ttype:d},j,af,A,Q,o,s,h,{input:"hat",tag:"mover",output:"\u005E",tex:null,ttype:H,acc:true},{input:"bar",tag:"mover",output:"\u00AF",tex:"overline",ttype:H,acc:true},{input:"vec",tag:"mover",output:"\u2192",tex:null,ttype:H,acc:true},{input:"dot",tag:"mover",output:".",tex:null,ttype:H,acc:true},{input:"ddot",tag:"mover",output:"..",tex:null,ttype:H,acc:true},{input:"ul",tag:"munder",output:"\u0332",tex:"underline",ttype:H,acc:true},ah,x,p,{input:"bb",tag:"mstyle",atname:"fontweight",atval:"bold",output:"bb",tex:null,ttype:H},{input:"mathbf",tag:"mstyle",atname:"fontweight",atval:"bold",output:"mathbf",tex:null,ttype:H},{input:"sf",tag:"mstyle",atname:"fontfamily",atval:"sans-serif",output:"sf",tex:null,ttype:H},{input:"mathsf",tag:"mstyle",atname:"fontfamily",atval:"sans-serif",output:"mathsf",tex:null,ttype:H},{input:"bbb",tag:"mstyle",atname:"mathvariant",atval:"double-struck",output:"bbb",tex:null,ttype:H,codes:D},{input:"mathbb",tag:"mstyle",atname:"mathvariant",atval:"double-struck",output:"mathbb",tex:null,ttype:H,codes:D},{input:"cc",tag:"mstyle",atname:"mathvariant",atval:"script",output:"cc",tex:null,ttype:H,codes:J},{input:"mathcal",tag:"mstyle",atname:"mathvariant",atval:"script",output:"mathcal",tex:null,ttype:H,codes:J},{input:"tt",tag:"mstyle",atname:"fontfamily",atval:"monospace",output:"tt",tex:null,ttype:H},{input:"mathtt",tag:"mstyle",atname:"fontfamily",atval:"monospace",output:"mathtt",tex:null,ttype:H},{input:"fr",tag:"mstyle",atname:"mathvariant",atval:"fraktur",output:"fr",tex:null,ttype:H,codes:N},{input:"mathfrak",tag:"mstyle",atname:"mathvariant",atval:"fraktur",output:"mathfrak",tex:null,ttype:H,codes:N}];function W(ai,i){if(ai.input>i.input){return 1}else{return -1}}var U=[];function v(){var aj=[],ai;for(ai=0;ai<G.length;ai++){if(G[ai].tex){aj[aj.length]={input:G[ai].tex,tag:G[ai].tag,output:G[ai].output,ttype:G[ai].ttype}}}G=G.concat(aj);G.sort(W);for(ai=0;ai<G.length;ai++){U[ai]=G[ai].input}}var Y="http://www.w3.org/1998/Math/MathML";function R(i){if(q){return g.createElement("m:"+i)}else{return g.createElementNS(Y,i)}}function M(i,aj){if(q){var ai=g.createElement("m:"+i)}else{ai=g.createElementNS(Y,i)}ai.appendChild(aj);return ai}function B(i,ai){G=G.concat([{input:i,tag:"mo",output:ai,tex:null,ttype:Z}]);G.sort(W);for(ac=0;ac<G.length;ac++){U[ac]=G[ac].input}}function u(ak,al){var ai;if(ak.charAt(al)=="\\"&&ak.charAt(al+1)!="\\"&&ak.charAt(al+1)!=" "){ai=ak.slice(al+1)}else{ai=ak.slice(al)}for(var aj=0;aj<ai.length&&ai.charCodeAt(aj)<=32;aj=aj+1){}return ai.slice(aj)}function c(aj,am,an){if(an==0){var al,ai;an=-1;al=aj.length;while(an+1<al){ai=(an+al)>>1;if(aj[ai]<am){an=ai}else{al=ai}}return al}else{for(var ak=an;ak<aj.length&&aj[ak]<am;ak++){}}return ak}function n(ao){var ai=0;var aj=0;var al;var ar;var aq;var am="";var an=true;for(var ak=1;ak<=ao.length&&an;ak++){ar=ao.slice(0,ak);aj=ai;ai=c(U,ar,aj);if(ai<U.length&&ao.slice(0,U[ai].length)==U[ai]){am=U[ai];al=ai;ak=am.length}an=ai<U.length&&ao.slice(0,U[ai].length)>=U[ai]}y=F;if(am!=""){F=G[al].ttype;return G[al]}F=d;ai=1;ar=ao.slice(0,1);var ap=true;while("0"<=ar&&ar<="9"&&ai<=ao.length){ar=ao.slice(ai,ai+1);ai++}if(ar==f){ar=ao.slice(ai,ai+1);if("0"<=ar&&ar<="9"){ap=false;ai++;while("0"<=ar&&ar<="9"&&ai<=ao.length){ar=ao.slice(ai,ai+1);ai++}}}if((ap&&ai>1)||ai>2){ar=ao.slice(0,ai-1);aq="mn"}else{ai=2;ar=ao.slice(0,1);aq=(("A">ar||ar>"Z")&&("a">ar||ar>"z")?"mo":"mi")}if(ar=="-"&&y==m){F=m;return{input:ar,tag:aq,output:ar,ttype:H,func:true}}return{input:ar,tag:aq,output:ar,ttype:d}}function T(ai){var i;if(ai.nodeName=="mrow"){i=ai.firstChild.firstChild.nodeValue;if(i=="("||i=="["||i=="{"){ai.removeChild(ai.firstChild)}}if(ai.nodeName=="mrow"){i=ai.lastChild.firstChild.nodeValue;if(i==")"||i=="]"||i=="}"){ai.removeChild(ai.lastChild)}}}var K,y,F;function L(ao){var ak,aj,ar,am,aq,an=g.createDocumentFragment();ao=u(ao,0);ak=n(ao);if(ak==null||ak.ttype==l&&K>0){return[null,ao]}if(ak.ttype==Z){ao=ak.output+u(ao,ak.input.length);ak=n(ao)}switch(ak.ttype){case P:case d:ao=u(ao,ak.input.length);return[M(ak.tag,g.createTextNode(ak.output)),ao];case b:K++;ao=u(ao,ak.input.length);ar=w(ao,true);K--;if(typeof ak.invisible=="boolean"&&ak.invisible){aj=M("mrow",ar[0])}else{aj=M("mo",g.createTextNode(ak.output));aj=M("mrow",aj);aj.appendChild(ar[0])}return[aj,ar[1]];case ab:if(ak!=p){ao=u(ao,ak.input.length)}if(ao.charAt(0)=="{"){am=ao.indexOf("}")}else{if(ao.charAt(0)=="("){am=ao.indexOf(")")}else{if(ao.charAt(0)=="["){am=ao.indexOf("]")}else{if(ak==p){am=ao.slice(1).indexOf('"')+1}else{am=0}}}}if(am==-1){am=ao.length}aq=ao.slice(1,am);if(aq.charAt(0)==" "){aj=R("mspace");aj.setAttribute("width","1ex");an.appendChild(aj)}an.appendChild(M(ak.tag,g.createTextNode(aq)));if(aq.charAt(aq.length-1)==" "){aj=R("mspace");aj.setAttribute("width","1ex");an.appendChild(aj)}ao=u(ao,am+1);return[M("mrow",an),ao];case H:ao=u(ao,ak.input.length);ar=L(ao);if(ar[0]==null){return[M(ak.tag,g.createTextNode(ak.output)),ao]}if(typeof ak.func=="boolean"&&ak.func){aq=ao.charAt(0);if(aq=="^"||aq=="_"||aq=="/"||aq=="|"||aq==","){return[M(ak.tag,g.createTextNode(ak.output)),ao]}else{aj=M("mrow",M(ak.tag,g.createTextNode(ak.output)));aj.appendChild(ar[0]);return[aj,ar[1]]}}T(ar[0]);if(ak.input=="sqrt"){return[M(ak.tag,ar[0]),ar[1]]}else{if(typeof ak.acc=="boolean"&&ak.acc){aj=M(ak.tag,ar[0]);aj.appendChild(M("mo",g.createTextNode(ak.output)));return[aj,ar[1]]}else{if(!q&&typeof ak.codes!="undefined"){for(am=0;am<ar[0].childNodes.length;am++){if(ar[0].childNodes[am].nodeName=="mi"||ar[0].nodeName=="mi"){aq=(ar[0].nodeName=="mi"?ar[0].firstChild.nodeValue:ar[0].childNodes[am].firstChild.nodeValue);var ap=[];for(var al=0;al<aq.length;al++){if(aq.charCodeAt(al)>64&&aq.charCodeAt(al)<91){ap=ap+String.fromCharCode(ak.codes[aq.charCodeAt(al)-65])}else{ap=ap+aq.charAt(al)}}if(ar[0].nodeName=="mi"){ar[0]=R("mo").appendChild(g.createTextNode(ap))}else{ar[0].replaceChild(R("mo").appendChild(g.createTextNode(ap)),ar[0].childNodes[am])}}}}aj=M(ak.tag,ar[0]);aj.setAttribute(ak.atname,ak.atval);return[aj,ar[1]]}}case X:ao=u(ao,ak.input.length);ar=L(ao);if(ar[0]==null){return[M("mo",g.createTextNode(ak.input)),ao]}T(ar[0]);var ai=L(ar[1]);if(ai[0]==null){return[M("mo",g.createTextNode(ak.input)),ao]}T(ai[0]);if(ak.input=="root"||ak.input=="stackrel"){an.appendChild(ai[0])}an.appendChild(ar[0]);if(ak.input=="frac"){an.appendChild(ai[0])}return[M(ak.tag,an),ai[1]];case m:ao=u(ao,ak.input.length);return[M("mo",g.createTextNode(ak.output)),ao];case a:ao=u(ao,ak.input.length);aj=R("mspace");aj.setAttribute("width","1ex");an.appendChild(aj);an.appendChild(M(ak.tag,g.createTextNode(ak.output)));aj=R("mspace");aj.setAttribute("width","1ex");an.appendChild(aj);return[M("mrow",an),ao];case r:K++;ao=u(ao,ak.input.length);ar=w(ao,false);K--;aq="";if(ar[0].lastChild!=null){aq=ar[0].lastChild.firstChild.nodeValue}if(aq=="|"){aj=M("mo",g.createTextNode(ak.output));aj=M("mrow",aj);aj.appendChild(ar[0]);return[aj,ar[1]]}else{aj=M("mo",g.createTextNode(ak.output));aj=M("mrow",aj);return[aj,ao]}default:ao=u(ao,ak.input.length);return[M(ak.tag,g.createTextNode(ak.output)),ao]}}function z(an){var al,ao,am,ak,i,aj;an=u(an,0);ao=n(an);i=L(an);ak=i[0];an=i[1];al=n(an);if(al.ttype==m&&al.input!="/"){an=u(an,al.input.length);i=L(an);if(i[0]==null){i[0]=M("mo",g.createTextNode("\u25A1"))}else{T(i[0])}an=i[1];if(al.input=="_"){am=n(an);aj=(ao.ttype==P);if(am.input=="^"){an=u(an,am.input.length);var ai=L(an);T(ai[0]);an=ai[1];ak=M((aj?"munderover":"msubsup"),ak);ak.appendChild(i[0]);ak.appendChild(ai[0]);ak=M("mrow",ak)}else{ak=M((aj?"munder":"msub"),ak);ak.appendChild(i[0])}}else{ak=M(al.tag,ak);ak.appendChild(i[0])}}return[ak,an]}function w(aq,ap){var av,ar,am,ay,an=g.createDocumentFragment();do{aq=u(aq,0);am=z(aq);ar=am[0];aq=am[1];av=n(aq);if(av.ttype==m&&av.input=="/"){aq=u(aq,av.input.length);am=z(aq);if(am[0]==null){am[0]=M("mo",g.createTextNode("\u25A1"))}else{T(am[0])}aq=am[1];T(ar);ar=M(av.tag,ar);ar.appendChild(am[0]);an.appendChild(ar);av=n(aq)}else{if(ar!=undefined){an.appendChild(ar)}}}while((av.ttype!=l&&(av.ttype!=r||ap)||K==0)&&av!=null&&av.output!="");if(av.ttype==l||av.ttype==r){var az=an.childNodes.length;if(az>0&&an.childNodes[az-1].nodeName=="mrow"&&az>1&&an.childNodes[az-2].nodeName=="mo"&&an.childNodes[az-2].firstChild.nodeValue==","){var aB=an.childNodes[az-1].lastChild.firstChild.nodeValue;if(aB==")"||aB=="]"){var aj=an.childNodes[az-1].firstChild.firstChild.nodeValue;if(aj=="("&&aB==")"&&av.output!="}"||aj=="["&&aB=="]"){var ak=[];var aw=true;var at=an.childNodes.length;for(ay=0;aw&&ay<at;ay=ay+2){ak[ay]=[];ar=an.childNodes[ay];if(aw){aw=ar.nodeName=="mrow"&&(ay==at-1||ar.nextSibling.nodeName=="mo"&&ar.nextSibling.firstChild.nodeValue==",")&&ar.firstChild.firstChild.nodeValue==aj&&ar.lastChild.firstChild.nodeValue==aB}if(aw){for(var ax=0;ax<ar.childNodes.length;ax++){if(ar.childNodes[ax].firstChild.nodeValue==","){ak[ay][ak[ay].length]=ax}}}if(aw&&ay>1){aw=ak[ay].length==ak[ay-2].length}}if(aw){var al,ai,ao,au,aA=g.createDocumentFragment();for(ay=0;ay<at;ay=ay+2){al=g.createDocumentFragment();ai=g.createDocumentFragment();ar=an.firstChild;ao=ar.childNodes.length;au=0;ar.removeChild(ar.firstChild);for(ax=1;ax<ao-1;ax++){if(typeof ak[ay][au]!="undefined"&&ax==ak[ay][au]){ar.removeChild(ar.firstChild);al.appendChild(M("mtd",ai));au++}else{ai.appendChild(ar.firstChild)}}al.appendChild(M("mtd",ai));if(an.childNodes.length>2){an.removeChild(an.firstChild);an.removeChild(an.firstChild)}aA.appendChild(M("mtr",al))}ar=M("mtable",aA);if(typeof av.invisible=="boolean"&&av.invisible){ar.setAttribute("columnalign","left")}an.replaceChild(ar,an.firstChild)}}}}aq=u(aq,av.input.length);if(typeof av.invisible!="boolean"||!av.invisible){ar=M("mo",g.createTextNode(av.output));an.appendChild(ar)}}return[an,aq]}function e(aj){var ai=R("mstyle");if(I!=""){ai.setAttribute("mathcolor",I)}if(t){ai.setAttribute("displaystyle","true")}if(ad!=""){ai.setAttribute("fontfamily",ad)}K=0;ai.appendChild(w(aj.replace(/^\s+/g,""),false)[0]);ai=M("math",ai);if(C){ai.setAttribute("title",aj.replace(/\s+/g," "))}if(ad!=""&&(q||ad!="serif")){var i=V("font");i.setAttribute("face",ad);i.appendChild(ai);return i}return ai}C=false;ad="";I="";(function(){for(var aj=0,ai=G.length;aj<ai;aj++){if(G[aj].codes){delete G[aj].codes}if(G[aj].func){G[aj].tag="mi"}if(G[aj].atname==="fontfamily"||G[aj].atname==="fontweight"){G[aj].atname="mathvariant"}}})();G.push({input:"gt",tag:"mo",output:">",tex:null,ttype:d},{input:"gt=",tag:"mo",output:"\u2265",tex:"geq",ttype:d},{input:"-<=",tag:"mo",output:"\u2AAF",tex:"preceq",ttype:d},{input:">-=",tag:"mo",output:"\u2AB0",tex:"succeq",ttype:d},{input:"'",tag:"mo",output:"\u2032",tex:"prime",ttype:d},{input:"arcsin",tag:"mi",output:"arcsin",tex:null,ttype:H,func:true},{input:"arccos",tag:"mi",output:"arccos",tex:null,ttype:H,func:true},{input:"arctan",tag:"mi",output:"arctan",tex:null,ttype:H,func:true},{input:"coth",tag:"mi",output:"coth",tex:null,ttype:H,func:true},{input:"sech",tag:"mi",output:"sech",tex:null,ttype:H,func:true},{input:"csch",tag:"mi",output:"csch",tex:null,ttype:H,func:true},{input:"abs",tag:"mi",output:"abs",tex:null,ttype:H,func:true},{input:"exp",tag:"mi",output:"exp",tex:null,ttype:H,func:true},{input:"tilde",tag:"mover",output:"~",tex:null,ttype:H,acc:true});ag.Augment({AM:{Init:function(){t=ag.config.displaystyle;decimal=ag.config.decimal;E();v()},Augment:function(i){for(var ai in i){if(i.hasOwnProperty(ai)){switch(ai){case"displaystyle":t=i[ai];break;case"decimal":decimal=i[ai];break;case"parseMath":e=i[ai];break;case"parseExpr":w=i[ai];break;case"parseIexpr":z=i[ai];break;case"parseSexpr":L=i[ai];break;case"removeBrackets":T=i[ai];break;case"getSymbol":n=i[ai];break;case"position":c=i[ai];break;case"removeCharsAndBlanks":u=i[ai];break;case"createMmlNode":M=i[ai];break;case"createElementMathML":R=i[ai];break;case"createElementXHTML":V=i[ai];break;case"initSymbols":v=i[ai];break;case"compareNames":comareNames=i[ai];break}this[ai]=i[ai]}}},parseMath:e,parseExpr:w,parseIexpr:z,parseSexr:L,removeBrackets:T,getSymbol:n,position:c,removeCharsAndBlanks:u,createMmlNode:M,createElementMathML:R,createElementXHTML:V,initSymbols:v,compareNames:W,createDocumentFragment:aa,document:g,define:B,symbols:G,names:U,TOKEN:{CONST:d,UNARY:H,BINARY:X,INFIX:m,LEFTBRACKET:b,RIGHTBRACKET:l,SPACE:a,UNDEROVER:P,DEFINITION:Z,LEFTRIGHT:r,TEXT:ab}}});var ae=[S,O];ae=null})(MathJax.InputJax.AsciiMath);(function(b){var a;b.Augment({sourceMenuTitle:"AsciiMath Input",prefilterHooks:MathJax.Callback.Hooks(true),postfilterHooks:MathJax.Callback.Hooks(true),Translate:function(c){var d,f=MathJax.HTML.getScript(c);var g={math:f,script:c};this.prefilterHooks.Execute(g);f=g.math;try{d=this.AM.parseMath(f)}catch(e){if(!e.asciimathError){throw e}d=this.formatError(e,f)}g.math=a(d);this.postfilterHooks.Execute(g);return g.math},formatError:function(f,e,c){var d=f.message.replace(/\n.*/,"");MathJax.Hub.signal.Post(["AsciiMath Jax - parse error",d,e,c]);return a.merror(d)},Error:function(c){throw MathJax.Hub.Insert(Error(c),{asciimathError:true})},Startup:function(){a=MathJax.ElementJax.mml;this.AM.Init()}});b.loadComplete("jax.js")})(MathJax.InputJax.AsciiMath);

(function(j,b,f,d){var e,h=b.Browser.isMSIE;var g,a,c,i;b.Register.StartupHook("MathZoom Ready",function(){i=MathJax.Extension.MathZoom});j.Augment({config:{styles:{".MathJax_MathML":{"font-style":"normal","font-weight":"normal","line-height":"normal","font-size":"100%","font-size-adjust":"none","text-indent":0,"text-align":"left","text-transform":"none","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none",direction:"ltr",border:0,padding:0,margin:0},"span.MathJax_MathML":{display:"inline"},"div.MathJax_MathML":{display:"block"},".MathJax_mmlExBox":{display:"block",overflow:"hidden",height:"1px",width:"60ex",padding:0,border:0,margin:0}}},settings:b.config.menuSettings,Config:function(){this.SUPER(arguments).Config.call(this);if(this.settings.scale){this.config.scale=this.settings.scale}if(b.config.displayAlign!=="center"){var m=b.config.displayAlign,k=b.config.displayIndent;var l={"text-align":m+"!important"};l["margin-"+m]=k+"!important";MathJax.Hub.Insert(this.config.styles,{"div.MathJax_MathML":l,"div.MathJax_MathML math":{"text-align":m},"div.MathJax_MathContainer > span":{"text-align":m+"!important"}})}if(!this.require){this.require=[]}this.require.push(MathJax.OutputJax.extensionDir+"/MathEvents.js")},Startup:function(){g=MathJax.Extension.MathEvents.Event;a=MathJax.Extension.MathEvents.Touch;c=MathJax.Extension.MathEvents.Hover;this.ContextMenu=g.ContextMenu;this.Mousedown=g.AltContextMenu;this.Mouseover=c.Mouseover;this.Mouseout=c.Mouseout;this.Mousemove=c.Mousemove;if(!h){this.EmExSpan=d.Element("span",{style:{position:"absolute","font-size-adjust":"none"}},[["div",{className:"MathJax_mmlExBox"}],["span",{className:"MathJax_MathML"}]]);e.math(e.mspace().With({width:"60ex"})).toNativeMML(this.EmExSpan.lastChild)}return f.Styles(this.config.styles)},InitializeMML:function(){this.initialized=true;if(h){try{if(!b.Browser.mpNamespace){var k=document.createElement("object");k.id="mathplayer";k.classid="clsid:32F66A20-7614-11D4-BD11-00104BD3F987";document.getElementsByTagName("head")[0].appendChild(k);document.namespaces.add("m","http://www.w3.org/1998/Math/MathML");b.Browser.mpNamespace=true}if(!b.Browser.mpImported){document.namespaces.m.doImport("#mathplayer");b.Browser.mpImported=true}}catch(l){alert("MathJax was not able to set up MathPlayer.\n\nIf MathPlayer is not installed, you need to install it first.\nOtherwise, your security settings may be preventing ActiveX     \ncontrols from running.  Use the Internet Options item under\nthe Tools menu and select the Security tab, then press the\nCustom Level button. Check that the settings for\n'Run ActiveX Controls', and 'Binary and script behaviors'\nare enabled.\n\nCurrently you will see error messages rather than\ntypeset mathematics.")}}else{document.body.appendChild(this.EmExSpan);this.defaultEx=this.EmExSpan.firstChild.offsetWidth/60;this.defaultMEx=this.EmExSpan.lastChild.offsetWidth/60;document.body.removeChild(this.EmExSpan)}},preTranslate:function(l){var r=l.jax[this.id],s,n=r.length,w,p,y,u,x,k,t,q,o;for(s=0;s<n;s++){w=r[s];if(!w.parentNode){continue}if(!this.initialized){this.InitializeMML()}p=w.previousSibling;if(p&&p.className==="MathJax_MathML"){p.parentNode.removeChild(p)}k=w.MathJax.elementJax;if(!k){continue}x=k.root;k.NativeMML={};var v=(x.Get("display")==="block"?"div":"span");y=d.Element(v,{className:"MathJax_MathML",id:k.inputID+"-Frame"},[["span",{className:"MathJax_MathContainer",isMathJax:true,jaxID:this.id,style:{position:"relative",display:"inline-block","white-space":"nowrap"}},[["span",{isMathJax:true,style:{display:"inline-block"}}]]]]);w.parentNode.insertBefore(y,w);if(!h){w.parentNode.insertBefore(this.EmExSpan.cloneNode(true),w)}}for(s=0;s<n;s++){w=r[s];if(!w.parentNode){continue}k=w.MathJax.elementJax;if(!k){continue}if(!h){u=w.previousSibling;y=u.previousSibling;t=u.firstChild.offsetWidth/60;q=u.lastChild.offsetWidth/60;if(t===0||t==="NaN"){t=this.defaultEx;q=this.defaultMEx}o=(q>1?t/q:1)*this.config.scale;o=Math.floor(Math.max(this.config.minScaleAdjust/100,o))}else{o=100}k.NativeMML.fontSize=o+"%"}if(!h){for(s=0;s<n;s++){w=r[s];if(!w.parentNode||!w.MathJax.elementJax){continue}u=r[s].previousSibling;u.parentNode.removeChild(u)}}},Translate:function(q){if(!q.parentNode){return}var k=q.MathJax.elementJax,r=k.root;var s=document.getElementById(k.inputID+"-Frame"),l=s.firstChild,o=l.firstChild;s.style.fontSize=k.NativeMML.fontSize;try{r.toNativeMML(o)}catch(p){if(p.restart){while(o.firstChild){o.removeChild(o.firstChild)}}throw p}if(h){if(l.addEventListener){for(var m in this.MSIE9events){if(this.MSIE9events.hasOwnProperty(m)){l.addEventListener(m,this.MSIE9event,true)}}}else{var n=(this.config.showMathMenuMSIE!=null?this:b).config;if(n.showMathMenuMSIE&&!this.settings.mpContext&&!this.settings.mpMouse){this.MSIEoverlay(l)}else{l.style.position="";o.firstChild.onmousedown=this.MSIEaltMenu}}}else{l.oncontextmenu=g.Menu;l.onmouseover=g.Mouseover;l.onmouseout=g.Mouseout;l.onmousedown=g.Mousedown;l.onclick=g.Click;l.ondblclick=g.DblClick;if(b.Browser.noContextMenu){l.ontouchstart=a.start;l.ontouchend=a.end}}},postTranslate:function(l){if(this.forceReflow){var k=(document.styleSheets||[])[0]||{};k.disabled=true;k.disabled=false}},Remove:function(k){var l=k.SourceElement();if(!l){return}l=l.previousSibling;if(!l){return}if(l.className.match(/MathJax_MathML/)){l.parentNode.removeChild(l)}},MMLnamespace:"http://www.w3.org/1998/Math/MathML",MSIEoverlay:function(k){var l=k.firstChild;if(l.nodeName.toLowerCase()==="span"){l=l.firstChild}var m=this.getHoverBBox(null,l,{});d.addElement(k,"span",{style:{display:"inline-block",width:0,height:0,position:"relative"}},[["span",{isMathJax:true,className:"MathJax_MathPlayer_Overlay",style:{display:"inline-block",position:"absolute",left:c.Px(-m.w),top:c.Px(-m.h-(m.y||0)-1),width:c.Px(m.w),height:c.Px(m.h+m.d),cursor:"pointer","background-color":"white",filter:"alpha(opacity=0)"}}]]);b.Insert(k,{msieMath:l,onmousedown:this.MSIEevent,oncontextmenu:this.MSIEevent,onclick:this.MSIEevent,onmouseup:this.MSIEevent,onmousemove:this.MSIEevent,ondblclick:this.MSIEevent,onmouseover:this.MSIEevent,onmouseout:this.MSIEevent})},MSIEevents:{mousedown:"Mousedown",contextmenu:"ContextMenu",click:"Click",mouseup:"Mouseup",mousemove:"Mousemove",dblclick:"DblClick",mouseover:"Mouseover",mouseout:"Mouseout"},MSIEevent:function(){var l=window.event;var k=j.MSIEevents[l.type];if(j[k]&&j[k](l,this)===false){return false}if(i&&i.HandleEvent(l,k,this)===false){return false}if(l.srcElement.className==="MathJax_MathPlayer_Overlay"&&this.msieMath.fireEvent){if(k==="ContextMenu"||k==="Mouseover"||k==="Mouseout"){this.msieMath.fireEvent("on"+l.type,l)}}return g.False(l)},MSIEaltMenu:function(){var k=this.parentNode.parentNode;while(!k.jaxID){k=k.parentNode}g.AltContextMenu(window.event,k)},MSIE9events:{contextmenu:"Menu",click:"Click",dblclick:"DblClick",mouseup:"False",mouseover:"Mouseover",mouseout:"Mouseout"},MSIE9event:function(l){if(l.type==="contextmenu"&&j.settings.mpContext){return true}if(l.type==="mouseup"&&j.settings.mpMouse){return true}if(l.type==="click"&&j.settings.mpContext){return g.AltContextMenu(l,this)}var k=j.MSIE9events[l.type];return g[k].call(this,l)},getJaxFromMath:function(k){k=k.parentNode;do{k=k.nextSibling}while(k&&k.nodeName.toLowerCase()!=="script");return b.getJaxFor(k)},getHoverSpan:function(k,l){return l.firstChild},getHoverBBox:function(k,l,m){return g.getBBox(l.parentNode)},Zoom:function(l,r,p,k,o){l.root.toNativeMML(r);if(this.msieIE8HeightBug){r.style.position="absolute"}var m=p.offsetWidth||p.scrollWidth,s=p.offsetHeight||p.scrollHeight;var q=r.offsetWidth,n=r.offsetHeight;if(this.msieIE8HeightBug){r.style.position=""}return{Y:-g.getBBox(r.parentNode).h,mW:m,mH:s,zW:q,zH:n}},NAMEDSPACE:{negativeveryverythinmathspace:"-.0556em",negativeverythinmathspace:"-.1111em",negativethinmathspace:"-.1667em",negativemediummathspace:"-.2222em",negativethickmathspace:"-.2778em",negativeverythickmathspace:"-.3333em",negativeveryverythickmathspace:"-.3889em"}});b.Register.StartupHook("mml Jax Ready",function(){e=MathJax.ElementJax.mml;e.mbase.Augment({toNativeMML:function(p){var n=this.NativeMMLelement(this.type);this.NativeMMLattributes(n);for(var o=0,l=this.data.length;o<l;o++){if(this.data[o]){this.data[o].toNativeMML(n)}else{n.appendChild(this.NativeMMLelement("mrow"))}}p.appendChild(n)},NativeMMLattributes:function(n){var r=this.defaults;var t=(this.attrNames||e.copyAttributeNames),p=e.skipAttributes;if(!this.attrNames){if(this.type==="mstyle"){r=e.math.prototype.defaults}for(var s in r){if(!p[s]&&r.hasOwnProperty(s)){if(this[s]!=null){n.setAttribute(s,this.NativeMMLattribute(this[s]))}}}}for(var o=0,l=t.length;o<l;o++){var q=(this.attr||{})[t[o]];if(q==null){q=this[t[o]]}if(q!=null){n.setAttribute(t[o],this.NativeMMLattribute(q))}}this.NativeMMLclass(n)},NativeMMLclass:function(l){var n=[];if(this["class"]){n.push(this["class"])}if(this.isa(e.TeXAtom)){var m=["ORD","OP","BIN","REL","OPEN","CLOSE","PUNCT","INNER","VCENTER"][this.texClass];if(m){n.push("MJX-TeXAtom-"+m)}}if(this.mathvariant&&this.NativeMMLvariants[this.mathvariant]){n.push("MJX"+this.mathvariant)}if(this.arrow){n.push("MJX-arrow")}if(this.variantForm){n.push("MJX-variant")}if(n.length){l.setAttribute("class",n.join(" "))}},NativeMMLattribute:function(l){l=String(l);if(j.NAMEDSPACE[l]){l=j.NAMEDSPACE[l]}else{if(l.match(/^\s*(([-+])?(\d+(\.\d*)?|\.\d+))\s*mu\s*$/)){l=RegExp.$2+((1/18)*RegExp.$3).toFixed(3).replace(/\.?0+$/,"")+"em"}else{if(this.NativeMMLvariants[l]){l=this.NativeMMLvariants[l]}}}return l},NativeMMLvariants:{"-tex-caligraphic":e.VARIANT.SCRIPT,"-tex-caligraphic-bold":e.VARIANT.BOLDSCRIPT,"-tex-oldstyle":e.VARIANT.NORMAL,"-tex-oldstyle-bold":e.VARIANT.BOLD,"-tex-mathit":e.VARIANT.ITALIC},NativeMMLelement:function(l){var m=(h?document.createElement("m:"+l):document.createElementNS(j.MMLnamespace,l));m.isMathJax=true;return m}});e.mrow.Augment({toNativeMML:function(o){if(this.inferred&&this.parent.inferRow){for(var n=0,l=this.data.length;n<l;n++){if(this.data[n]){this.data[n].toNativeMML(o)}else{o.appendChild(this.NativeMMLelement("mrow"))}}}else{this.SUPER(arguments).toNativeMML.call(this,o)}}});e.msubsup.Augment({toNativeMML:function(q){var p=this.type;if(this.data[this.sup]==null){p="msub"}if(this.data[this.sub]==null){p="msup"}var n=this.NativeMMLelement(p);this.NativeMMLattributes(n);delete this.data[0].inferred;for(var o=0,l=this.data.length;o<l;o++){if(this.data[o]){this.data[o].toNativeMML(n)}}q.appendChild(n)}});e.munderover.Augment({toNativeMML:function(q){var p=this.type;if(this.data[this.under]==null){p="mover"}if(this.data[this.over]==null){p="munder"}var n=this.NativeMMLelement(p);this.NativeMMLattributes(n);delete this.data[0].inferred;for(var o=0,l=this.data.length;o<l;o++){if(this.data[o]){this.data[o].toNativeMML(n)}}q.appendChild(n)}});if(b.Browser.isFirefox){if(!b.Browser.versionAtLeast("13.0")){e.mtable.Augment({toNativeMML:function(l){if(this.width){var m=(this.style||"").replace(/;\s*$/,"").split(";");if(m[0]===""){m.shift()}m.push("width:"+this.width);this.style=m.join(";")}this.SUPER(arguments).toNativeMML.call(this,l)}})}if(!b.Browser.versionAtLeast("9.0")){e.mlabeledtr.Augment({toNativeMML:function(p){var n=this.NativeMMLelement("mtr");this.NativeMMLattributes(n);for(var o=1,l=this.data.length;o<l;o++){if(this.data[o]){this.data[o].toNativeMML(n)}else{n.appendChild(this.NativeMMLelement("mrow"))}}p.appendChild(n)}})}var k=MathJax.Ajax.fileURL(MathJax.OutputJax.fontDir+"/HTML-CSS/TeX/otf");j.Augment({config:{styles:{'[mathvariant="double-struck"]':{"font-family":"MathJax_AMS, MathJax_AMS-WEB"},'[mathvariant="script"]':{"font-family":"MathJax_Script, MathJax_Script-WEB"},'[mathvariant="fraktur"]':{"font-family":"MathJax_Fraktur, MathJax_Fraktur-WEB"},'[mathvariant="bold-script"]':{"font-family":"MathJax_Script, MathJax_Caligraphic-WEB","font-weight":"bold"},'[mathvariant="bold-fraktur"]':{"font-family":"MathJax_Fraktur, MathJax_Fraktur-WEB","font-weight":"bold"},'[mathvariant="monospace"]':{"font-family":"monospace"},'[mathvariant="sans-serif"]':{"font-family":"sans-serif"},'[mathvariant="bold-sans-serif"]':{"font-family":"sans-serif","font-weight":"bold"},'[mathvariant="sans-serif-italic"]':{"font-family":"sans-serif","font-style":"italic"},'[mathvariant="sans-serif-bold-italic"]':{"font-family":"sans-serif","font-style":"italic","font-weight":"bold"},'[class="MJX-tex-oldstyle"]':{"font-family":"MathJax_Caligraphic, MathJax_Caligraphic-WEB"},'[class="MJX-tex-oldstyle-bold"]':{"font-family":"MathJax_Caligraphic, MathJax_Caligraphic-WEB","font-weight":"bold"},'[class="MJX-tex-caligraphic"]':{"font-family":"MathJax_Caligraphic, MathJax_Caligraphic-WEB"},'[class="MJX-tex-caligraphic-bold"]':{"font-family":"MathJax_Caligraphic, MathJax_Caligraphic-WEB","font-weight":"bold"},"@font-face /*1*/":{"font-family":"MathJax_AMS-WEB",src:"url('"+k+"/MathJax_AMS-Regular.otf')"},"@font-face /*2*/":{"font-family":"MathJax_Script-WEB",src:"url('"+k+"/MathJax_Script-Regular.otf')"},"@font-face /*3*/":{"font-family":"MathJax_Fraktur-WEB",src:"url('"+k+"/MathJax_Fraktur-Regular.otf')"},"@font-face /*4*/":{"font-family":"MathJax_Caligraphic-WEB",src:"url('"+k+"/MathJax_Caligraphic-Regular.otf')"},"@font-face /*5*/":{"font-family":"MathJax_Fraktur-WEB","font-weight":"bold",src:"url('"+k+"/MathJax_Fraktur-Bold.otf')"},"@font-face /*6*/":{"font-family":"MathJax_Caligraphic-WEB","font-weight":"bold",src:"url('"+k+"/MathJax_Caligraphic-Bold.otf')"}}}})}e.math.Augment({toNativeMML:function(p){var n=this.NativeMMLelement(this.type),q=n;n.setAttribute("xmlns",j.MMLnamespace);this.NativeMMLattributes(n);if(j.widthBug){n=n.appendChild(this.NativeMMLelement("mrow"))}for(var o=0,l=this.data.length;o<l;o++){if(this.data[o]){this.data[o].toNativeMML(n)}else{n.appendChild(this.NativeMMLelement("mrow"))}}p.appendChild(q);if(j.widthBug){p.style.width=q.firstChild.scrollWidth+"px"}}});e.TeXAtom.Augment({toNativeMML:function(m){var l=this.NativeMMLelement("mrow");this.NativeMMLattributes(l);this.data[0].toNativeMML(l);m.appendChild(l)}});e.chars.Augment({toNativeMML:function(l){l.appendChild(document.createTextNode(this.toString()))}});e.entity.Augment({toNativeMML:function(l){l.appendChild(document.createTextNode(this.toString()))}});e.xml.Augment({toNativeMML:function(o){for(var n=0,l=this.data.length;n<l;n++){o.appendChild(this.data[n].cloneNode(true))}}});b.Register.StartupHook("TeX mathchoice Ready",function(){e.TeXmathchoice.Augment({toNativeMML:function(l){this.Core().toNativeMML(l)}})});setTimeout(MathJax.Callback(["loadComplete",j,"jax.js"]),0)});b.Browser.Select({MSIE:function(k){var l=(document.documentMode||0);j.msieIE8HeightBug=(l===8)},Opera:function(k){j.operaPositionBug=true},Firefox:function(k){j.forceReflow=true;j.widthBug=true}});b.Register.StartupHook("End Cookie",function(){if(b.config.menuSettings.zoom!=="None"){f.Require("[MathJax]/extensions/MathZoom.js")}})})(MathJax.OutputJax.NativeMML,MathJax.Hub,MathJax.Ajax,MathJax.HTML);

(function(g,b,d){var f,h=b.Browser.isMobile;var e=MathJax.Object.Subclass({timeout:(h?15:8)*1000,FontInfo:{STIX:{family:"STIXSizeOneSym",testString:"() {} []"},TeX:{family:"MathJax_Size1",testString:"() {} []"}},comparisonFont:["sans-serif","monospace","script","Times","Courier","Arial","Helvetica"],testSize:["40px","50px","60px","30px","20px"],Init:function(){this.div=MathJax.HTML.addElement(document.body,"div",{id:"MathJax_Font_Test",style:{position:"absolute",visibility:"hidden",top:0,left:0,width:"auto",padding:0,border:0,margin:0,whiteSpace:"nowrap",textAlign:"left",textIndent:0,textTransform:"none",lineHeight:"normal",letterSpacing:"normal",wordSpacing:"normal",fontSize:this.testSize[0],fontWeight:"normal",fontStyle:"normal",fontSizeAdjust:"none"}},[""]);this.text=this.div.firstChild},findFont:function(n,k){if(k&&this.testCollection(k)){return k}for(var l=0,j=n.length;l<j;l++){if(n[l]===k){continue}if(this.testCollection(n[l])){return n[l]}}return null},testCollection:function(j){return this.testFont(this.FontInfo[j])},testFont:function(l){if(l.isWebFont&&d.FontFaceBug){this.div.style.fontWeight=this.div.style.fontStyle="normal"}else{this.div.style.fontWeight=(l.weight||"normal");this.div.style.fontStyle=(l.style||"normal")}var k=this.getComparisonWidths(l.testString,l.noStyleChar);if(k){this.div.style.fontFamily="'"+l.family+"',"+this.comparisonFont[0];if(this.div.offsetWidth==k[0]){this.div.style.fontFamily="'"+l.family+"',"+this.comparisonFont[k[2]];if(this.div.offsetWidth==k[1]){return false}}if(this.div.offsetWidth!=k[3]||this.div.offsetHeight!=k[4]){if(l.noStyleChar||!d.FONTDATA||!d.FONTDATA.hasStyleChar){return true}for(var n=0,j=this.testSize.length;n<j;n++){if(this.testStyleChar(l,this.testSize[n])){return true}}}}return false},styleChar:"\uEFFD",versionChar:"\uEFFE",compChar:"\uEFFF",testStyleChar:function(l,o){var r=3+(l.weight?2:0)+(l.style?4:0);var k="",m=0;var q=this.div.style.fontSize;this.div.style.fontSize=o;if(d.msieItalicWidthBug&&l.style==="italic"){this.text.nodeValue=k=this.compChar;m=this.div.offsetWidth}if(d.safariTextNodeBug){this.div.innerHTML=this.compChar+k}else{this.text.nodeValue=this.compChar+k}var j=this.div.offsetWidth-m;if(d.safariTextNodeBug){this.div.innerHTML=this.styleChar+k}else{this.text.nodeValue=this.styleChar+k}var p=Math.floor((this.div.offsetWidth-m)/j+0.5);if(p===r){if(d.safariTextNodeBug){this.div.innerHTML=this.versionChar+k}else{this.text.nodeValue=this.versionChar+k}l.version=Math.floor((this.div.offsetWidth-m)/j+1.5)/2}this.div.style.fontSize=q;return(p===r)},getComparisonWidths:function(o,l){if(d.FONTDATA&&d.FONTDATA.hasStyleChar&&!l){o+=this.styleChar+" "+this.compChar}if(d.safariTextNodeBug){this.div.innerHTML=o}else{this.text.nodeValue=o}this.div.style.fontFamily=this.comparisonFont[0];var k=this.div.offsetWidth;this.div.style.fontFamily=d.webFontDefault;var q=this.div.offsetWidth,n=this.div.offsetHeight;for(var p=1,j=this.comparisonFont.length;p<j;p++){this.div.style.fontFamily=this.comparisonFont[p];if(this.div.offsetWidth!=k){return[k,this.div.offsetWidth,p,q,n]}}return null},loadWebFont:function(k){b.Startup.signal.Post("HTML-CSS Jax - Web-Font "+d.fontInUse+"/"+k.directory);var m=MathJax.Message.File("Web-Font "+d.fontInUse+"/"+k.directory);var j=MathJax.Callback({});var l=MathJax.Callback(["loadComplete",this,k,m,j]);g.timer.start(g,[this.checkWebFont,k,l],0,this.timeout);return j},loadComplete:function(l,o,k,j){MathJax.Message.Clear(o);if(j===g.STATUS.OK){this.webFontLoaded=true;k();return}this.loadError(l);if(b.Browser.isFirefox&&d.allowWebFonts){var m=document.location.protocol+"//"+document.location.hostname;if(document.location.port!=""){m+=":"+document.location.port}m+="/";if(g.fileURL(d.webfontDir).substr(0,m.length)!==m){this.firefoxFontError(l)}}if(!this.webFontLoaded){d.loadWebFontError(l,k)}else{k()}},loadError:function(j){MathJax.Message.Set("Can't load web font "+d.fontInUse+"/"+j.directory,null,2000);b.Startup.signal.Post(["HTML-CSS Jax - web font error",d.fontInUse+"/"+j.directory,j])},firefoxFontError:function(j){MathJax.Message.Set("Firefox can't load web fonts from a remote host",null,3000);b.Startup.signal.Post("HTML-CSS Jax - Firefox web fonts on remote host error")},checkWebFont:function(j,k,l){if(j.time(l)){return}if(d.Font.testFont(k)){l(j.STATUS.OK)}else{setTimeout(j,j.delay)}},fontFace:function(l){var m=d.allowWebFonts;var o=d.FONTDATA.FONTS[l];if(d.msieFontCSSBug&&!o.family.match(/-Web$/)){o.family+="-Web"}var k=g.fileURL(d.webfontDir+"/"+m);var j=l.replace(/-b/,"-B").replace(/-i/,"-I").replace(/-Bold-/,"-Bold");if(!j.match(/-/)){j+="-Regular"}if(m==="svg"){j+=".svg#"+j}else{j+="."+m}var n={"font-family":o.family,src:"url('"+k+"/"+j+"')"};if(m==="otf"){n.src+=" format('opentype')";k=g.fileURL(d.webfontDir+"/woff");n.src="url('"+k+"/"+j.replace(/otf$/,"woff")+"') format('woff'), "+n.src}else{if(m!=="eot"){n.src+=" format('"+m+"')"}}if(!(d.FontFaceBug&&o.isWebFont)){if(l.match(/-bold/)){n["font-weight"]="bold"}if(l.match(/-italic/)){n["font-style"]="italic"}}return n}});var i,a,c;d.Augment({config:{styles:{".MathJax":{display:"inline","font-style":"normal","font-weight":"normal","line-height":"normal","font-size":"100%","font-size-adjust":"none","text-indent":0,"text-align":"left","text-transform":"none","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none",direction:"ltr",border:0,padding:0,margin:0},".MathJax_Display":{position:"relative",display:"block",width:"100%"},".MathJax img, .MathJax nobr, .MathJax a":{border:0,padding:0,margin:0,"max-width":"none","max-height":"none","vertical-align":0,"line-height":"normal","text-decoration":"none"},"img.MathJax_strut":{border:"0 !important",padding:"0 !important",margin:"0 !important","vertical-align":"0 !important"},".MathJax span":{display:"inline",position:"static",border:0,padding:0,margin:0,"vertical-align":0,"line-height":"normal","text-decoration":"none"},".MathJax nobr":{"white-space":"nowrap ! important"},".MathJax img":{display:"inline ! important","float":"none ! important"},".MathJax_Processing":{visibility:"hidden",position:"fixed",width:0,height:0,overflow:"hidden"},".MathJax_Processed":{display:"none!important"},".MathJax_ExBox":{display:"block",overflow:"hidden",width:"1px",height:"60ex"},".MathJax .MathJax_EmBox":{display:"block",overflow:"hidden",width:"1px",height:"60em"},".MathJax .MathJax_HitBox":{cursor:"text",background:"white",opacity:0,filter:"alpha(opacity=0)"},".MathJax .MathJax_HitBox *":{filter:"none",opacity:1,background:"transparent"},"#MathJax_Tooltip":{position:"absolute",left:0,top:0,width:"auto",height:"auto",display:"none"},"#MathJax_Tooltip *":{filter:"none",opacity:1,background:"transparent"},"@font-face":{"font-family":"MathJax_Blank",src:"url('about:blank')"}}},settings:b.config.menuSettings,hideProcessedMath:true,Font:null,webFontDefault:"MathJax_Blank",allowWebFonts:"otf",Config:function(){if(!this.require){this.require=[]}this.Font=e();this.SUPER(arguments).Config.call(this);var k=this.settings;if(this.adjustAvailableFonts){this.adjustAvailableFonts(this.config.availableFonts)}if(k.scale){this.config.scale=k.scale}if(k.font&&k.font!=="Auto"){if(k.font==="TeX (local)"){this.config.availableFonts=["TeX"];this.config.preferredFont="TeX";this.config.webFont="TeX"}else{if(k.font==="STIX (local)"){this.config.availableFonts=["STIX"];this.config.preferredFont="STIX";this.config.webFont="TeX"}else{if(k.font==="TeX (web)"){this.config.availableFonts=[];this.config.preferredFont="";this.config.webFont="TeX"}else{if(k.font==="TeX (image)"){this.config.availableFonts=[];this.config.preferredFont="";this.config.webFont=""}}}}}var j=this.Font.findFont(this.config.availableFonts,this.config.preferredFont);if(!j&&this.allowWebFonts){j=this.config.webFont;if(j){this.webFonts=true}}if(!j&&this.config.imageFont){j=this.config.imageFont;this.imgFonts=true}if(j){this.fontInUse=j;this.fontDir+="/"+j;this.webfontDir+="/"+j;this.require.push(this.fontDir+"/fontdata.js");if(this.imgFonts){this.require.push(this.directory+"/imageFonts.js");b.Startup.signal.Post("HTML-CSS Jax - using image fonts")}}else{MathJax.Message.Set("Can't find a valid font using ["+this.config.availableFonts.join(", ")+"]",null,3000);this.FONTDATA={TeX_factor:1,baselineskip:1.2,lineH:0.8,lineD:0.2,ffLineH:0.8,FONTS:{},VARIANT:{normal:{fonts:[]}},RANGES:[],DELIMITERS:{},RULECHAR:45,REMAP:{}};if(MathJax.InputJax.TeX&&MathJax.InputJax.TeX.Definitions){MathJax.InputJax.TeX.Definitions.macros.overline[1]="002D";MathJax.InputJax.TeX.Definitions.macros.underline[1]="002D"}b.Startup.signal.Post("HTML-CSS Jax - no valid font")}this.require.push(MathJax.OutputJax.extensionDir+"/MathEvents.js")},Startup:function(){i=MathJax.Extension.MathEvents.Event;a=MathJax.Extension.MathEvents.Touch;c=MathJax.Extension.MathEvents.Hover;this.ContextMenu=i.ContextMenu;this.Mousedown=i.AltContextMenu;this.Mouseover=c.Mouseover;this.Mouseout=c.Mouseout;this.Mousemove=c.Mousemove;this.hiddenDiv=this.Element("div",{style:{visibility:"hidden",overflow:"hidden",position:"absolute",top:0,height:"1px",width:"auto",padding:0,border:0,margin:0,textAlign:"left",textIndent:0,textTransform:"none",lineHeight:"normal",letterSpacing:"normal",wordSpacing:"normal"}});if(!document.body.firstChild){document.body.appendChild(this.hiddenDiv)}else{document.body.insertBefore(this.hiddenDiv,document.body.firstChild)}this.hiddenDiv=this.addElement(this.hiddenDiv,"div",{id:"MathJax_Hidden"});var k=this.addElement(this.hiddenDiv,"div",{style:{width:"5in"}});this.pxPerInch=k.offsetWidth/5;this.hiddenDiv.removeChild(k);this.startMarker=this.createStrut(this.Element("span"),10,true);this.endMarker=this.addText(this.Element("span"),"x").parentNode;this.HDspan=this.Element("span");if(this.operaHeightBug){this.createStrut(this.HDspan,0)}if(this.msieInlineBlockAlignBug){this.HDimg=this.addElement(this.HDspan,"img",{style:{height:"0px",width:"1px"}});try{this.HDimg.src="about:blank"}catch(j){}}else{this.HDimg=this.createStrut(this.HDspan,0)}this.EmExSpan=this.Element("span",{style:{position:"absolute","font-size-adjust":"none"}},[["span",{className:"MathJax_ExBox"}],["span",{className:"MathJax"},[["span",{className:"MathJax_EmBox"}]]]]);this.linebreakSpan=this.Element("span",null,[["hr",{style:{width:"100%",size:1,padding:0,border:0,margin:0}}]]);return g.Styles(this.config.styles,["InitializeHTML",this])},removeSTIXfonts:function(l){for(var k=0,j=l.length;k<j;k++){if(l[k]==="STIX"){l.splice(k,1);j--;k--}}if(this.config.preferredFont==="STIX"){this.config.preferredFont=l[0]}},PreloadWebFonts:function(){if(!d.allowWebFonts||!d.config.preloadWebFonts){return}for(var k=0,j=d.config.preloadWebFonts.length;k<j;k++){var l=d.FONTDATA.FONTS[d.config.preloadWebFonts[k]];if(!l.available){d.Font.testFont(l)}}},InitializeHTML:function(){this.PreloadWebFonts();document.body.appendChild(this.EmExSpan);document.body.appendChild(this.linebreakSpan);this.defaultEx=this.EmExSpan.firstChild.offsetHeight/60;this.defaultEm=this.EmExSpan.lastChild.firstChild.offsetHeight/60;this.defaultWidth=this.linebreakSpan.firstChild.offsetWidth;document.body.removeChild(this.linebreakSpan);document.body.removeChild(this.EmExSpan)},preTranslate:function(n){var t=n.jax[this.id],u,q=t.length,y,s,z,l,x,k,w,p,r,j,v=false,A=this.config.linebreaks.automatic,o=this.config.linebreaks.width;if(A){v=(o.match(/^\s*(\d+(\.\d*)?%\s*)?container\s*$/)!=null);if(v){o=o.replace(/\s*container\s*/,"")}else{j=this.defaultWidth}if(o===""){o="100%"}}else{j=100000}for(u=0;u<q;u++){y=t[u];if(!y.parentNode){continue}s=y.previousSibling;if(s&&String(s.className).match(/^MathJax(_Display)?( MathJax_Processing)?$/)){s.parentNode.removeChild(s)}k=y.MathJax.elementJax;if(!k){continue}k.HTMLCSS={display:(k.root.Get("display")==="block")};z=l=this.Element("span",{className:"MathJax",id:k.inputID+"-Frame",isMathJax:true,jaxID:this.id,oncontextmenu:i.Menu,onmousedown:i.Mousedown,onmouseover:i.Mouseover,onmouseout:i.Mouseout,onmousemove:i.Mousemove,onclick:i.Click,ondblclick:i.DblClick});if(b.Browser.noContextMenu){z.ontouchstart=a.start;z.ontouchend=a.end}if(k.HTMLCSS.display){l=this.Element("div",{className:"MathJax_Display"});l.appendChild(z)}else{if(this.msieDisappearingBug){z.style.display="inline-block"}}l.setAttribute("role","textbox");l.setAttribute("aria-readonly","true");l.className+=" MathJax_Processing";y.parentNode.insertBefore(l,y);y.parentNode.insertBefore(this.EmExSpan.cloneNode(true),y);if(v){l.parentNode.insertBefore(this.linebreakSpan.cloneNode(true),l)}}for(u=0;u<q;u++){y=t[u];if(!y.parentNode){continue}x=y.previousSibling;l=x.previousSibling;k=y.MathJax.elementJax;if(!k){continue}w=x.firstChild.offsetHeight/60;p=x.lastChild.firstChild.offsetHeight/60;if(v){j=l.previousSibling.firstChild.offsetWidth}if(w===0||w==="NaN"){this.hiddenDiv.appendChild(l);k.HTMLCSS.isHidden=true;w=this.defaultEx;p=this.defaultEm;if(v){j=this.defaultWidth}}r=Math.floor(Math.max(this.config.minScaleAdjust/100,(w/this.TeX.x_height)/p)*this.config.scale);k.HTMLCSS.scale=r/100;k.HTMLCSS.fontSize=r+"%";k.HTMLCSS.em=k.HTMLCSS.outerEm=p;this.em=p*r/100;k.HTMLCSS.ex=w;k.HTMLCSS.lineWidth=(A?this.length2em(o,1,j/this.em):1000000)}for(u=0;u<q;u++){y=t[u];if(!y.parentNode){continue}x=t[u].previousSibling;k=t[u].MathJax.elementJax;if(!k){continue}if(v){z=x.previousSibling;if(!k.HTMLCSS.isHidden){z=z.previousSibling}z.parentNode.removeChild(z)}x.parentNode.removeChild(x)}n.HTMLCSSeqn=n.HTMLCSSlast=0;n.HTMLCSSi=-1;n.HTMLCSSchunk=this.config.EqnChunk;n.HTMLCSSdelay=false},Translate:function(k,o){if(!k.parentNode){return}if(o.HTMLCSSdelay){o.HTMLCSSdelay=false;b.RestartAfter(MathJax.Callback.Delay(this.config.EqnChunkDelay))}var j=k.MathJax.elementJax,n=j.root,l=document.getElementById(j.inputID+"-Frame"),p=(j.HTMLCSS.display?l.parentNode:l);this.em=f.mbase.prototype.em=j.HTMLCSS.em*j.HTMLCSS.scale;this.outerEm=j.HTMLCSS.em;this.scale=j.HTMLCSS.scale;this.linebreakWidth=j.HTMLCSS.lineWidth;l.style.fontSize=j.HTMLCSS.fontSize;this.initImg(l);this.initHTML(n,l);n.setTeXclass();try{n.toHTML(l,p)}catch(m){if(m.restart){while(l.firstChild){l.removeChild(l.firstChild)}}throw m}if(j.HTMLCSS.isHidden){k.parentNode.insertBefore(p,k)}p.className=p.className.split(/ /)[0];if(this.hideProcessedMath){p.className+=" MathJax_Processed";if(k.MathJax.preview){j.HTMLCSS.preview=k.MathJax.preview;delete k.MathJax.preview}o.HTMLCSSeqn+=(o.i-o.HTMLCSSi);o.HTMLCSSi=o.i;if(o.HTMLCSSeqn>=o.HTMLCSSlast+o.HTMLCSSchunk){this.postTranslate(o);o.HTMLCSSchunk=Math.floor(o.HTMLCSSchunk*this.config.EqnChunkFactor);o.HTMLCSSdelay=true}}},postTranslate:function(q){var k=q.jax[this.id];if(!this.hideProcessedMath){return}for(var o=q.HTMLCSSlast,j=q.HTMLCSSeqn;o<j;o++){var l=k[o];if(l&&l.MathJax.elementJax){l.previousSibling.className=l.previousSibling.className.split(/ /)[0];var p=l.MathJax.elementJax.HTMLCSS;if(p.preview){p.preview.innerHTML="";l.MathJax.preview=p.preview;delete p.preview}}}if(this.forceReflow){var n=(document.styleSheets||[])[0]||{};n.disabled=true;n.disabled=false}q.HTMLCSSlast=q.HTMLCSSeqn},getJaxFromMath:function(j){if(j.parentNode.className==="MathJax_Display"){j=j.parentNode}do{j=j.nextSibling}while(j&&j.nodeName.toLowerCase()!=="script");return b.getJaxFor(j)},getHoverSpan:function(j,k){return j.root.HTMLspanElement()},getHoverBBox:function(j,m,n){var o=m.bbox,l=j.HTMLCSS.outerEm;var k={w:o.w*l,h:o.h*l,d:o.d*l};if(o.width){k.width=o.width}return k},Zoom:function(k,u,t,j,r){u.className="MathJax";u.style.fontSize=k.HTMLCSS.fontSize;var w=u.appendChild(this.EmExSpan.cloneNode(true));var n=w.lastChild.firstChild.offsetHeight/60;this.em=f.mbase.prototype.em=n;this.outerEm=n/k.HTMLCSS.scale;w.parentNode.removeChild(w);this.idPostfix="-zoom";k.root.toHTML(u,u);this.idPostfix="";var m=k.root.HTMLspanElement().bbox.width;if(m){u.style.width=Math.floor(j-1.5*d.em)+"px";u.style.display="inline-block";var l=(k.root.id||"MathJax-Span-"+k.root.spanID)+"-zoom";var o=document.getElementById(l).firstChild;while(o&&o.style.width!==m){o=o.nextSibling}if(o){o.style.width="100%"}}u.style.position=t.style.position="absolute";var s=u.offsetWidth,q=u.offsetHeight,v=t.offsetHeight,p=t.offsetWidth;if(p===0){p=t.parentNode.offsetWidth}u.style.position=t.style.position="";return{Y:-i.getBBox(u).h,mW:p,mH:v,zW:s,zH:q}},initImg:function(j){},initHTML:function(k,j){},initFont:function(j){var l=d.FONTDATA.FONTS,k=d.config.availableFonts;if(k&&k.length&&d.Font.testFont(l[j])){l[j].available=true;return null}if(!this.allowWebFonts){return null}l[j].isWebFont=true;if(d.FontFaceBug){l[j].family=j;if(d.msieFontCSSBug){l[j].family+="-Web"}}return g.Styles({"@font-face":this.Font.fontFace(j)})},Remove:function(j){var k=document.getElementById(j.inputID+"-Frame");if(k){if(j.HTMLCSS.display){k=k.parentNode}k.parentNode.removeChild(k)}delete j.HTMLCSS},getHD:function(k){var j=k.style.position;k.style.position="absolute";this.HDimg.style.height="0px";k.appendChild(this.HDspan);var l={h:k.offsetHeight};this.HDimg.style.height=l.h+"px";l.d=k.offsetHeight-l.h;l.h-=l.d;l.h/=this.em;l.d/=this.em;k.removeChild(this.HDspan);k.style.position=j;return l},getW:function(n){var k,m,l=(n.bbox||{}).w,o=n;if(n.bbox&&n.bbox.exactW){return l}if((n.bbox&&l>=0&&!this.initialSkipBug)||this.negativeBBoxes||!n.firstChild){k=n.offsetWidth;m=n.parentNode.offsetHeight}else{if(n.bbox&&l<0&&this.msieNegativeBBoxBug){k=-n.offsetWidth,m=n.parentNode.offsetHeight}else{if(this.initialSkipBug){var j=n.style.position;n.style.position="absolute";o=this.startMarker;n.insertBefore(o,n.firstChild)}n.appendChild(this.endMarker);k=this.endMarker.offsetLeft-o.offsetLeft;n.removeChild(this.endMarker);if(this.initialSkipBug){n.removeChild(o);n.style.position=j}}}if(m!=null){n.parentNode.HH=m/this.em}return k/this.em},Measured:function(l,k){var m=l.bbox;if(m.width==null&&m.w&&!m.isMultiline){var j=this.getW(l);m.rw+=j-m.w;m.w=j;m.exactW=true}if(!k){k=l.parentNode}if(!k.bbox){k.bbox=m}return l},Remeasured:function(k,j){j.bbox=this.Measured(k,j).bbox},MeasureSpans:function(n){var q=[],s,p,l,t,j,o,k;for(p=0,l=n.length;p<l;p++){s=n[p];if(!s){continue}t=s.bbox;if(t.exactW||t.width||t.w===0||t.isMultiline){if(!s.parentNode.bbox){s.parentNode.bbox=t}continue}if(this.negativeBBoxes||!s.firstChild||(t.w>=0&&!this.initialSkipBug)||(t.w<0&&this.msieNegativeBBoxBug)){q.push([s])}else{if(this.initialSkipBug){j=this.startMarker.cloneNode(true);o=this.endMarker.cloneNode(true);s.insertBefore(j,s.firstChild);s.appendChild(o);q.push([s,j,o,s.style.position]);s.style.position="absolute"}else{o=this.endMarker.cloneNode(true);s.appendChild(o);q.push([s,null,o])}}}for(p=0,l=q.length;p<l;p++){s=q[p][0];t=s.bbox;var r=s.parentNode;if((t.w>=0&&!this.initialSkipBug)||this.negativeBBoxes||!s.firstChild){k=s.offsetWidth;r.HH=s.parentNode.offsetHeight/this.em}else{if(t.w<0&&this.msieNegativeBBoxBug){k=-s.offsetWidth,r.HH=s.parentNode.offsetHeight/this.em}else{k=q[p][2].offsetLeft-((q[p][1]||{}).offsetLeft||0)}}k/=this.em;t.rw+=k-t.w;t.w=k;t.exactW=true;if(!r.bbox){r.bbox=t}}for(p=0,l=q.length;p<l;p++){s=q[p];if(s[1]){s[1].parentNode.removeChild(s[1]),s[0].style.position=s[3]}if(s[2]){s[2].parentNode.removeChild(s[2])}}},Em:function(j){if(Math.abs(j)<0.0006){return"0em"}return j.toFixed(3).replace(/\.?0+$/,"")+"em"},unEm:function(j){return parseFloat(j)},Px:function(j){j*=this.em;var k=(j<0?"-":"");return k+Math.abs(j).toFixed(1).replace(/\.?0+$/,"")+"px"},unPx:function(j){return parseFloat(j)/this.em},Percent:function(j){return(100*j).toFixed(1).replace(/\.?0+$/,"")+"%"},length2em:function(q,k,o){if(typeof(q)!=="string"){q=q.toString()}if(q===""){return""}if(q===f.SIZE.NORMAL){return 1}if(q===f.SIZE.BIG){return 2}if(q===f.SIZE.SMALL){return 0.71}if(q==="infinity"){return d.BIGDIMEN}var n=this.FONTDATA.TeX_factor;if(q.match(/mathspace$/)){return d.MATHSPACE[q]*n}var l=q.match(/^\s*([-+]?(?:\.\d+|\d+(?:\.\d*)?))?(pt|em|ex|mu|px|pc|in|mm|cm|%)?/);var j=parseFloat(l[1]||"1"),p=l[2];if(o==null){o=1}if(k==null){k=1}if(p==="em"){return j*n}if(p==="ex"){return j*d.TeX.x_height*n}if(p==="%"){return j/100*o}if(p==="px"){return j/d.em}if(p==="pt"){return j/10*n}if(p==="pc"){return j*1.2*n}if(p==="in"){return j*this.pxPerInch/d.em}if(p==="cm"){return j*this.pxPerInch/d.em/2.54}if(p==="mm"){return j*this.pxPerInch/d.em/25.4}if(p==="mu"){return j/18*n*k}return j*n*o},thickness2em:function(k,j){var l=d.TeX.rule_thickness;if(k===f.LINETHICKNESS.MEDIUM){return l}if(k===f.LINETHICKNESS.THIN){return 0.67*l}if(k===f.LINETHICKNESS.THICK){return 1.67*l}return this.length2em(k,j,l)},getPadding:function(k){var m={top:0,right:0,bottom:0,left:0},j=false;for(var n in m){if(m.hasOwnProperty(n)){var l=k.style["padding"+n.charAt(0).toUpperCase()+n.substr(1)];if(l){m[n]=this.length2em(l);j=true}}}return(j?m:false)},getBorders:function(o){var l={top:0,right:0,bottom:0,left:0},m={},k=false;for(var p in l){if(l.hasOwnProperty(p)){var j="border"+p.charAt(0).toUpperCase()+p.substr(1);var n=o.style[j+"Style"];if(n){k=true;l[p]=this.length2em(o.style[j+"Width"]);m[j]=[o.style[j+"Width"],o.style[j+"Style"],o.style[j+"Color"]].join(" ")}}}l.css=m;return(k?l:false)},setBorders:function(j,k){if(k){for(var l in k.css){if(k.css.hasOwnProperty(l)){j.style[l]=k.css[l]}}}},createStrut:function(l,k,m){var j=this.Element("span",{isMathJax:true,style:{display:"inline-block",overflow:"hidden",height:k+"px",width:"1px",marginRight:"-1px"}});if(m){l.insertBefore(j,l.firstChild)}else{l.appendChild(j)}return j},createBlank:function(k,j,l){var m=this.Element("span",{isMathJax:true,style:{display:"inline-block",overflow:"hidden",height:"1px",width:this.Em(j)}});if(l){k.insertBefore(m,k.firstChild)}else{k.appendChild(m)}return m},createShift:function(k,j,m){var l=this.Element("span",{style:{marginLeft:this.Em(j)},isMathJax:true});if(m){k.insertBefore(l,k.firstChild)}else{k.appendChild(l)}return l},createSpace:function(o,m,n,p,l,r){if(m<-n){n=-m}var q=this.Em(m+n),j=this.Em(-n);if(this.msieInlineBlockAlignBug){j=this.Em(d.getHD(o.parentNode).d-n)}if(o.isBox||r){var k=(o.scale==null?1:o.scale);o.bbox={exactW:true,h:m*k,d:n*k,w:p*k,rw:p*k,lw:0};o.style.height=q;o.style.verticalAlign=j;o.HH=(m+n)*k}else{o=this.addElement(o,"span",{style:{height:q,verticalAlign:j},isMathJax:true})}if(p>=0){o.style.width=this.Em(p);o.style.display="inline-block";o.style.overflow="hidden"}else{if(this.msieNegativeSpaceBug){o.style.height=""}o.style.marginLeft=this.Em(p);if(d.safariNegativeSpaceBug&&o.parentNode.firstChild==o){this.createBlank(o,0,true)}}if(l&&l!==f.COLOR.TRANSPARENT){o.style.backgroundColor=l;o.style.position="relative"}return o},createRule:function(q,m,o,r,k){if(m<-o){o=-m}var l=d.TeX.min_rule_thickness,n=1;if(r>0&&r*this.em<l){r=l/this.em}if(m+o>0&&(m+o)*this.em<l){n=1/(m+o)*(l/this.em);m*=n;o*=n}if(!k){k="solid"}else{k="solid "+k}k=this.Em(r)+" "+k;var s=(n===1?this.Em(m+o):l+"px"),j=this.Em(-o);var p=this.addElement(q,"span",{style:{borderLeft:k,display:"inline-block",overflow:"hidden",width:0,height:s,verticalAlign:j},bbox:{h:m,d:o,w:r,rw:r,lw:0,exactW:true},noAdjust:true,HH:m+o,isMathJax:true});if(r>0&&p.offsetWidth==0){p.style.width=this.Em(r)}if(q.isBox||q.className=="mspace"){q.bbox=p.bbox,q.HH=m+o}return p},createFrame:function(r,p,q,s,v,k){if(p<-q){q=-p}var o=2*v;if(this.msieFrameSizeBug){if(s<o){s=o}if(p+q<o){p=o-q}}if(this.msieBorderWidthBug){o=0}var u=this.Em(p+q-o),j=this.Em(-q-v),n=this.Em(s-o);var l=this.Em(v)+" "+k;var m=this.addElement(r,"span",{style:{border:l,display:"inline-block",overflow:"hidden",width:n,height:u},bbox:{h:p,d:q,w:s,rw:s,lw:0,exactW:true},noAdjust:true,HH:p+q,isMathJax:true});if(j){m.style.verticalAlign=j}return m},createStack:function(l,n,k){if(this.msiePaddingWidthBug){this.createStrut(l,0)}var m=String(k).match(/%$/);var j=(!m&&k!=null?k:0);l=this.addElement(l,"span",{noAdjust:true,HH:0,isMathJax:true,style:{display:"inline-block",position:"relative",width:(m?"100%":this.Em(j)),height:0}});if(!n){l.parentNode.bbox=l.bbox={exactW:true,h:-this.BIGDIMEN,d:-this.BIGDIMEN,w:j,lw:this.BIGDIMEN,rw:(!m&&k!=null?k:-this.BIGDIMEN)};if(m){l.bbox.width=k}}return l},createBox:function(k,j){var l=this.addElement(k,"span",{style:{position:"absolute"},isBox:true,isMathJax:true});if(j!=null){l.style.width=j}return l},addBox:function(j,k){k.style.position="absolute";k.isBox=k.isMathJax=true;return j.appendChild(k)},placeBox:function(s,q,p,n){s.isMathJax=true;var u=s.parentNode,B=s.bbox,w=u.bbox;if(this.msiePlaceBoxBug){this.addText(s,this.NBSP)}if(this.imgSpaceBug){this.addText(s,this.imgSpace)}var v,E=0;if(s.HH!=null){v=s.HH}else{if(B){v=Math.max(3,B.h+B.d)}else{v=s.offsetHeight/this.em}}if(!s.noAdjust){v+=1;v=Math.round(v*this.em)/this.em;if(this.msieInlineBlockAlignBug){this.addElement(s,"img",{className:"MathJax_strut",border:0,src:"about:blank",isMathJax:true,style:{width:0,height:this.Em(v)}})}else{this.addElement(s,"span",{isMathJax:true,style:{display:"inline-block",width:0,height:this.Em(v)}});if(d.chromeHeightBug){v-=(s.lastChild.offsetHeight-Math.round(v*this.em))/this.em}}}if(B){if(this.initialSkipBug){if(B.lw<0){E=B.lw;d.createBlank(s,-E,true)}if(B.rw>B.w){d.createBlank(s,B.rw-B.w+0.1)}}if(!this.msieClipRectBug&&!B.noclip&&!n){var A=3/this.em;var z=(B.H==null?B.h:B.H),k=(B.D==null?B.d:B.D);var C=v-z-A,o=v+k+A,m=B.lw-3*A,j=1000;if(this.initialSkipBug&&B.lw<0){m=-3*A}if(B.isFixed){j=B.width-m}s.style.clip="rect("+this.Em(C)+" "+this.Em(j)+" "+this.Em(o)+" "+this.Em(m)+")"}}s.style.top=this.Em(-p-v);s.style.left=this.Em(q+E);if(B&&w){if(B.H!=null&&(w.H==null||B.H+p>w.H)){w.H=B.H+p}if(B.D!=null&&(w.D==null||B.D-p>w.D)){w.D=B.D-p}if(B.h+p>w.h){w.h=B.h+p}if(B.d-p>w.d){w.d=B.d-p}if(w.H!=null&&w.H<=w.h){delete w.H}if(w.D!=null&&w.D<=w.d){delete w.D}if(B.w+q>w.w){w.w=B.w+q;if(w.width==null){u.style.width=this.Em(w.w)}}if(B.rw+q>w.rw){w.rw=B.rw+q}if(B.lw+q<w.lw){w.lw=B.lw+q}if(B.width!=null&&!B.isFixed){if(w.width==null){u.style.width=w.width="100%"}s.style.width=B.width}}},alignBox:function(m,s,q){this.placeBox(m,0,q);var o=m.bbox;if(o.isMultiline){return}var k=o.width!=null&&!o.isFixed;var n=0,p=-o.w/2,j="50%";if(this.initialSkipBug){n=o.w-o.rw-0.1;p+=o.lw}if(this.msieMarginScaleBug){p=(p*this.em)+"px"}else{p=this.Em(p)}if(k){p="";j=(50-parseFloat(o.width)/2)+"%"}b.Insert(m.style,({right:{left:"",right:this.Em(n)},center:{left:j,marginLeft:p}})[s])},setStackWidth:function(k,j){if(typeof(j)==="number"){k.style.width=this.Em(Math.max(0,j));var l=k.bbox;if(l){l.w=j;l.exactW=true}l=k.parentNode.bbox;if(l){l.w=j;l.exactW=true}}else{k.style.width=k.parentNode.style.width="100%";if(k.bbox){k.bbox.width=j}if(k.parentNode.bbox){k.parentNode.bbox.width=j}}},createDelimiter:function(t,j,l,p,n){if(!j){t.bbox={h:0,d:0,w:this.TeX.nulldelimiterspace,lw:0};t.bbox.rw=t.bbox.w;this.createSpace(t,t.bbox.h,t.bbox.d,t.bbox.w);return}if(!p){p=1}if(!(l instanceof Array)){l=[l,l]}var s=l[1];l=l[0];var k={alias:j};while(k.alias){j=k.alias;k=this.FONTDATA.DELIMITERS[j];if(!k){k={HW:[0,this.FONTDATA.VARIANT[f.VARIANT.NORMAL]]}}}if(k.load){b.RestartAfter(g.Require(this.fontDir+"/fontdata-"+k.load+".js"))}for(var r=0,o=k.HW.length;r<o;r++){if(k.HW[r][0]*p>=l-0.01||(r==o-1&&!k.stretch)){if(k.HW[r][2]){p*=k.HW[r][2]}if(k.HW[r][3]){j=k.HW[r][3]}var q=this.addElement(t,"span");this.createChar(q,[j,k.HW[r][1]],p,n);t.bbox=q.bbox;t.offset=0.65*t.bbox.w;t.scale=p;return}}if(k.stretch){this["extendDelimiter"+k.dir](t,s,k.stretch,p,n)}},extendDelimiterV:function(z,s,D,E,v){var m=this.createStack(z,true);var u=this.createBox(m),t=this.createBox(m);this.createChar(u,(D.top||D.ext),E,v);this.createChar(t,(D.bot||D.ext),E,v);var l={bbox:{w:0,lw:0,rw:0}},C=l,o;var A=u.bbox.h+u.bbox.d+t.bbox.h+t.bbox.d;var q=-u.bbox.h;this.placeBox(u,0,q,true);q-=u.bbox.d;if(D.mid){C=this.createBox(m);this.createChar(C,D.mid,E,v);A+=C.bbox.h+C.bbox.d}if(D.min&&s<A*D.min){s=A*D.min}if(s>A){l=this.Element("span");this.createChar(l,D.ext,E,v);var B=l.bbox.h+l.bbox.d,j=B-0.05,w,p,x=(D.mid?2:1);p=w=Math.ceil((s-A)/(x*j));if(!D.fullExtenders){j=(s-A)/(x*w)}var r=(w/(w+1))*(B-j);j=B-r;q+=r+j-l.bbox.h;while(x-->0){while(w-->0){if(!this.msieCloneNodeBug){o=l.cloneNode(true)}else{o=this.Element("span");this.createChar(o,D.ext,E,v)}o.bbox=l.bbox;q-=j;this.placeBox(this.addBox(m,o),0,q,true)}q+=r-l.bbox.d;if(D.mid&&x){this.placeBox(C,0,q-C.bbox.h,true);w=p;q+=-(C.bbox.h+C.bbox.d)+r+j-l.bbox.h}}}else{q+=(A-s)/2;if(D.mid){this.placeBox(C,0,q-C.bbox.h,true);q+=-(C.bbox.h+C.bbox.d)}q+=(A-s)/2}this.placeBox(t,0,q-t.bbox.h,true);q-=t.bbox.h+t.bbox.d;z.bbox={w:Math.max(u.bbox.w,l.bbox.w,t.bbox.w,C.bbox.w),lw:Math.min(u.bbox.lw,l.bbox.lw,t.bbox.lw,C.bbox.lw),rw:Math.max(u.bbox.rw,l.bbox.rw,t.bbox.rw,C.bbox.rw),h:0,d:-q,exactW:true};z.scale=E;z.offset=0.55*z.bbox.w;z.isMultiChar=true;this.setStackWidth(m,z.bbox.w)},extendDelimiterH:function(A,m,D,F,v){var q=this.createStack(A,true);var o=this.createBox(q),B=this.createBox(q);this.createChar(o,(D.left||D.rep),F,v);this.createChar(B,(D.right||D.rep),F,v);var j=this.Element("span");this.createChar(j,D.rep,F,v);var C={bbox:{h:-this.BIGDIMEN,d:-this.BIGDIMEN}},l;this.placeBox(o,-o.bbox.lw,0,true);var t=(o.bbox.rw-o.bbox.lw)+(B.bbox.rw-B.bbox.lw)-0.05,s=o.bbox.rw-o.bbox.lw-0.025,u;if(D.mid){C=this.createBox(q);this.createChar(C,D.mid,F,v);t+=C.bbox.w}if(D.min&&m<t*D.min){m=t*D.min}if(m>t){var E=j.bbox.rw-j.bbox.lw,p=E-0.05,y,r,z=(D.mid?2:1);r=y=Math.ceil((m-t)/(z*p));if(!D.fillExtenders){p=(m-t)/(z*y)}u=(y/(y+1))*(E-p);p=E-u;s-=j.bbox.lw+u;while(z-->0){while(y-->0){if(!this.cloneNodeBug){l=j.cloneNode(true)}else{l=this.Element("span");this.createChar(l,D.rep,F,v)}l.bbox=j.bbox;this.placeBox(this.addBox(q,l),s,0,true);s+=p}if(D.mid&&z){this.placeBox(C,s,0,true);s+=C.bbox.w-u;y=r}}}else{s-=(t-m)/2;if(D.mid){this.placeBox(C,s,0,true);s+=C.bbox.w}s-=(t-m)/2}this.placeBox(B,s,0,true);A.bbox={w:s+B.bbox.rw,lw:0,rw:s+B.bbox.rw,H:Math.max(o.bbox.h,j.bbox.h,B.bbox.h,C.bbox.h),D:Math.max(o.bbox.d,j.bbox.d,B.bbox.d,C.bbox.d),h:j.bbox.h,d:j.bbox.d,exactW:true};A.scale=F;A.isMultiChar=true;this.setStackWidth(q,A.bbox.w)},createChar:function(r,o,l,j){r.isMathJax=true;var q=r,s="",n={fonts:[o[1]],noRemap:true};if(j&&j===f.VARIANT.BOLD){n.fonts=[o[1]+"-bold",o[1]]}if(typeof(o[1])!=="string"){n=o[1]}if(o[0] instanceof Array){for(var p=0,k=o[0].length;p<k;p++){s+=String.fromCharCode(o[0][p])}}else{s=String.fromCharCode(o[0])}if(o[4]){l*=o[4]}if(l!==1||o[3]){q=this.addElement(r,"span",{style:{fontSize:this.Percent(l)},scale:l,isMathJax:true});this.handleVariant(q,n,s);r.bbox=q.bbox}else{this.handleVariant(r,n,s)}if(o[2]){r.style.marginLeft=this.Em(o[2])}if(o[3]){r.firstChild.style.verticalAlign=this.Em(o[3]);r.bbox.h+=o[3];if(r.bbox.h<0){r.bbox.h=0}}if(o[5]){r.bbox.h+=o[5]}if(o[6]){r.bbox.d+=o[6]}if(this.AccentBug&&r.bbox.w===0){q.firstChild.nodeValue+=this.NBSP}},positionDelimiter:function(k,j){j-=k.bbox.h;k.bbox.d-=j;k.bbox.h+=j;if(j){if(this.safariVerticalAlignBug||this.konquerorVerticalAlignBug||(this.operaVerticalAlignBug&&k.isMultiChar)){if(k.firstChild.style.display===""&&k.style.top!==""){k=k.firstChild;j-=d.unEm(k.style.top)}k.style.position="relative";k.style.top=this.Em(-j)}else{k.style.verticalAlign=this.Em(j);if(d.ffVerticalAlignBug){d.createRule(k.parentNode,k.bbox.h,0,0)}}}},handleVariant:function(z,o,r){var y="",w,B,s,C,j=z,k=!!z.style.fontFamily;if(r.length===0){return}if(!z.bbox){z.bbox={w:0,h:-this.BIGDIMEN,d:-this.BIGDIMEN,rw:-this.BIGDIMEN,lw:this.BIGDIMEN}}if(!o){o=this.FONTDATA.VARIANT[f.VARIANT.NORMAL]}C=o;for(var A=0,x=r.length;A<x;A++){o=C;w=r.charCodeAt(A);B=r.charAt(A);if(w>=55296&&w<56319){A++;w=(((w-55296)<<10)+(r.charCodeAt(A)-56320))+65536;if(this.FONTDATA.RemapPlane1){var D=this.FONTDATA.RemapPlane1(w,o);w=D.n;o=D.variant}}else{var t,q,u=this.FONTDATA.RANGES;for(t=0,q=u.length;t<q;t++){if(u[t].name==="alpha"&&o.noLowerCase){continue}var p=o["offset"+u[t].offset];if(p&&w>=u[t].low&&w<=u[t].high){if(u[t].remap&&u[t].remap[w]){w=p+u[t].remap[w]}else{w=w-u[t].low+p;if(u[t].add){w+=u[t].add}}if(o["variant"+u[t].offset]){o=this.FONTDATA.VARIANT[o["variant"+u[t].offset]]}break}}}if(o.remap&&o.remap[w]){if(o.remap[w] instanceof Array){var l=o.remap[w];w=l[0];o=this.FONTDATA.VARIANT[l[1]]}else{if(typeof(o.remap[w])==="string"){r=o.remap[w]+r.substr(A+1);A=0;x=r.length;w=r.charCodeAt(0)}else{w=o.remap[w];if(o.remap.variant){o=this.FONTDATA.VARIANT[o.remap.variant]}}}}if(this.FONTDATA.REMAP[w]&&!o.noRemap){w=this.FONTDATA.REMAP[w];if(w instanceof Array){o=this.FONTDATA.VARIANT[w[1]];w=w[0]}if(typeof(w)==="string"){r=w+r.substr(A+1);A=0;x=r.length;w=w.charCodeAt(0)}}s=this.lookupChar(o,w);B=s[w];if(k||(!this.checkFont(s,j.style)&&!B[5].img)){if(y.length){this.addText(j,y);y=""}var v=!!j.style.fontFamily||!!z.style.fontStyle||!!z.style.fontWeight||!s.directory||k;k=false;if(j!==z){v=!this.checkFont(s,z.style);j=z}if(v){j=this.addElement(z,"span",{isMathJax:true,subSpan:true})}this.handleFont(j,s,j!==z)}y=this.handleChar(j,s,B,w,y);if(!(B[5]||{}).space){if(B[0]/1000>z.bbox.h){z.bbox.h=B[0]/1000}if(B[1]/1000>z.bbox.d){z.bbox.d=B[1]/1000}}if(z.bbox.w+B[3]/1000<z.bbox.lw){z.bbox.lw=z.bbox.w+B[3]/1000}if(z.bbox.w+B[4]/1000>z.bbox.rw){z.bbox.rw=z.bbox.w+B[4]/1000}z.bbox.w+=B[2]/1000}if(y.length){this.addText(j,y)}if(z.scale&&z.scale!==1){z.bbox.h*=z.scale;z.bbox.d*=z.scale;z.bbox.w*=z.scale;z.bbox.lw*=z.scale;z.bbox.rw*=z.scale}if(r.length==1&&s.skew&&s.skew[w]){z.bbox.skew=s.skew[w]}},checkFont:function(j,k){var l=(k.fontWeight||"normal");if(l.match(/^\d+$/)){l=(parseInt(l)>=600?"bold":"normal")}return(j.family.replace(/'/g,"")===k.fontFamily.replace(/'/g,"")&&(j.style||"normal")===(k.fontStyle||"normal")&&(j.weight||"normal")===l)},handleFont:function(l,j,n){l.style.fontFamily=j.family;if(!j.directory){l.style.fontSize=Math.floor(100/d.scale+0.5)+"%"}if(!(d.FontFaceBug&&j.isWebFont)){var k=j.style||"normal",m=j.weight||"normal";if(k!=="normal"||n){l.style.fontStyle=k}if(m!=="normal"||n){l.style.fontWeight=m}}},handleChar:function(k,j,r,q,p){var o=r[5];if(o.space){if(p.length){this.addText(k,p)}d.createShift(k,r[2]/1000);return""}if(o.img){return this.handleImg(k,j,r,q,p)}if(o.isUnknown&&this.FONTDATA.DELIMITERS[q]){if(p.length){this.addText(k,p)}var m=k.scale;d.createDelimiter(k,q,0,1,j);if(this.FONTDATA.DELIMITERS[q].dir==="V"){k.style.verticalAlign=this.Em(k.bbox.d);k.bbox.h+=k.bbox.d;k.bbox.d=0}k.scale=m;r[0]=k.bbox.h*1000;r[1]=k.bbox.d*1000;r[2]=k.bbox.w*1000;r[3]=k.bbox.lw*1000;r[4]=k.bbox.rw*1000;return""}if(o.c==null){if(q<=65535){o.c=String.fromCharCode(q)}else{var l=q-65536;o.c=String.fromCharCode((l>>10)+55296)+String.fromCharCode((l&1023)+56320)}}if(o.rfix){this.addText(k,p+o.c);d.createShift(k,o.rfix/1000);return""}if(r[2]||!this.msieAccentBug||p.length){return p+o.c}d.createShift(k,r[3]/1000);d.createShift(k,(r[4]-r[3])/1000);this.addText(k,o.c);d.createShift(k,-r[4]/1000);return""},handleImg:function(k,j,o,m,l){return l},lookupChar:function(o,r){var l,j;if(!o.FONTS){var q=this.FONTDATA.FONTS;var p=(o.fonts||this.FONTDATA.VARIANT.normal.fonts);if(!(p instanceof Array)){p=[p]}if(o.fonts!=p){o.fonts=p}o.FONTS=[];for(l=0,j=p.length;l<j;l++){if(q[p[l]]){o.FONTS.push(q[p[l]]);q[p[l]].name=p[l]}}}for(l=0,j=o.FONTS.length;l<j;l++){var k=o.FONTS[l];if(typeof(k)==="string"){delete o.FONTS;this.loadFont(k)}if(k[r]){if(k[r].length===5){k[r][5]={}}if(d.allowWebFonts&&!k.available){this.loadWebFont(k)}else{return k}}else{this.findBlock(k,r)}}return this.unknownChar(o,r)},unknownChar:function(j,l){var k=(j.defaultFont||{family:d.config.undefinedFamily});if(j.bold){k.weight="bold"}if(j.italic){k.style="italic"}if(!k[l]){k[l]=[800,200,500,0,500,{isUnknown:true}]}b.signal.Post(["HTML-CSS Jax - unknown char",l,j]);return k},findBlock:function(l,q){if(l.Ranges){for(var p=0,k=l.Ranges.length;p<k;p++){if(q<l.Ranges[p][0]){return}if(q<=l.Ranges[p][1]){var o=l.Ranges[p][2];for(var n=l.Ranges.length-1;n>=0;n--){if(l.Ranges[n][2]==o){l.Ranges.splice(n,1)}}this.loadFont(l.directory+"/"+o+".js")}}}},loadFont:function(k){var j=MathJax.Callback.Queue();j.Push(["Require",g,this.fontDir+"/"+k]);if(this.imgFonts){if(!MathJax.isPacked){k=k.replace(/\/([^\/]*)$/,d.imgPacked+"/$1")}j.Push(["Require",g,this.webfontDir+"/png/"+k])}b.RestartAfter(j.Push({}))},loadWebFont:function(j){j.available=j.isWebFont=true;if(d.FontFaceBug){j.family=j.name;if(d.msieFontCSSBug){j.family+="-Web"}}b.RestartAfter(this.Font.loadWebFont(j))},loadWebFontError:function(k,j){b.Startup.signal.Post("HTML-CSS Jax - disable web fonts");k.isWebFont=false;if(this.config.imageFont&&this.config.imageFont===this.fontInUse){this.imgFonts=true;b.Startup.signal.Post("HTML-CSS Jax - switch to image fonts");b.Startup.signal.Post("HTML-CSS Jax - using image fonts");MathJax.Message.Set("Web-Fonts not available -- using image fonts instead",null,3000);g.Require(this.directory+"/imageFonts.js",j)}else{this.allowWebFonts=false;j()}},Element:MathJax.HTML.Element,addElement:MathJax.HTML.addElement,TextNode:MathJax.HTML.TextNode,addText:MathJax.HTML.addText,ucMatch:MathJax.HTML.ucMatch,BIGDIMEN:10000000,ID:0,idPostfix:"",GetID:function(){this.ID++;return this.ID},MATHSPACE:{veryverythinmathspace:1/18,verythinmathspace:2/18,thinmathspace:3/18,mediummathspace:4/18,thickmathspace:5/18,verythickmathspace:6/18,veryverythickmathspace:7/18,negativeveryverythinmathspace:-1/18,negativeverythinmathspace:-2/18,negativethinmathspace:-3/18,negativemediummathspace:-4/18,negativethickmathspace:-5/18,negativeverythickmathspace:-6/18,negativeveryverythickmathspace:-7/18},TeX:{x_height:0.430554,quad:1,num1:0.676508,num2:0.393732,num3:0.44373,denom1:0.685951,denom2:0.344841,sup1:0.412892,sup2:0.362892,sup3:0.288888,sub1:0.15,sub2:0.247217,sup_drop:0.386108,sub_drop:0.05,delim1:2.39,delim2:1,axis_height:0.25,rule_thickness:0.06,big_op_spacing1:0.111111,big_op_spacing2:0.166666,big_op_spacing3:0.2,big_op_spacing4:0.6,big_op_spacing5:0.1,scriptspace:0.1,nulldelimiterspace:0.12,delimiterfactor:901,delimitershortfall:0.1,min_rule_thickness:1.25},NBSP:"\u00A0",rfuzz:0});MathJax.Hub.Register.StartupHook("mml Jax Ready",function(){f=MathJax.ElementJax.mml;f.mbase.Augment({toHTML:function(n){n=this.HTMLcreateSpan(n);if(this.type!="mrow"){n=this.HTMLhandleSize(n)}for(var k=0,j=this.data.length;k<j;k++){if(this.data[k]){this.data[k].toHTML(n)}}var p=this.HTMLcomputeBBox(n);var l=n.bbox.h,o=n.bbox.d;for(k=0,j=p.length;k<j;k++){p[k].HTMLstretchV(n,l,o)}if(p.length){this.HTMLcomputeBBox(n,true)}if(this.HTMLlineBreaks(n)){n=this.HTMLmultiline(n)}this.HTMLhandleSpace(n);this.HTMLhandleColor(n);return n},HTMLlineBreaks:function(){return false},HTMLmultiline:function(){f.mbase.HTMLautoloadFile("multiline")},HTMLcomputeBBox:function(p,o,n,j){if(n==null){n=0}if(j==null){j=this.data.length}var l=p.bbox={exactW:true},q=[];while(n<j){var k=this.data[n];if(!k){continue}if(!o&&k.HTMLcanStretch("Vertical")){q.push(k);k=(k.CoreMO()||k)}this.HTMLcombineBBoxes(k,l);n++}this.HTMLcleanBBox(l);return q},HTMLcombineBBoxes:function(j,k){if(k.w==null){this.HTMLemptyBBox(k)}var m=(j.bbox?j:j.HTMLspanElement());if(!m||!m.bbox){return}var l=m.bbox;if(l.d>k.d){k.d=l.d}if(l.h>k.h){k.h=l.h}if(l.D!=null&&l.D>k.D){k.D=l.D}if(l.H!=null&&l.H>k.H){k.H=l.H}if(m.style.paddingLeft){k.w+=d.unEm(m.style.paddingLeft)*(m.scale||1)}if(k.w+l.lw<k.lw){k.lw=k.w+l.lw}if(k.w+l.rw>k.rw){k.rw=k.w+l.rw}k.w+=l.w;if(m.style.paddingRight){k.w+=d.unEm(m.style.paddingRight)*(m.scale||1)}if(l.width){k.width=l.width}if(l.ic){k.ic=l.ic}else{delete k.ic}if(k.exactW&&!l.exactW){delete k.exactW}},HTMLemptyBBox:function(j){j.h=j.d=j.H=j.D=j.rw=-d.BIGDIMEN;j.w=0;j.lw=d.BIGDIMEN;return j},HTMLcleanBBox:function(j){if(j.h===this.BIGDIMEN){j.h=j.d=j.H=j.D=j.w=j.rw=j.lw=0}if(j.D<=j.d){delete j.D}if(j.H<=j.h){delete j.H}},HTMLzeroBBox:function(){return{h:0,d:0,w:0,lw:0,rw:0}},HTMLcanStretch:function(k){if(this.isEmbellished()){var j=this.Core();if(j&&j!==this){return j.HTMLcanStretch(k)}}return false},HTMLstretchH:function(k,j){return this.HTMLspanElement()},HTMLstretchV:function(k,j,l){return this.HTMLspanElement()},HTMLnotEmpty:function(j){while(j){if((j.type!=="mrow"&&j.type!=="texatom")||j.data.length>1){return true}j=j.data[0]}return false},HTMLmeasureChild:function(k,j){if(this.data[k]){d.Measured(this.data[k].toHTML(j),j)}else{j.bbox=this.HTMLzeroBBox()}},HTMLboxChild:function(k,j){if(this.data[k]){return this.data[k].toHTML(j)}if(!j.bbox){j.bbox=this.HTMLzeroBBox()}return null},HTMLcreateSpan:function(j){if(this.spanID){var k=this.HTMLspanElement();if(k&&(k.parentNode===j||(k.parentNode||{}).parentNode===j)){while(k.firstChild){k.removeChild(k.firstChild)}k.bbox={w:0,h:0,d:0,lw:0,rw:0};k.scale=1;k.isMultChar=k.HH=null;k.style.cssText="";return k}}if(this.href){j=d.addElement(j,"a",{href:this.href,isMathJax:true})}j=d.addElement(j,"span",{className:this.type,isMathJax:true});if(d.imgHeightBug){j.style.display="inline-block"}if(this["class"]){j.className+=" "+this["class"]}if(!this.spanID){this.spanID=d.GetID()}j.id=(this.id||"MathJax-Span-"+this.spanID)+d.idPostfix;j.bbox={w:0,h:0,d:0,lw:0,rw:0};this.styles={};if(this.style){j.style.cssText=this.style;if(j.style.fontSize){this.mathsize=j.style.fontSize;j.style.fontSize=""}this.styles={border:d.getBorders(j),padding:d.getPadding(j)};if(this.styles.border){j.style.border=""}if(this.styles.padding){j.style.padding=""}}if(this.href){j.parentNode.bbox=j.bbox}return j},HTMLspanElement:function(){if(!this.spanID){return null}return document.getElementById((this.id||"MathJax-Span-"+this.spanID)+d.idPostfix)},HTMLhandleVariant:function(k,j,l){d.handleVariant(k,j,l)},HTMLhandleSize:function(j){if(!j.scale){j.scale=this.HTMLgetScale();if(j.scale!==1){j.style.fontSize=d.Percent(j.scale)}}return j},HTMLhandleColor:function(v){var x=this.getValues("mathcolor","color");if(this.mathbackground){x.mathbackground=this.mathbackground}if(this.background){x.background=this.background}if(this.style&&v.style.backgroundColor){x.mathbackground=v.style.backgroundColor;v.style.backgroundColor="transparent"}var s=(this.styles||{}).border,u=(this.styles||{}).padding;if(x.color&&!this.mathcolor){x.mathcolor=x.color}if(x.background&&!this.mathbackground){x.mathbackground=x.background}if(x.mathcolor){v.style.color=x.mathcolor}if((x.mathbackground&&x.mathbackground!==f.COLOR.TRANSPARENT)||s||u){var z=v.bbox,y=(z.exact?0:1/d.em),t=0,r=0,l=v.style.paddingLeft,p=v.style.paddingRight;if(this.isToken){t=z.lw;r=z.rw-z.w}if(l!==""){t+=d.unEm(l)*(v.scale||1)}if(p!==""){r-=d.unEm(p)*(v.scale||1)}var k=(d.PaddingWidthBug||z.keepPadding||z.exactW?0:r-t);var n=Math.max(0,d.getW(v)+k);var w=z.h+z.d,j=-z.d,q=0,o=0;if(n>0){n+=2*y;t-=y}if(w>0){w+=2*y;j-=y}r=-n-t;if(s){r-=s.right;j-=s.bottom;q+=s.left;o+=s.right;z.h+=s.top;z.d+=s.bottom;z.w+=s.left+s.right;z.lw-=s.left;z.rw+=s.right}if(u){w+=u.top+u.bottom;n+=u.left+u.right;r-=u.right;j-=u.bottom;q+=u.left;o+=u.right;z.h+=u.top;z.d+=u.bottom;z.w+=u.left+u.right;z.lw-=u.left;z.rw+=u.right}if(o){v.style.paddingRight=d.Em(o)}var m=d.Element("span",{id:"MathJax-Color-"+this.spanID+d.idPostfix,isMathJax:true,style:{display:"inline-block",backgroundColor:x.mathbackground,width:d.Em(n),height:d.Em(w),verticalAlign:d.Em(j),marginLeft:d.Em(t),marginRight:d.Em(r)}});d.setBorders(m,s);if(z.width){m.style.width=z.width;m.style.marginRight="-"+z.width}if(d.msieInlineBlockAlignBug){m.style.position="relative";m.style.width=m.style.height=0;m.style.verticalAlign=m.style.marginLeft=m.style.marginRight="";m.style.border=m.style.padding="";if(s&&d.msieBorderWidthBug){w+=s.top+s.bottom;n+=s.left+s.right}m.style.width=d.Em(q+y);d.placeBox(d.addElement(m,"span",{noAdjust:true,isMathJax:true,style:{display:"inline-block",position:"absolute",overflow:"hidden",background:(x.mathbackground||"transparent"),width:d.Em(n),height:d.Em(w)}}),t,z.h+y);d.setBorders(m.firstChild,s)}v.parentNode.insertBefore(m,v);if(d.msieColorPositionBug){v.style.position="relative"}return m}return null},HTMLremoveColor:function(){var j=document.getElementById("MathJax-Color-"+this.spanID+d.idPostfix);if(j){j.parentNode.removeChild(j)}},HTMLhandleSpace:function(n){if(this.useMMLspacing){if(this.type!=="mo"){return}var l=this.getValues("scriptlevel","lspace","rspace");if(l.scriptlevel<=0||this.hasValue("lspace")||this.hasValue("rspace")){var k=this.HTMLgetMu(n);l.lspace=Math.max(0,d.length2em(l.lspace,k));l.rspace=Math.max(0,d.length2em(l.rspace,k));var j=this,m=this.Parent();while(m&&m.isEmbellished()&&m.Core()===j){j=m;m=m.Parent();n=j.HTMLspanElement()}if(l.lspace){n.style.paddingLeft=d.Em(l.lspace)}if(l.rspace){n.style.paddingRight=d.Em(l.rspace)}}}else{var o=this.texSpacing();if(o!==""){o=d.length2em(o,this.HTMLgetScale())/(n.scale||1);if(n.style.paddingLeft){o+=d.unEm(n.style.paddingLeft)}n.style.paddingLeft=d.Em(o)}}},HTMLgetScale:function(){var l=1,j=this.getValues("mathsize","scriptlevel","fontsize");if(this.style){var k=this.HTMLspanElement();if(k.style.fontSize!=""){j.fontsize=k.style.fontSize}}if(j.fontsize&&!this.mathsize){j.mathsize=j.fontsize}if(j.scriptlevel!==0){if(j.scriptlevel>2){j.scriptlevel=2}l=Math.pow(this.Get("scriptsizemultiplier"),j.scriptlevel);j.scriptminsize=d.length2em(this.Get("scriptminsize"));if(l<j.scriptminsize){l=j.scriptminsize}}if(this.isToken){l*=d.length2em(j.mathsize)}return l},HTMLgetMu:function(l){var j=1,k=this.getValues("scriptlevel","scriptsizemultiplier");if(l.scale&&l.scale!==1){j=1/l.scale}if(k.scriptlevel!==0){if(k.scriptlevel>2){k.scriptlevel=2}j=Math.sqrt(Math.pow(k.scriptsizemultiplier,k.scriptlevel))}return j},HTMLgetVariant:function(){var j=this.getValues("mathvariant","fontfamily","fontweight","fontstyle");j.hasVariant=this.Get("mathvariant",true);if(!j.hasVariant){j.family=j.fontfamily;j.weight=j.fontweight;j.style=j.fontstyle}if(this.style){var l=this.HTMLspanElement();if(!j.family&&l.style.fontFamily){j.family=l.style.fontFamily}if(!j.weight&&l.style.fontWeight){j.weight=l.style.fontWeight}if(!j.style&&l.style.fontStyle){j.style=l.style.fontStyle}}if(j.weight&&j.weight.match(/^\d+$/)){j.weight=(parseInt(j.weight)>600?"bold":"normal")}var k=j.mathvariant;if(this.variantForm){k="-"+d.fontInUse+"-variant"}if(j.family&&!j.hasVariant){if(!j.weight&&j.mathvariant.match(/bold/)){j.weight="bold"}if(!j.style&&j.mathvariant.match(/italic/)){j.style="italic"}return{FONTS:[],fonts:[],noRemap:true,defaultFont:{family:j.family,style:j.style,weight:j.weight}}}if(j.weight==="bold"){k={normal:f.VARIANT.BOLD,italic:f.VARIANT.BOLDITALIC,fraktur:f.VARIANT.BOLDFRAKTUR,script:f.VARIANT.BOLDSCRIPT,"sans-serif":f.VARIANT.BOLDSANSSERIF,"sans-serif-italic":f.VARIANT.SANSSERIFBOLDITALIC}[k]||k}else{if(j.weight==="normal"){k={bold:f.VARIANT.normal,"bold-italic":f.VARIANT.ITALIC,"bold-fraktur":f.VARIANT.FRAKTUR,"bold-script":f.VARIANT.SCRIPT,"bold-sans-serif":f.VARIANT.SANSSERIF,"sans-serif-bold-italic":f.VARIANT.SANSSERIFITALIC}[k]||k}}if(j.style==="italic"){k={normal:f.VARIANT.ITALIC,bold:f.VARIANT.BOLDITALIC,"sans-serif":f.VARIANT.SANSSERIFITALIC,"bold-sans-serif":f.VARIANT.SANSSERIFBOLDITALIC}[k]||k}else{if(j.style==="normal"){k={italic:f.VARIANT.NORMAL,"bold-italic":f.VARIANT.BOLD,"sans-serif-italic":f.VARIANT.SANSSERIF,"sans-serif-bold-italic":f.VARIANT.BOLDSANSSERIF}[k]||k}}return d.FONTDATA.VARIANT[k]}},{HTMLautoload:function(){var j=d.autoloadDir+"/"+this.type+".js";b.RestartAfter(g.Require(j))},HTMLautoloadFile:function(j){var k=d.autoloadDir+"/"+j+".js";b.RestartAfter(g.Require(k))},HTMLstretchH:function(k,j){this.HTMLremoveColor();return this.toHTML(k,j)},HTMLstretchV:function(k,j,l){this.HTMLremoveColor();return this.toHTML(k,j,l)}});f.chars.Augment({toHTML:function(m,l,k,n){var q=this.data.join("").replace(/[\u2061-\u2064]/g,"");if(k){q=k(q,n)}if(l.fontInherit){var p=Math.floor(100/d.scale+0.5)+"%";d.addElement(m,"span",{style:{"font-size":p}},[q]);if(l.bold){m.lastChild.style.fontWeight="bold"}if(l.italic){m.lastChild.style.fontStyle="italic"}var o=d.getHD(m),j=d.getW(m);m.bbox={h:o.h,d:o.d,w:j,lw:0,rw:j,exactW:true}}else{this.HTMLhandleVariant(m,l,q)}}});f.entity.Augment({toHTML:function(m,l,k,n){var q=this.toString().replace(/[\u2061-\u2064]/g,"");if(k){q=k(q,n)}if(l.fontInherit){var p=Math.floor(100/d.scale+0.5)+"%";d.addElement(m,"span",{style:{"font-size":p}},[q]);if(l.bold){m.lastChild.style.fontWeight="bold"}if(l.italic){m.lastChild.style.fontStyle="italic"}var o=d.getHD(m),j=d.getW(m);m.bbox={h:o.h,d:o.d,w:j,lw:0,rw:j,exactW:true}}else{this.HTMLhandleVariant(m,l,q)}}});f.mi.Augment({toHTML:function(n){n=this.HTMLhandleSize(this.HTMLcreateSpan(n));n.bbox=null;var l=this.HTMLgetVariant();for(var k=0,j=this.data.length;k<j;k++){if(this.data[k]){this.data[k].toHTML(n,l)}}if(!n.bbox){n.bbox={w:0,h:0,d:0,rw:0,lw:0}}var p=this.data.join(""),o=n.bbox;if(o.skew&&p.length!==1){delete o.skew}if(o.rw>o.w&&p.length===1&&!l.noIC){o.ic=o.rw-o.w;d.createBlank(n,o.ic);o.w=o.rw}this.HTMLhandleSpace(n);this.HTMLhandleColor(n);return n}});f.mn.Augment({toHTML:function(n){n=this.HTMLhandleSize(this.HTMLcreateSpan(n));n.bbox=null;var l=this.HTMLgetVariant();for(var k=0,j=this.data.length;k<j;k++){if(this.data[k]){this.data[k].toHTML(n,l)}}if(!n.bbox){n.bbox={w:0,h:0,d:0,rw:0,lw:0}}if(this.data.join("").length!==1){delete n.bbox.skew}this.HTMLhandleSpace(n);this.HTMLhandleColor(n);return n}});f.mo.Augment({toHTML:function(t){t=this.HTMLhandleSize(this.HTMLcreateSpan(t));if(this.data.length==0){return t}else{t.bbox=null}var w=this.data.join("");var o=this.HTMLgetVariant();var v=this.getValues("largeop","displaystyle");if(v.largeop){o=d.FONTDATA.VARIANT[v.displaystyle?"-largeOp":"-smallOp"]}var u=this.CoreParent(),n=(u&&u.isa(f.msubsup)&&this!==u.data[u.base]),k=(n?this.HTMLremapChars:null);if(w.length===1&&u&&u.isa(f.munderover)&&this.CoreText(u.data[u.base]).length===1){var r=u.data[u.over],s=u.data[u.under];if(r&&this===r.CoreMO()&&u.Get("accent")){k=d.FONTDATA.REMAPACCENT}else{if(s&&this===s.CoreMO()&&u.Get("accentunder")){k=d.FONTDATA.REMAPACCENTUNDER}}}if(n&&w.match(/['`"\u00B4\u2032-\u2037\u2057]/)){o=d.FONTDATA.VARIANT["-"+d.fontInUse+"-variant"]}for(var q=0,l=this.data.length;q<l;q++){if(this.data[q]){this.data[q].toHTML(t,o,this.HTMLremap,k)}}if(!t.bbox){t.bbox={w:0,h:0,d:0,rw:0,lw:0}}if(w.length!==1){delete t.bbox.skew}if(d.AccentBug&&t.bbox.w===0&&w.length===1&&t.firstChild){t.firstChild.nodeValue+=d.NBSP;d.createSpace(t,0,0,-t.offsetWidth/d.em)}if(v.largeop){var j=(t.bbox.h-t.bbox.d)/2-d.TeX.axis_height*t.scale;if(d.safariVerticalAlignBug&&t.lastChild.nodeName==="IMG"){t.lastChild.style.verticalAlign=d.Em(d.unEm(t.lastChild.style.verticalAlign||0)/d.em-j/t.scale)}else{if(d.konquerorVerticalAlignBug&&t.lastChild.nodeName==="IMG"){t.style.position="relative";t.lastChild.style.position="relative";t.lastChild.style.top=d.Em(j/t.scale)}else{t.style.verticalAlign=d.Em(-j/t.scale)}}t.bbox.h-=j;t.bbox.d+=j;if(t.bbox.rw>t.bbox.w){t.bbox.ic=t.bbox.rw-t.bbox.w;d.createBlank(t,t.bbox.ic);t.bbox.w=t.bbox.rw}}this.HTMLhandleSpace(t);this.HTMLhandleColor(t);return t},CoreParent:function(){var j=this;while(j&&j.isEmbellished()&&j.CoreMO()===this&&!j.isa(f.math)){j=j.Parent()}return j},CoreText:function(j){if(!j){return""}if(j.isEmbellished()){return j.CoreMO().data.join("")}while((j.isa(f.mrow)||j.isa(f.TeXAtom))&&j.data.length===1&&j.data[0]){j=j.data[0]}if(!j.isToken){return""}else{return j.data.join("")}},HTMLremapChars:{"*":"\u2217",'"':"\u2033","\u00B0":"\u2218","\u00B2":"2","\u00B3":"3","\u00B4":"\u2032","\u00B9":"1"},HTMLremap:function(k,j){k=k.replace(/-/g,"\u2212");if(j){k=k.replace(/'/g,"\u2032").replace(/`/g,"\u2035");if(k.length===1){k=j[k]||k}}return k},HTMLcanStretch:function(m){if(!this.Get("stretchy")){return false}var n=this.data.join("");if(n.length>1){return false}var k=this.CoreParent();if(k&&k.isa(f.munderover)&&this.CoreText(k.data[k.base]).length===1){var l=k.data[k.over],j=k.data[k.under];if(l&&this===l.CoreMO()&&k.Get("accent")){n=d.FONTDATA.REMAPACCENT[n]||n}else{if(j&&this===j.CoreMO()&&k.Get("accentunder")){n=d.FONTDATA.REMAPACCENTUNDER[n]||n}}}n=d.FONTDATA.DELIMITERS[n.charCodeAt(0)];return(n&&n.dir==m.substr(0,1))},HTMLstretchV:function(l,m,n){this.HTMLremoveColor();var q=this.getValues("symmetric","maxsize","minsize");var o=this.HTMLspanElement(),r=this.HTMLgetMu(o),p;var j=d.TeX.axis_height,k=o.scale;if(q.symmetric){p=2*Math.max(m-j,n+j)}else{p=m+n}q.maxsize=d.length2em(q.maxsize,r,o.bbox.h+o.bbox.d);q.minsize=d.length2em(q.minsize,r,o.bbox.h+o.bbox.d);p=Math.max(q.minsize,Math.min(q.maxsize,p));o=this.HTMLcreateSpan(l);d.createDelimiter(o,this.data.join("").charCodeAt(0),p,k);if(q.symmetric){p=(o.bbox.h+o.bbox.d)/2+j}else{p=(o.bbox.h+o.bbox.d)*m/(m+n)}d.positionDelimiter(o,p);this.HTMLhandleSpace(o);this.HTMLhandleColor(o);return o},HTMLstretchH:function(n,j){this.HTMLremoveColor();var l=this.getValues("maxsize","minsize","mathvariant","fontweight");if((l.fontweight==="bold"||parseInt(l.fontweight)>=600)&&!this.Get("mathvariant",true)){l.mathvariant=f.VARIANT.BOLD}var m=this.HTMLspanElement(),k=this.HTMLgetMu(m),o=m.scale;l.maxsize=d.length2em(l.maxsize,k,m.bbox.w);l.minsize=d.length2em(l.minsize,k,m.bbox.w);j=Math.max(l.minsize,Math.min(l.maxsize,j));m=this.HTMLcreateSpan(n);d.createDelimiter(m,this.data.join("").charCodeAt(0),j,o,l.mathvariant);this.HTMLhandleSpace(m);this.HTMLhandleColor(m);return m}});f.mtext.Augment({toHTML:function(n){n=this.HTMLhandleSize(this.HTMLcreateSpan(n));var l=this.HTMLgetVariant();if(d.config.mtextFontInherit||this.Parent().type==="merror"){l={bold:l.bold,italic:l.italic,fontInherit:true}}for(var k=0,j=this.data.length;k<j;k++){if(this.data[k]){this.data[k].toHTML(n,l)}}if(!n.bbox){n.bbox={w:0,h:0,d:0,rw:0,lw:0}}if(this.data.join("").length!==1){delete n.bbox.skew}this.HTMLhandleSpace(n);this.HTMLhandleColor(n);return n}});f.merror.Augment({toHTML:function(k){var m=MathJax.HTML.addElement(k,"span",{style:{display:"inline-block"}});k=this.SUPER(arguments).toHTML.call(this,m);var l=d.getHD(m),j=d.getW(m);m.bbox={h:l.h,d:l.d,w:j,lw:0,rw:j,exactW:true};m.id=k.id;k.id=null;return m}});f.ms.Augment({toHTML:f.mbase.HTMLautoload});f.mglyph.Augment({toHTML:f.mbase.HTMLautoload});f.mspace.Augment({toHTML:function(n){n=this.HTMLcreateSpan(n);var l=this.getValues("height","depth","width");var k=this.HTMLgetMu(n);l.mathbackground=this.mathbackground;if(this.background&&!this.mathbackground){l.mathbackground=this.background}var m=d.length2em(l.height,k),o=d.length2em(l.depth,k),j=d.length2em(l.width,k);d.createSpace(n,m,o,j,l.mathbackground,true);return n}});f.mphantom.Augment({toHTML:function(n,k,p){n=this.HTMLcreateSpan(n);if(this.data[0]!=null){var o=this.data[0].toHTML(n);if(p!=null){d.Remeasured(this.data[0].HTMLstretchV(n,k,p),n)}else{if(k!=null){d.Remeasured(this.data[0].HTMLstretchH(n,k),n)}else{o=d.Measured(o,n)}}n.bbox={w:o.bbox.w,h:o.bbox.h,d:o.bbox.d,lw:0,rw:0,exactW:true};for(var l=0,j=n.childNodes.length;l<j;l++){n.childNodes[l].style.visibility="hidden"}}this.HTMLhandleSpace(n);this.HTMLhandleColor(n);return n},HTMLstretchH:f.mbase.HTMLstretchH,HTMLstretchV:f.mbase.HTMLstretchV});f.mpadded.Augment({toHTML:function(r,l,j){r=this.HTMLcreateSpan(r);if(this.data[0]!=null){var p=d.createStack(r,true);var m=d.createBox(p);var k=this.data[0].toHTML(m);if(j!=null){d.Remeasured(this.data[0].HTMLstretchV(m,l,j),m)}else{if(l!=null){d.Remeasured(this.data[0].HTMLstretchH(m,l),m)}else{d.Measured(k,m)}}var s=this.getValues("height","depth","width","lspace","voffset"),q=0,o=0,t=this.HTMLgetMu(r);if(s.lspace){q=this.HTMLlength2em(m,s.lspace,t)}if(s.voffset){o=this.HTMLlength2em(m,s.voffset,t)}d.placeBox(m,q,o);r.bbox={h:m.bbox.h,d:m.bbox.d,w:m.bbox.w,exactW:true,lw:Math.min(0,m.bbox.lw+q),rw:Math.max(m.bbox.w,m.bbox.rw+q),H:Math.max((m.bbox.H==null?-d.BIGDIMEN:m.bbox.H),m.bbox.h+o),D:Math.max((m.bbox.D==null?-d.BIGDIMEN:m.bbox.D),m.bbox.d-o)};if(s.height!==""){r.bbox.h=this.HTMLlength2em(m,s.height,t,"h",0)}if(s.depth!==""){r.bbox.d=this.HTMLlength2em(m,s.depth,t,"d",0)}if(s.width!==""){r.bbox.w=this.HTMLlength2em(m,s.width,t,"w",0)}if(r.bbox.H<=r.bbox.h){delete r.bbox.H}if(r.bbox.D<=r.bbox.d){delete r.bbox.D}var n=/^\s*(\d+(\.\d*)?|\.\d+)\s*(pt|em|ex|mu|px|pc|in|mm|cm)\s*$/;r.bbox.exact=!!((this.data[0]&&this.data[0].data.length==0)||n.exec(s.height)||n.exec(s.width)||n.exec(s.depth));d.setStackWidth(p,r.bbox.w)}this.HTMLhandleSpace(r);this.HTMLhandleColor(r);return r},HTMLlength2em:function(p,q,k,r,j){if(j==null){j=-d.BIGDIMEN}var n=String(q).match(/width|height|depth/);var o=(n?p.bbox[n[0].charAt(0)]:(r?p.bbox[r]:0));var l=d.length2em(q,k,o);if(r&&String(q).match(/^\s*[-+]/)){return Math.max(j,p.bbox[r]+l)}else{return l}},HTMLstretchH:f.mbase.HTMLstretchH,HTMLstretchV:f.mbase.HTMLstretchV});f.mrow.Augment({HTMLlineBreaks:function(j){if(!this.parent.linebreakContainer){return false}return(d.config.linebreaks.automatic&&j.bbox.w>d.linebreakWidth)||this.hasNewline()},HTMLstretchH:function(l,j){this.HTMLremoveColor();var k=this.HTMLspanElement();this.data[this.core].HTMLstretchH(k,j);this.HTMLcomputeBBox(k,true);this.HTMLhandleColor(k);return k},HTMLstretchV:function(l,k,m){this.HTMLremoveColor();var j=this.HTMLspanElement();this.data[this.core].HTMLstretchV(j,k,m);this.HTMLcomputeBBox(j,true);this.HTMLhandleColor(j);return j}});f.mstyle.Augment({toHTML:function(k,j,l){k=this.HTMLcreateSpan(k);if(this.data[0]!=null){var m=this.data[0].toHTML(k);if(l!=null){this.data[0].HTMLstretchV(k,j,l)}else{if(j!=null){this.data[0].HTMLstretchH(k,j)}}k.bbox=m.bbox}this.HTMLhandleSpace(k);this.HTMLhandleColor(k);return k},HTMLstretchH:f.mbase.HTMLstretchH,HTMLstretchV:f.mbase.HTMLstretchV});f.mfrac.Augment({toHTML:function(C){C=this.HTMLcreateSpan(C);var l=d.createStack(C);var o=d.createBox(l),n=d.createBox(l);d.MeasureSpans([this.HTMLboxChild(0,o),this.HTMLboxChild(1,n)]);var j=this.getValues("displaystyle","linethickness","numalign","denomalign","bevelled");var G=this.HTMLgetScale(),B=j.displaystyle;var F=d.TeX.axis_height*G;if(j.bevelled){var E=(B?0.4:0.15);var r=Math.max(o.bbox.h+o.bbox.d,n.bbox.h+n.bbox.d)+2*E;var D=d.createBox(l);d.createDelimiter(D,47,r);d.placeBox(o,0,(o.bbox.d-o.bbox.h)/2+F+E);d.placeBox(D,o.bbox.w-E/2,(D.bbox.d-D.bbox.h)/2+F);d.placeBox(n,o.bbox.w+D.bbox.w-E,(n.bbox.d-n.bbox.h)/2+F-E)}else{var k=Math.max(o.bbox.w,n.bbox.w);var x=d.thickness2em(j.linethickness,G),z,y,w,s;var A=d.TeX.min_rule_thickness/this.em;if(B){w=d.TeX.num1;s=d.TeX.denom1}else{w=(x===0?d.TeX.num3:d.TeX.num2);s=d.TeX.denom2}w*=G;s*=G;if(x===0){z=Math.max((B?7:3)*d.TeX.rule_thickness,2*A);y=(w-o.bbox.d)-(n.bbox.h-s);if(y<z){w+=(z-y)/2;s+=(z-y)/2}}else{z=Math.max((B?2:0)*A+x,x/2+1.5*A);y=(w-o.bbox.d)-(F+x/2);if(y<z){w+=z-y}y=(F-x/2)-(n.bbox.h-s);if(y<z){s+=z-y}var m=d.createBox(l);d.createRule(m,x,0,k+2*x);d.placeBox(m,0,F-x/2)}d.alignBox(o,j.numalign,w);d.alignBox(n,j.denomalign,-s)}this.HTMLhandleSpace(C);this.HTMLhandleColor(C);return C},HTMLcanStretch:function(j){return false},HTMLhandleSpace:function(j){if(!this.texWithDelims){var k=(this.useMMLspacing?0:d.length2em(this.texSpacing()||0))+0.12;j.style.paddingLeft=d.Em(k);j.style.paddingRight=d.Em(0.12)}}});f.msqrt.Augment({toHTML:function(v){v=this.HTMLcreateSpan(v);var y=d.createStack(v);var m=d.createBox(y),s=d.createBox(y),r=d.createBox(y);var o=this.HTMLgetScale();var z=d.TeX.rule_thickness*o,l,k,w,n;if(this.Get("displaystyle")){l=d.TeX.x_height*o}else{l=z}k=Math.max(z+l/4,1.5*d.TeX.min_rule_thickness/this.em);var j=this.HTMLboxChild(0,m);w=j.bbox.h+j.bbox.d+k+z;d.createDelimiter(r,8730,w,o);d.MeasureSpans([j,r]);n=j.bbox.w;var u=0;if(r.isMultiChar||(d.AdjustSurd&&d.imgFonts)){r.bbox.w*=0.95}if(r.bbox.h+r.bbox.d>w){k=((r.bbox.h+r.bbox.d)-(w-z))/2}var A=d.FONTDATA.DELIMITERS[d.FONTDATA.RULECHAR];if(!A||n<A.HW[0][0]*o||o<0.75){d.createRule(s,0,z,n)}else{d.createDelimiter(s,d.FONTDATA.RULECHAR,n,o)}w=j.bbox.h+k+z;k=w*d.rfuzz;if(r.isMultiChar){k=d.rfuzz}u=this.HTMLaddRoot(y,r,u,r.bbox.h+r.bbox.d-w,o);d.placeBox(r,u,w-r.bbox.h);d.placeBox(s,u+r.bbox.w,w-s.bbox.h+k);d.placeBox(m,u+r.bbox.w,0);this.HTMLhandleSpace(v);this.HTMLhandleColor(v);return v},HTMLaddRoot:function(l,k,j,n,m){return j}});f.mroot.Augment({toHTML:f.msqrt.prototype.toHTML,HTMLaddRoot:function(r,k,p,n,j){var l=d.createBox(r);if(this.data[1]){var o=this.data[1].toHTML(l);o.style.paddingRight=o.style.paddingLeft="";d.Measured(o,l)}else{l.bbox=this.HTMLzeroBBox()}var m=this.HTMLrootHeight(k.bbox.h+k.bbox.d,j,l)-n;var q=Math.min(l.bbox.w,l.bbox.rw);p=Math.max(q,k.offset);d.placeBox(l,p-q,m);return p-k.offset},HTMLrootHeight:function(l,k,j){return 0.45*(l-0.9*k)+0.6*k+Math.max(0,j.bbox.d-0.075)}});f.mfenced.Augment({toHTML:function(n){n=this.HTMLcreateSpan(n);if(this.data.open){this.data.open.toHTML(n)}if(this.data[0]!=null){this.data[0].toHTML(n)}for(var k=1,j=this.data.length;k<j;k++){if(this.data[k]){if(this.data["sep"+k]){this.data["sep"+k].toHTML(n)}this.data[k].toHTML(n)}}if(this.data.close){this.data.close.toHTML(n)}var p=this.HTMLcomputeBBox(n);var l=n.bbox.h,o=n.bbox.d;for(k=0,j=p.length;k<j;k++){p[k].HTMLstretchV(n,l,o)}if(p.length){this.HTMLcomputeBBox(n,true)}this.HTMLhandleSpace(n);this.HTMLhandleColor(n);return n},HTMLcomputeBBox:function(o,n){var k=o.bbox={},p=[];this.HTMLcheckStretchy(this.data.open,k,p,n);this.HTMLcheckStretchy(this.data[0],k,p,n);for(var l=1,j=this.data.length;l<j;l++){if(this.data[l]){this.HTMLcheckStretchy(this.data["sep"+l],k,p,n);this.HTMLcheckStretchy(this.data[l],k,p,n)}}this.HTMLcheckStretchy(this.data.close,k,p,n);this.HTMLcleanBBox(k);return p},HTMLcheckStretchy:function(j,k,m,l){if(j){if(!l&&j.HTMLcanStretch("Vertical")){m.push(j);j=(j.CoreMO()||j)}this.HTMLcombineBBoxes(j,k)}}});f.menclose.Augment({toHTML:f.mbase.HTMLautoload});f.maction.Augment({toHTML:f.mbase.HTMLautoload});f.semantics.Augment({toHTML:function(k,j,l){k=this.HTMLcreateSpan(k);if(this.data[0]!=null){var m=this.data[0].toHTML(k);if(l!=null){this.data[0].HTMLstretchV(k,j,l)}else{if(j!=null){this.data[0].HTMLstretchH(k,j)}}k.bbox=m.bbox}this.HTMLhandleSpace(k);return k},HTMLstretchH:f.mbase.HTMLstretchH,HTMLstretchV:f.mbase.HTMLstretchV});f.munderover.Augment({toHTML:function(K,G,E){var j=this.getValues("displaystyle","accent","accentunder","align");if(!j.displaystyle&&this.data[this.base]!=null&&this.data[this.base].CoreMO().Get("movablelimits")){return f.msubsup.prototype.toHTML.call(this,K)}K=this.HTMLcreateSpan(K);var O=this.HTMLgetScale();var p=d.createStack(K);var q=[],n=[],M=[],v,L,H;for(L=0,H=this.data.length;L<H;L++){if(this.data[L]!=null){v=q[L]=d.createBox(p);n[L]=this.data[L].toHTML(v);if(L==this.base){if(E!=null){this.data[this.base].HTMLstretchV(v,G,E)}else{if(G!=null){this.data[this.base].HTMLstretchH(v,G)}}M[L]=(E==null&&G!=null?false:this.data[L].HTMLcanStretch("Horizontal"))}else{M[L]=this.data[L].HTMLcanStretch("Horizontal")}}}d.MeasureSpans(n);var l=-d.BIGDIMEN,J=l;for(L=0,H=this.data.length;L<H;L++){if(this.data[L]){if(q[L].bbox.w>J){J=q[L].bbox.w}if(!M[L]&&J>l){l=J}}}if(E==null&&G!=null){l=G}else{if(l==-d.BIGDIMEN){l=J}}for(L=J=0,H=this.data.length;L<H;L++){if(this.data[L]){v=q[L];if(M[L]){v.bbox=this.data[L].HTMLstretchH(v,l).bbox}if(v.bbox.w>J){J=v.bbox.w}}}var C=d.TeX.rule_thickness,F=d.FONTDATA.TeX_factor;var o=q[this.base]||{bbox:this.HTMLzeroBBox()};var u,r,z,w,s,B,I,N=0;if(o.bbox.ic){N=1.3*o.bbox.ic+0.05}for(L=0,H=this.data.length;L<H;L++){if(this.data[L]!=null){v=q[L];s=d.TeX.big_op_spacing5*O;var A=(L!=this.base&&j[this.ACCENTS[L]]);if(A&&v.bbox.w<=1/d.em+0.0001){v.bbox.w=v.bbox.rw-v.bbox.lw;v.bbox.noclip=true;if(v.bbox.lw){v.insertBefore(d.createSpace(v.parentNode,0,0,-v.bbox.lw),v.firstChild)}d.createBlank(v,0,0,v.bbox.rw+0.1)}B={left:0,center:(J-v.bbox.w)/2,right:J-v.bbox.w}[j.align];u=B;r=0;if(L==this.over){if(A){I=Math.max(C*O*F,2.5/this.em);s=0;if(o.bbox.skew){u+=o.bbox.skew}}else{z=d.TeX.big_op_spacing1*O*F;w=d.TeX.big_op_spacing3*O*F;I=Math.max(z,w-Math.max(0,v.bbox.d))}I=Math.max(I,1.5/this.em);u+=N/2;r=o.bbox.h+v.bbox.d+I;v.bbox.h+=s}else{if(L==this.under){if(A){I=3*C*O*F;s=0}else{z=d.TeX.big_op_spacing2*O*F;w=d.TeX.big_op_spacing4*O*F;I=Math.max(z,w-v.bbox.h)}I=Math.max(I,1.5/this.em);u-=N/2;r=-(o.bbox.d+v.bbox.h+I);v.bbox.d+=s}}d.placeBox(v,u,r)}}this.HTMLhandleSpace(K);this.HTMLhandleColor(K);return K},HTMLstretchH:f.mbase.HTMLstretchH,HTMLstretchV:f.mbase.HTMLstretchV});f.msubsup.Augment({toHTML:function(J,H,B){J=this.HTMLcreateSpan(J);var M=this.HTMLgetScale(),G=this.HTMLgetMu(J);var o=d.createStack(J),k,m=[];var n=d.createBox(o);if(this.data[this.base]){m.push(this.data[this.base].toHTML(n));if(B!=null){this.data[this.base].HTMLstretchV(n,H,B)}else{if(H!=null){this.data[this.base].HTMLstretchH(n,H)}}}else{n.bbox=this.HTMLzeroBBox()}var K=d.TeX.x_height*M,A=d.TeX.scriptspace*M*0.75;var j,w;if(this.HTMLnotEmpty(this.data[this.sup])){j=d.createBox(o);m.push(this.data[this.sup].toHTML(j))}if(this.HTMLnotEmpty(this.data[this.sub])){w=d.createBox(o);m.push(this.data[this.sub].toHTML(w))}d.MeasureSpans(m);if(j){j.bbox.w+=A;j.bbox.rw=Math.max(j.bbox.w,j.bbox.rw)}if(w){w.bbox.w+=A;w.bbox.rw=Math.max(w.bbox.w,w.bbox.rw)}d.placeBox(n,0,0);var l=(this.data[this.sup]||this.data[this.sub]||this).HTMLgetScale();var E=d.TeX.sup_drop*l,C=d.TeX.sub_drop*l;var y=n.bbox.h-E,x=n.bbox.d+C,L=0,F;if(n.bbox.ic){n.bbox.w-=n.bbox.ic;L=1.3*n.bbox.ic+0.05}if(this.data[this.base]&&(this.data[this.base].type==="mi"||this.data[this.base].type==="mo")){if(this.data[this.base].data.join("").length===1&&n.bbox.scale===1&&!this.data[this.base].Get("largeop")){y=x=0}}var I=this.getValues("subscriptshift","superscriptshift");I.subscriptshift=(I.subscriptshift===""?0:d.length2em(I.subscriptshift,G));I.superscriptshift=(I.superscriptshift===""?0:d.length2em(I.superscriptshift,G));if(!j){if(w){x=Math.max(x,d.TeX.sub1*M,w.bbox.h-(4/5)*K,I.subscriptshift);d.placeBox(w,n.bbox.w,-x,w.bbox)}}else{if(!w){k=this.getValues("displaystyle","texprimestyle");F=d.TeX[(k.displaystyle?"sup1":(k.texprimestyle?"sup3":"sup2"))];y=Math.max(y,F*M,j.bbox.d+(1/4)*K,I.superscriptshift);d.placeBox(j,n.bbox.w+L,y,j.bbox)}else{x=Math.max(x,d.TeX.sub2*M);var z=d.TeX.rule_thickness*M;if((y-j.bbox.d)-(w.bbox.h-x)<3*z){x=3*z-y+j.bbox.d+w.bbox.h;E=(4/5)*K-(y-j.bbox.d);if(E>0){y+=E;x-=E}}d.placeBox(j,n.bbox.w+L,Math.max(y,I.superscriptshift));d.placeBox(w,n.bbox.w,-Math.max(x,I.subscriptshift))}}this.HTMLhandleSpace(J);this.HTMLhandleColor(J);return J},HTMLstretchH:f.mbase.HTMLstretchH,HTMLstretchV:f.mbase.HTMLstretchV});f.mmultiscripts.Augment({toHTML:f.mbase.HTMLautoload});f.mtable.Augment({toHTML:f.mbase.HTMLautoload});f["annotation-xml"].Augment({toHTML:f.mbase.HTMLautoload});f.math.Augment({toHTML:function(t,k){var q=this.Get("alttext");if(q&&q!==""){k.setAttribute("aria-label",q)}var l=d.addElement(t,"nobr",{isMathJax:true});t=this.HTMLcreateSpan(l);var r=d.createStack(t),m=d.createBox(r),s;r.style.fontSize=l.parentNode.style.fontSize;l.parentNode.style.fontSize="";if(this.data[0]!=null){if(d.msieColorBug){if(this.background){this.data[0].background=this.background;delete this.background}if(this.mathbackground){this.data[0].mathbackground=this.mathbackground;delete this.mathbackground}}f.mbase.prototype.displayAlign=b.config.displayAlign;f.mbase.prototype.displayIndent=b.config.displayIndent;var n=this.data[0].toHTML(m);n.bbox.exactW=false;s=d.Measured(n,m)}d.placeBox(m,0,0);r.style.width=Math.round(d.unEm(r.style.width)*this.em)+"px";var j=1/d.em,o=d.em/d.outerEm;d.em/=o;t.bbox.h*=o;t.bbox.d*=o;t.bbox.w*=o;t.bbox.lw*=o;t.bbox.rw*=o;if(s&&s.bbox.width!=null){r.style.width=s.bbox.width;m.style.width="100%"}this.HTMLhandleColor(t);if(s){d.createRule(t,(s.bbox.h+j)*o,(s.bbox.d+j)*o,0)}if(!this.isMultiline&&this.Get("display")==="block"&&t.bbox.width==null){var u=this.getValues("indentalignfirst","indentshiftfirst","indentalign","indentshift");if(u.indentalignfirst!==f.INDENTALIGN.INDENTALIGN){u.indentalign=u.indentalignfirst}if(u.indentalign===f.INDENTALIGN.AUTO){u.indentalign=this.displayAlign}k.style.textAlign=u.indentalign;if(u.indentshiftfirst!==f.INDENTSHIFT.INDENTSHIFT){u.indentshift=u.indentshiftfirst}if(u.indentshift==="auto"){u.indentshift=this.displayIndent}if(u.indentshift&&u.indentalign!==f.INDENTALIGN.CENTER){t.style[{left:"marginLeft",right:"marginRight"}[u.indentalign]]=d.Em(d.length2em(u.indentshift))}}return t},HTMLspanElement:f.mbase.prototype.HTMLspanElement});f.TeXAtom.Augment({toHTML:function(k){k=this.HTMLcreateSpan(k);if(this.data[0]!=null){if(this.texClass===f.TEXCLASS.VCENTER){var j=d.createStack(k);var l=d.createBox(j);d.Measured(this.data[0].toHTML(l),l);d.placeBox(l,0,d.TeX.axis_height-(l.bbox.h+l.bbox.d)/2+l.bbox.d)}else{k.bbox=this.data[0].toHTML(k).bbox}}this.HTMLhandleSpace(k);this.HTMLhandleColor(k);return k}});MathJax.Hub.Register.StartupHook("onLoad",function(){setTimeout(MathJax.Callback(["loadComplete",d,"jax.js"]),0)})});b.Register.StartupHook("End Config",function(){b.Browser.Select({MSIE:function(j){var n=(document.documentMode||0);var m=j.versionAtLeast("7.0");var l=j.versionAtLeast("8.0")&&n>7;var k=(document.compatMode==="BackCompat");if(n<9){d.config.styles[".MathJax .MathJax_HitBox"]["background-color"]="white";d.config.styles[".MathJax .MathJax_HitBox"].opacity=0;d.config.styles[".MathJax .MathJax_HitBox"].filter="alpha(opacity=0)"}d.Augment({PaddingWidthBug:true,msieAccentBug:true,msieColorBug:true,msieColorPositionBug:true,msieRelativeWidthBug:k,msieDisappearingBug:(n>=8),msieMarginScaleBug:(n<8),msiePaddingWidthBug:true,msieBorderWidthBug:k,msieFrameSizeBug:(n<=8),msieInlineBlockAlignBug:(!l||k),msiePlaceBoxBug:(l&&!k),msieClipRectBug:!l,msieNegativeSpaceBug:k,cloneNodeBug:(l&&j.version==="8.0"),initialSkipBug:(n<8),msieNegativeBBoxBug:(n>=8),msieIE6:!m,msieItalicWidthBug:true,FontFaceBug:true,msieFontCSSBug:j.isIE9,allowWebFonts:(n>=9?"woff":"eot")})},Firefox:function(k){var l=false;if(k.versionAtLeast("3.5")){var j=String(document.location).replace(/[^\/]*$/,"");if(document.location.protocol!=="file:"||b.config.root.match(/^https?:\/\//)||(b.config.root+"/").substr(0,j.length)===j){l="otf"}}d.Augment({ffVerticalAlignBug:true,AccentBug:true,allowWebFonts:l})},Safari:function(o){var m=o.versionAtLeast("3.0");var l=o.versionAtLeast("3.1");var j=navigator.appVersion.match(/ Safari\/\d/)&&navigator.appVersion.match(/ Version\/\d/)&&navigator.vendor.match(/Apple/);var k=(navigator.appVersion.match(/ Android (\d+)\.(\d+)/));var p=(l&&o.isMobile&&((navigator.platform.match(/iPad|iPod|iPhone/)&&!o.versionAtLeast("5.0"))||(k!=null&&(k[1]<2||(k[1]==2&&k[2]<2)))));d.Augment({config:{styles:{".MathJax img, .MathJax nobr, .MathJax a":{"max-width":"5000em","max-height":"5000em"}}},rfuzz:0.011,AccentBug:true,AdjustSurd:true,negativeBBoxes:true,safariNegativeSpaceBug:true,safariVerticalAlignBug:!l,safariTextNodeBug:!m,forceReflow:true,allowWebFonts:(l&&!p?"otf":false)});if(j){d.Augment({webFontDefault:(o.isMobile?"sans-serif":"serif")})}if(o.isPC){d.Augment({adjustAvailableFonts:d.removeSTIXfonts,checkWebFontsTwice:true})}if(p){var n=b.config["HTML-CSS"];if(n){n.availableFonts=[];n.preferredFont=null}else{b.config["HTML-CSS"]={availableFonts:[],preferredFont:null}}}},Chrome:function(j){d.Augment({Em:d.Px,unEm:d.unPx,chromeHeightBug:true,cloneNodeBug:true,rfuzz:0.011,AccentBug:true,AdjustSurd:true,negativeBBoxes:true,safariNegativeSpaceBug:true,safariWebFontSerif:[""],forceReflow:true,allowWebFonts:(j.versionAtLeast("4.0")?"otf":"svg")})},Opera:function(j){j.isMini=(navigator.appVersion.match("Opera Mini")!=null);d.config.styles[".MathJax .merror"]["vertical-align"]=null;d.config.styles[".MathJax span"]["z-index"]=0;d.Augment({operaHeightBug:true,operaVerticalAlignBug:true,operaFontSizeBug:j.versionAtLeast("10.61"),initialSkipBug:true,FontFaceBug:true,PaddingWidthBug:true,allowWebFonts:(j.versionAtLeast("10.0")&&!j.isMini?"otf":false),adjustAvailableFonts:d.removeSTIXfonts})},Konqueror:function(j){d.Augment({konquerorVerticalAlignBug:true})}})});MathJax.Hub.Register.StartupHook("End Cookie",function(){if(b.config.menuSettings.zoom!=="None"){g.Require("[MathJax]/extensions/MathZoom.js")}})})(MathJax.Ajax,MathJax.Hub,MathJax.OutputJax["HTML-CSS"]);

MathJax.Hub.Register.StartupHook("HTML-CSS Jax Ready",function(){var c="2.1";var a=MathJax.ElementJax.mml,b=MathJax.OutputJax["HTML-CSS"];a.mtable.Augment({toHTML:function(r){r=this.HTMLcreateSpan(r);if(this.data.length===0){return r}var G=this.getValues("columnalign","rowalign","columnspacing","rowspacing","columnwidth","equalcolumns","equalrows","columnlines","rowlines","frame","framespacing","align","useHeight","width","side","minlabelspacing");var aF=G.width.match(/%$/);var av=b.createStack(r);var aC=this.HTMLgetScale(),ax=this.HTMLgetMu(r),ay=-1;var ao=[],ar=[],ai=[],au=[],at=[],ad,ac,an=-1,ab,am,V,aB,O,az,aK=[];var aj=b.FONTDATA.baselineskip*aC*G.useHeight,aP,E=b.FONTDATA.lineH*aC,L=b.FONTDATA.lineD*aC;for(ad=0,ab=this.data.length;ad<ab;ad++){aB=this.data[ad];V=(aB.type==="mlabeledtr"?ay:0);au[ad]=[];ao[ad]=ar[ad]=0;for(ac=V,am=aB.data.length+V;ac<am;ac++){if(ai[ac]==null){if(ac>an){an=ac}at[ac]=b.createStack(b.createBox(av));ai[ac]=-b.BIGDIMEN}au[ad][ac]=b.createBox(at[ac]);aK.push(aB.data[ac-V].toHTML(au[ad][ac]))}}b.MeasureSpans(aK);for(ad=0,ab=this.data.length;ad<ab;ad++){aB=this.data[ad];V=(aB.type==="mlabeledtr"?ay:0);for(ac=V,am=aB.data.length+V;ac<am;ac++){O=aB.data[ac-V];if(O.isMultiline){au[ad][ac].style.width="100%"}if(O.isEmbellished()){az=O.CoreMO();var aO=az.Get("minsize",true);if(aO){var aH=az.HTMLspanElement().bbox;if(az.HTMLcanStretch("Vertical")){aP=aH.h+aH.d;if(aP){aO=b.length2em(aO,ax,aP);if(aO*aH.h/aP>ao[ac]){ao[ac]=aO*aH.h/aP}if(aO*aH.d/aP>ar[ac]){ar[ac]=aO*aH.d/aP}}}else{if(az.HTMLcanStretch("Horizontal")){aO=b.length2em(aO,ax,aH.w);if(aO>ai[ac]){ai[ac]=aO}}}}}if(au[ad][ac].bbox.h>ao[ad]){ao[ad]=au[ad][ac].bbox.h}if(au[ad][ac].bbox.d>ar[ad]){ar[ad]=au[ad][ac].bbox.d}if(au[ad][ac].bbox.w>ai[ac]){ai[ac]=au[ad][ac].bbox.w}}}if(ao[0]+ar[0]){ao[0]=Math.max(ao[0],E)}if(ao[au.length-1]+ar[au.length-1]){ar[au.length-1]=Math.max(ar[au.length-1],L)}var aw=G.columnspacing.split(/ /),aM=G.rowspacing.split(/ /),e=G.columnalign.split(/ /),z=G.rowalign.split(/ /),d=G.columnlines.split(/ /),v=G.rowlines.split(/ /),aI=G.columnwidth.split(/ /),T=[];for(ad=0,ab=aw.length;ad<ab;ad++){aw[ad]=b.length2em(aw[ad],ax)}for(ad=0,ab=aM.length;ad<ab;ad++){aM[ad]=b.length2em(aM[ad],ax)}while(aw.length<an){aw.push(aw[aw.length-1])}while(e.length<=an){e.push(e[e.length-1])}while(d.length<an){d.push(d[d.length-1])}while(aI.length<=an){aI.push(aI[aI.length-1])}while(aM.length<au.length){aM.push(aM[aM.length-1])}while(z.length<=au.length){z.push(z[z.length-1])}while(v.length<au.length){v.push(v[v.length-1])}if(at[ay]){e[ay]=(G.side.substr(0,1)==="l"?"left":"right");aw[ay]=-ai[ay]}for(ad=0,ab=au.length;ad<ab;ad++){aB=this.data[ad];T[ad]=[];if(aB.rowalign){z[ad]=aB.rowalign}if(aB.columnalign){T[ad]=aB.columnalign.split(/ /);while(T[ad].length<=an){T[ad].push(T[ad][T[ad].length-1])}}}if(G.equalrows){var aA=Math.max.apply(Math,ao),U=Math.max.apply(Math,ar);for(ad=0,ab=au.length;ad<ab;ad++){V=((aA+U)-(ao[ad]+ar[ad]))/2;ao[ad]+=V;ar[ad]+=V}}aP=ao[0]+ar[au.length-1];for(ad=0,ab=au.length-1;ad<ab;ad++){aP+=Math.max((ao[ad]+ar[ad]?aj:0),ar[ad]+ao[ad+1]+aM[ad])}var aE=0,aD=0,aR,g=aP;if(G.frame!=="none"||(G.columnlines+G.rowlines).match(/solid|dashed/)){aE=b.length2em(G.framespacing.split(/[, ]+/)[0],ax);aD=b.length2em(G.framespacing.split(/[, ]+/)[1],ax);g=aP+2*aD}var ah,aQ,Z="";if(typeof(G.align)!=="string"){G.align=String(G.align)}if(G.align.match(/(top|bottom|center|baseline|axis)( +(-?\d+))?/)){Z=RegExp.$3;G.align=RegExp.$1}else{G.align=this.defaults.align}if(Z!==""){Z=parseInt(Z);if(Z<0){Z=au.length+1+Z}if(Z<1){Z=1}else{if(Z>au.length){Z=au.length}}ah=0;aQ=-(aP+aD)+ao[0];for(ad=0,ab=Z-1;ad<ab;ad++){var K=Math.max((ao[ad]+ar[ad]?aj:0),ar[ad]+ao[ad+1]+aM[ad]);ah+=K;aQ+=K}}else{ah=({top:-(ao[0]+aD),bottom:aP+aD-ao[0],center:aP/2-ao[0],baseline:aP/2-ao[0],axis:aP/2+b.TeX.axis_height*aC-ao[0]})[G.align];aQ=({top:-(aP+2*aD),bottom:0,center:-(aP/2+aD),baseline:-(aP/2+aD),axis:b.TeX.axis_height*aC-aP/2-aD})[G.align]}var aa,ae=0,w=0,I=0,X=0,af=0,al=[],aq=[],Q=1;if(G.equalcolumns&&G.width!=="auto"){if(aF){aa=(100/(an+1)).toFixed(2).replace(/\.?0+$/,"")+"%";for(ad=0,ab=Math.min(an+1,aI.length);ad<ab;ad++){aI[ad]=aa}aa=0;ae=1;af=an+1;for(ad=0,ab=Math.min(an+1,aw.length);ad<ab;ad++){aa+=aw[ad]}}else{aa=b.length2em(G.width,ax);for(ad=0,ab=Math.min(an+1,aw.length);ad<ab;ad++){aa-=aw[ad]}aa/=an+1;for(ad=0,ab=Math.min(an+1,aI.length);ad<ab;ad++){ai[ad]=aa}}}else{for(ad=0,ab=Math.min(an+1,aI.length);ad<ab;ad++){if(aI[ad]==="auto"){w+=ai[ad]}else{if(aI[ad]==="fit"){aq[af]=ad;af++;w+=ai[ad]}else{if(aI[ad].match(/%$/)){al[X]=ad;X++;I+=ai[ad];ae+=b.length2em(aI[ad],ax,1)}else{ai[ad]=b.length2em(aI[ad],ax);w+=ai[ad]}}}}if(aF){aa=0;for(ad=0,ab=Math.min(an,aw.length);ad<ab;ad++){aa+=aw[ad]}if(ae>0.98){Q=0.98/ae;ae=0.98}}else{if(G.width==="auto"){if(ae>0.98){Q=I/(w+I);aa=w+I}else{aa=w/(1-ae)}}else{aa=b.length2em(G.width,ax);for(ad=0,ab=Math.min(an+1,aw.length);ad<ab;ad++){aa-=aw[ad]}}for(ad=0,ab=al.length;ad<ab;ad++){ai[al[ad]]=b.length2em(aI[al[ad]],ax,aa*Q);w+=ai[al[ad]]}if(Math.abs(aa-w)>0.01){if(af&&aa>w){aa=(aa-w)/af;for(ad=0,ab=aq.length;ad<ab;ad++){ai[aq[ad]]+=aa}}else{aa=aa/w;for(ac=0;ac<=an;ac++){ai[ac]*=aa}}}if(G.equalcolumns){var N=Math.max.apply(Math,ai);for(ac=0;ac<=an;ac++){ai[ac]=N}}}}var R=ah,o,q,aN;V=(at[ay]?ay:0);for(ac=V;ac<=an;ac++){for(ad=0,ab=au.length;ad<ab;ad++){if(au[ad][ac]){V=(this.data[ad].type==="mlabeledtr"?ay:0);O=this.data[ad].data[ac-V];if(O.HTMLcanStretch("Horizontal")){au[ad][ac].bbox=O.HTMLstretchH(at[ac],ai[ac]).bbox}else{if(O.HTMLcanStretch("Vertical")){az=O.CoreMO();var aG=az.symmetric;az.symmetric=false;au[ad][ac].bbox=O.HTMLstretchV(at[ac],ao[ad],ar[ad]).bbox;au[ad][ac].HH=null;az.symmetric=aG}}aN=O.rowalign||this.data[ad].rowalign||z[ad];o=({top:ao[ad]-au[ad][ac].bbox.h,bottom:au[ad][ac].bbox.d-ar[ad],center:((ao[ad]-ar[ad])-(au[ad][ac].bbox.h-au[ad][ac].bbox.d))/2,baseline:0,axis:0})[aN]||0;aN=(O.columnalign||T[ad][ac]||e[ac]);b.alignBox(au[ad][ac],aN,R+o)}if(ad<au.length-1){R-=Math.max((ao[ad]+ar[ad]?aj:0),ar[ad]+ao[ad+1]+aM[ad])}}R=ah}if(aF){var B=b.createBox(av);B.style.left=B.style.top=0;B.style.right=b.Em(aa+2*aE);B.style.display="inline-block";B.style.height="0px";if(b.msieRelativeWidthBug){B=b.createBox(B);B.style.position="relative";B.style.height="1em";B.style.width="100%";B.bbox=av.bbox}var aL=0,aS=aE,k,l;if(af){k=100*(1-ae)/af,l=w/af}else{k=100*(1-ae)/(an+1);l=w/(an+1)}for(ac=0;ac<=an;ac++){b.placeBox(at[ac].parentNode,0,0);at[ac].style.position="relative";at[ac].style.left=b.Em(aS);at[ac].style.width="100%";at[ac].parentNode.parentNode.removeChild(at[ac].parentNode);var ak=b.createBox(B);b.addBox(ak,at[ac]);at[ac]=ak;var h=ak.style;h.display="inline-block";h.left=aL+"%";if(aI[ac].match(/%$/)){var t=parseFloat(aI[ac])*Q;if(af===0){h.width=(k+t)+"%";aL+=k+t;ak=b.createBox(ak);b.addBox(ak,at[ac].firstChild);ak.style.left=0;ak.style.right=b.Em(l);aS-=l}else{h.width=t+"%";aL+=t}}else{if(aI[ac]==="fit"||af===0){h.width=k+"%";ak=b.createBox(ak);b.addBox(ak,at[ac].firstChild);ak.style.left=0;ak.style.right=b.Em(l-ai[ac]);aS+=ai[ac]-l;aL+=k}else{h.width=b.Em(ai[ac]);aS+=ai[ac]}}if(b.msieRelativeWidthBug){b.addText(ak.firstChild,b.NBSP);ak.firstChild.style.position="relative"}aS+=aw[ac];if(d[ac]!=="none"&&ac<an&&ac!==ay){q=b.createBox(B);q.style.left=aL+"%";q=b.createRule(q,g,0,1.25/b.em);q.style.position="absolute";q.bbox={h:g,d:0,w:0,rw:1.25/b.em,lw:0};q.parentNode.bbox=av.bbox;b.placeBox(q,aS-aw[ac]/2,aQ,true);q.style.borderStyle=d[ac]}}}else{var S=aE;for(ac=0;ac<=an;ac++){if(!at[ac].bbox.width){b.setStackWidth(at[ac],ai[ac])}if(aI[ac]!=="auto"&&aI[ac]!=="fit"){at[ac].bbox.width=ai[ac];at[ac].bbox.isFixed=true}b.placeBox(at[ac].parentNode,S,0);S+=ai[ac]+aw[ac];if(d[ac]!=="none"&&ac<an&&ac!==ay){q=b.createRule(av,g,0,1.25/b.em);b.addBox(av,q);q.bbox={h:g,d:0,w:0,rw:1.25/b.em,lw:0};b.placeBox(q,S-aw[ac]/2,aQ,true);q.style.borderStyle=d[ac]}}}av.bbox.d=-aQ;av.bbox.h=g+aQ;b.setStackWidth(av,av.bbox.w+aE);aR=av.bbox.w;var ag;if(G.frame!=="none"){ag=b.createFrame(av,g,0,aR,1.25/b.em,G.frame);b.addBox(av,ag);b.placeBox(ag,0,aQ,true);if(aF){ag.style.width="100%"}}R=ah;for(ad=0,ab=au.length-1;ad<ab;ad++){o=Math.max(aj,ar[ad]+ao[ad+1]+aM[ad]);if(v[ad]!=="none"){q=b.createRule(av,1.25/b.em,0,aR);b.addBox(av,q);q.bbox={h:1.25/b.em,d:0,w:aR,rw:aR,lw:0};b.placeBox(q,0,R-ar[ad]-(o-ar[ad]-ao[ad+1])/2,true);if(v[ad]==="dashed"||aF){q.style.borderTop=q.style.height+" "+v[ad];q.style.height=0;q.style.width=q.style.borderLeftWidth;q.style.borderLeft="";if(aF){q.style.width="100%"}}}R-=o}if(aF){r.bbox.width=G.width;av.style.width="100%"}if(at[ay]){var ap=this.getValues("indentalignfirst","indentshiftfirst","indentalign","indentshift");if(ap.indentalignfirst!==a.INDENTALIGN.INDENTALIGN){ap.indentalign=ap.indentalignfirst}if(ap.indentalign===a.INDENTALIGN.AUTO){ap.indentalign=this.displayAlign}if(ap.indentshiftfirst!==a.INDENTSHIFT.INDENTSHIFT){ap.indentshift=ap.indentshiftfirst}if(ap.indentshift==="auto"){ap.indentshift=this.displayIndent}var aJ=b.createStack(r,false,"100%");b.addBox(aJ,av);b.alignBox(av,ap.indentalign,0);if(ap.indentshift&&ap.indentalign!==a.INDENTALIGN.CENTER){av.style[ap.indentalign]=b.Em(b.length2em(ap.indentshift,ax))}at[ay].parentNode.parentNode.removeChild(at[ay].parentNode);b.addBox(aJ,at[ay]);b.alignBox(at[ay],e[ay],0);if(b.msieRelativeWidthBug){av.style.top=at[ay].style.top=""}if(aF){av.style.width=G.width;r.bbox.width="100%"}at[ay].style.marginRight=at[ay].style.marginLeft=b.Em(b.length2em(G.minlabelspacing,ax))}if(!aF){this.HTMLhandleSpace(r)}var u=this.HTMLhandleColor(r);if(u&&aF){if(!ag){ag=b.createFrame(av,g,0,aR,0,"none");b.addBox(av,ag);b.placeBox(ag,0,aQ,true);ag.style.width="100%"}ag.style.backgroundColor=u.style.backgroundColor;ag.parentNode.insertBefore(ag,ag.parentNode.firstChild);u.parentNode.removeChild(u)}return r},HTMLhandleSpace:function(d){d.bbox.keepPadding=true;d.bbox.exact=true;if(!this.hasFrame){d.style.paddingLeft=d.style.paddingRight=b.Em(1/6)}this.SUPER(arguments).HTMLhandleSpace.call(this,d)}});a.mtd.Augment({toHTML:function(e,d,g){e=this.HTMLcreateSpan(e);if(this.data[0]){var f=this.data[0].toHTML(e);if(g!=null){f=this.data[0].HTMLstretchV(e,d,g)}else{if(d!=null){f=this.data[0].HTMLstretchH(e,d)}}e.bbox=f.bbox}this.HTMLhandleSpace(e);this.HTMLhandleColor(e);return e},HTMLstretchH:a.mbase.HTMLstretchH,HTMLstretchV:a.mbase.HTMLstretchV});MathJax.Hub.Startup.signal.Post("HTML-CSS mtable Ready");MathJax.Ajax.loadComplete(b.autoloadDir+"/mtable.js")});

MathJax.Ajax.loadComplete("[MathJax]/config/AM_HTMLorMML-full.js");
